/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.migration.v173_retrieve_test_suggestion;

import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.IPointwiseStorageMigrator;
import com.teamscale.index.migration.ClassNameMigrator;
import com.teamscale.index.migration.v173_retrieve_test_suggestion.V173EProjectPermission;
import com.teamscale.index.migration.v173_retrieve_test_suggestion.V173ProjectRole;
import com.teamscale.index.migration.v173_retrieve_test_suggestion.V173RoleBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.LZ4Utils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion173RetrieveTestSuggestion
implements IPointwiseStorageMigrator {
    private static final String PROJECT_ROLE_KEY = "PROJECT_ROLE#";
    private final ClassNameMigrator permissionClassNameMigrator = new ClassNameMigrator();

    public MigrateVersion173RetrieveTestSuggestion() {
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.EProjectPermission", V173EProjectPermission.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.RoleBase", V173RoleBase.class);
        this.permissionClassNameMigrator.registerIntermediateClass("com.teamscale.core.permissions.roles.ProjectRole", V173ProjectRole.class);
    }

    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V173;
    }

    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    public String getStoreName() {
        return "permissions";
    }

    public PairList<byte[], byte[]> migrate(byte[] key, byte[] value) throws StorageException {
        V173ProjectRole projectRole;
        String stringKey = StringUtils.bytesToString((byte[])key);
        if (stringKey.startsWith(PROJECT_ROLE_KEY) && ((projectRole = (V173ProjectRole)this.permissionClassNameMigrator.deserialize(LZ4Utils.decompress((byte[])value))).getPermissions().contains((Object)V173EProjectPermission.VIEW) || stringKey.equals("PROJECT_ROLE#Build"))) {
            projectRole.addPermission(V173EProjectPermission.RETRIEVE_TEST_SUGGESTIONS);
            return PairList.from((Object)key, (Object)LZ4Utils.compress((byte[])this.permissionClassNameMigrator.serialize(projectRole)));
        }
        return PairList.from((Object)key, (Object)value);
    }
}

