/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.findings;

import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.index.architecture.ArchitectureFindingCreator;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.commit_alert.CommitAlert;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationMailHelperBase;
import com.teamscale.index.notifications.findings.EFindingsNotificationTrigger;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriter;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class FindingsNotificationMailHelper
extends NotificationMailHelperBase {
    private static final int MAX_ITEMS_PER_ACTIVATED_TRIGGER = 10;
    private final @Nullable FindingChurnList findingChurnList;
    private final CommitAlerts commitAlerts;
    private final EnumSet<EFindingsNotificationTrigger> activatedTriggers;
    private final Map<String, FindingBlacklistInfo> blacklistedFindings;

    public FindingsNotificationMailHelper(NotificationContext notificationContext) throws StorageException {
        super(notificationContext);
        this.findingChurnList = (FindingChurnList)((FindingChurnListIndex)notificationContext.getProjectStorageSystem().openProjectIndex(FindingChurnListIndex.class, null)).getEntry(notificationContext.getCommit());
        this.commitAlerts = (CommitAlerts)((CommitAlertIndex)notificationContext.getProjectStorageSystem().openProjectIndex(CommitAlertIndex.class, null)).getEntry(notificationContext.getCommit());
        this.activatedTriggers = this.determineActivatedNotificationTriggers();
        this.blacklistedFindings = new HashMap<String, FindingBlacklistInfo>();
        if (this.findingChurnList != null) {
            List<FindingBlacklistInfo> filteredBlackListedFindings = this.determineBlacklistedFindings(this.findingChurnList);
            for (FindingBlacklistInfo blacklistInfo : filteredBlackListedFindings) {
                this.blacklistedFindings.put(blacklistInfo.getFindingId(), blacklistInfo);
            }
        }
    }

    private List<FindingBlacklistInfo> determineBlacklistedFindings(FindingChurnList findingChurnList) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)this.notificationContext.getCommit().getBranchName(), (long)this.notificationContext.getCommit().getTimestamp());
        return CollectionUtils.filterNullEntries(((FindingBlacklistIndex)this.notificationContext.getProjectStorageSystem().openProjectIndex(FindingBlacklistIndex.class, historyAccessOption)).getBlacklistInfos(new ArrayList<String>(findingChurnList.getAllFindings().keySet())));
    }

    private Set<String> getViolatedArchitectures() {
        HashSet<String> violatedArchitectures = new HashSet<String>();
        @Nullable FindingChurnList findingsChurn = this.getFindingChurnList();
        if (findingsChurn == null) {
            return violatedArchitectures;
        }
        for (TrackedFinding finding : findingsChurn.getAllFindings().values()) {
            if (!finding.getTypeId().equals(ArchitectureFindingCreator.FINDING_TYPE_ID) || finding.getProperty("architecture") == null) continue;
            violatedArchitectures.add(finding.getProperty("architecture").toString().replace(".architecture", ""));
        }
        return violatedArchitectures;
    }

    public String buildSubject(PublicProjectId projectId, String ruleName, String revisionNumber) {
        StringBuilder subject = new StringBuilder();
        subject.append(ruleName + " for commit " + revisionNumber + " (" + String.valueOf(projectId) + ")");
        String separator = ":";
        Set<String> violatedArchitectures = this.getViolatedArchitectures();
        if (!violatedArchitectures.isEmpty()) {
            subject.append(separator + " violated architectures: " + String.join((CharSequence)", ", violatedArchitectures));
            separator = ";";
        }
        if (this.commitAlerts != null && this.commitAlerts.getAlertCount() > 0) {
            subject.append(separator + " alerts: " + this.commitAlerts.getAlertCount());
            separator = ";";
        }
        if (this.findingChurnList != null) {
            UnmodifiableList<TrackedFinding> removedFindings;
            UnmodifiableList<TrackedFinding> findingsInChangedCode;
            UnmodifiableList<TrackedFinding> addedFindings = this.findingChurnList.getAddedFindings();
            if (!addedFindings.isEmpty()) {
                subject.append(separator + " added findings: " + addedFindings.size());
                separator = ";";
            }
            if (!(findingsInChangedCode = this.findingChurnList.getFindingsInChangedCode()).isEmpty()) {
                subject.append(separator + " unfixed: " + findingsInChangedCode.size());
                separator = ";";
            }
            if (!(removedFindings = this.findingChurnList.getRemovedFindings()).isEmpty()) {
                subject.append(separator + " fixed: " + removedFindings.size());
            }
        }
        return subject.toString();
    }

    public String buildMailContent(String baseUrl) {
        StringWriter stringWriter = new StringWriter();
        HTMLWriter writer = new HTMLWriter(new PrintWriter(stringWriter));
        this.appendCommitInformation(writer);
        FindingsNotificationMailHelper.appendActivatedTriggers(writer, this.activatedTriggers);
        for (EFindingsNotificationTrigger trigger : this.activatedTriggers) {
            this.appendActivatedTriggerBlock(writer, trigger, baseUrl);
        }
        writer.close();
        return stringWriter.toString();
    }

    private static void appendActivatedTriggers(HTMLWriter writer, EnumSet<EFindingsNotificationTrigger> activatedTriggers) {
        if (!activatedTriggers.isEmpty()) {
            writer.addClosedTextElement((Enum)EHTMLElement.P, "The following conditions were met: ", new Object[0]);
            writer.openElement((Enum)EHTMLElement.UL);
            for (EFindingsNotificationTrigger trigger : activatedTriggers) {
                writer.openElement((Enum)EHTMLElement.LI);
                writer.addClosedTextElement((Enum)EHTMLElement.B, trigger.getLongDescription(), new Object[0]);
                writer.closeElement((Enum)EHTMLElement.LI);
            }
            writer.closeElement((Enum)EHTMLElement.UL);
        }
    }

    private void appendActivatedTriggerBlock(HTMLWriter writer, EFindingsNotificationTrigger trigger, String baseUrl) {
        if (this.findingChurnList != null && trigger == EFindingsNotificationTrigger.ADDED_FINDINGS) {
            this.appendFindingChurnsBlock(writer, trigger, (UnmodifiableCollection<TrackedFinding>)this.findingChurnList.getAddedFindings(), baseUrl);
        } else if (this.findingChurnList != null && trigger == EFindingsNotificationTrigger.FINDINGS_IN_CHANGED_CODE) {
            this.appendFindingChurnsBlock(writer, trigger, (UnmodifiableCollection<TrackedFinding>)this.findingChurnList.getFindingsInChangedCode(), baseUrl);
        } else if (this.commitAlerts != null && trigger == EFindingsNotificationTrigger.COMMIT_ALERTS) {
            this.appendCommitAlertsBlock(writer, trigger, this.commitAlerts.getCommitAlerts());
        }
    }

    @VisibleForTesting
    List<TrackedFinding> sortFindings(Collection<TrackedFinding> findings) {
        Function<TrackedFinding, EFindingBlacklistType> byBlacklistType = finding -> Optional.ofNullable(this.blacklistedFindings.get(finding.getId())).map(FindingBlacklistInfo::getType).orElse(null);
        Comparator noBlacklistFirst = Comparator.nullsFirst(Comparator.naturalOrder().reversed());
        Comparator<TrackedFinding> comparator = Comparator.comparing(byBlacklistType, noBlacklistFirst).thenComparing(DetachedFinding::getLocationString);
        return findings.stream().sorted(comparator).toList();
    }

    private void appendFindingChurnsBlock(HTMLWriter writer, EFindingsNotificationTrigger activatedTrigger, UnmodifiableCollection<TrackedFinding> findings, String baseUrl) {
        if (!findings.isEmpty()) {
            writer.addClosedTextElement((Enum)EHTMLElement.P, "All " + activatedTrigger.getShortDescription() + ": ", new Object[0]);
            writer.openElement((Enum)EHTMLElement.UL);
            TeamscaleCommitLinkProvider linkProvider = new TeamscaleCommitLinkProvider(baseUrl, this.notificationContext.getPrimaryPublicId(), this.notificationContext.getCommit().toUnresolvedCommitDescriptor());
            int count = 0;
            for (TrackedFinding trackedFinding : this.sortFindings((Collection<TrackedFinding>)findings)) {
                writer.openElement((Enum)EHTMLElement.LI);
                this.appendBlackListTag(writer, trackedFinding);
                FindingsNotificationMailHelper.appendTrackedFinding(writer, trackedFinding, linkProvider);
                writer.closeElement((Enum)EHTMLElement.LI);
                if (++count < 10) continue;
                writer.openElement((Enum)EHTMLElement.LI);
                FindingsNotificationMailHelper.appendLink(writer, this.revisionLink, "...");
                writer.closeElement((Enum)EHTMLElement.LI);
                break;
            }
            writer.closeElement((Enum)EHTMLElement.UL);
        }
    }

    private void appendCommitAlertsBlock(HTMLWriter writer, EFindingsNotificationTrigger activatedTrigger, UnmodifiableList<CommitAlert> alerts) {
        if (!alerts.isEmpty()) {
            writer.addClosedTextElement((Enum)EHTMLElement.P, "All " + activatedTrigger.getShortDescription() + ": ", new Object[0]);
            writer.openElement((Enum)EHTMLElement.UL);
            int count = 0;
            for (CommitAlert alert : alerts) {
                writer.openElement((Enum)EHTMLElement.LI);
                writer.addText(alert.getMessage());
                writer.closeElement((Enum)EHTMLElement.LI);
                if (++count < 10) continue;
                writer.openElement((Enum)EHTMLElement.LI);
                FindingsNotificationMailHelper.appendLink(writer, this.revisionLink, "...");
                writer.closeElement((Enum)EHTMLElement.LI);
                break;
            }
            writer.closeElement((Enum)EHTMLElement.UL);
        }
    }

    private void appendBlackListTag(HTMLWriter writer, TrackedFinding trackedFinding) {
        FindingBlacklistInfo blacklistedFindingInfo = this.blacklistedFindings.get(trackedFinding.getId());
        if (blacklistedFindingInfo != null) {
            writer.addClosedTextElement((Enum)EHTMLElement.B, "[" + blacklistedFindingInfo.getType().getReadableName() + "] ", new Object[0]);
        }
    }

    private static void appendTrackedFinding(HTMLWriter writer, TrackedFinding trackedFinding, TeamscaleCommitLinkProvider linkProvider) {
        String link = linkProvider.createFindingsDetailLink(trackedFinding.getId());
        FindingsNotificationMailHelper.appendLink(writer, link, trackedFinding.getMessage());
        writer.addText(": " + trackedFinding.getLocationString());
    }

    private EnumSet<EFindingsNotificationTrigger> determineActivatedNotificationTriggers() {
        EnumSet<EFindingsNotificationTrigger> activatedTriggers = EnumSet.noneOf(EFindingsNotificationTrigger.class);
        if (this.commitAlerts != null && this.commitAlerts.getAlertCount() > 0) {
            activatedTriggers.add(EFindingsNotificationTrigger.COMMIT_ALERTS);
        }
        if (this.findingChurnList != null) {
            if (this.findingChurnList.getAddedFindings() != null && !this.findingChurnList.getAddedFindings().isEmpty()) {
                activatedTriggers.add(EFindingsNotificationTrigger.ADDED_FINDINGS);
            }
            if (this.findingChurnList.getAddedFindings() != null && !this.findingChurnList.getFindingsInChangedCode().isEmpty()) {
                activatedTriggers.add(EFindingsNotificationTrigger.FINDINGS_IN_CHANGED_CODE);
            }
        }
        return activatedTriggers;
    }

    public EnumSet<EFindingsNotificationTrigger> getActivatedTriggers() {
        return this.activatedTriggers;
    }

    public @Nullable FindingChurnList getFindingChurnList() {
        return this.findingChurnList;
    }
}

