/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.notifications.metrics;

import com.teamscale.core.user.User;
import com.teamscale.index.notifications.InvalidNotificationRuleException;
import com.teamscale.index.notifications.NotificationContext;
import com.teamscale.index.notifications.NotificationThresholdViolationInfo;
import com.teamscale.index.notifications.UserNotifierBase;
import com.teamscale.index.notifications.metrics.MetricNotificationMailHelper;
import com.teamscale.index.notifications.metrics.MetricNotificationRule;
import com.teamscale.index.notifications.metrics.MetricNotificationRuleIndex;
import com.teamscale.index.notifications.metrics.MetricNotificationRuleToViolationInfo;
import com.teamscale.index.notifications.metrics.MetricNotificationRules;
import com.teamscale.index.user.UserAliasLookup;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;

public class MetricNotifier
extends UserNotifierBase<MetricNotificationRules> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected MetricNotificationRuleIndex metricNotificationRuleIndex;
    protected MetricNotificationMailHelper metricNotificationMailHelper;

    public MetricNotifier(NotificationContext notificationContext, UserAliasLookup userAliasLookup) {
        super(notificationContext, userAliasLookup);
    }

    @Override
    protected void initialize() throws StorageException {
        this.metricNotificationMailHelper = new MetricNotificationMailHelper(this.notificationContext);
        this.metricNotificationRuleIndex = (MetricNotificationRuleIndex)this.notificationContext.getGlobalStorageSystem().openGlobalIndex(MetricNotificationRuleIndex.class);
    }

    @Override
    protected void processRules(User user, MetricNotificationRules notificationRules) throws StorageException {
        ArrayList<MetricNotificationRuleToViolationInfo> matchedRulesToInfo = new ArrayList<MetricNotificationRuleToViolationInfo>();
        for (MetricNotificationRule metricNotificationRule : notificationRules.getRules()) {
            if (!this.matchesProject(metricNotificationRule)) continue;
            this.addInfoOfValidRule(matchedRulesToInfo, metricNotificationRule);
        }
        if (!matchedRulesToInfo.isEmpty()) {
            String subject = this.metricNotificationMailHelper.buildSubject();
            this.sendEmail(user, subject, this.metricNotificationMailHelper.buildContent(matchedRulesToInfo));
            LOGGER.debug("Notifying user {} with subject {} about metrics", (Object)user, (Object)subject);
        } else {
            LOGGER.info("No matching rules in MetricNotifier");
        }
    }

    private void addInfoOfValidRule(List<MetricNotificationRuleToViolationInfo> matchedRulesToInfo, MetricNotificationRule metricNotificationRule) throws StorageException {
        try {
            NotificationThresholdViolationInfo info = metricNotificationRule.matches(this.notificationContext);
            if (info.isViolated()) {
                matchedRulesToInfo.add(new MetricNotificationRuleToViolationInfo(metricNotificationRule, info));
            }
        }
        catch (InvalidNotificationRuleException e) {
            LOGGER.error("Encountered invalid notification rule: " + metricNotificationRule.getRuleName(), (Throwable)e);
        }
    }

    private boolean matchesProject(MetricNotificationRule metricNotificationRule) {
        return CollectionUtils.map(this.notificationContext.getPublicIds(), ProjectIdBase::toString).contains(metricNotificationRule.getProjectName());
    }

    @Override
    protected PairList<String, MetricNotificationRules> getAllNotificationEntries() throws StorageException {
        return this.metricNotificationRuleIndex.getAllNotificationRules();
    }
}

