/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report;

import com.teamscale.index.quality_report.SlideRenderDataBase;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="slide-render-data", options={EStorageOption.BACKUP, EStorageOption.ENCRYPTED, EStorageOption.COMPRESSED})
public class SlideRenderDataIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "slide-render-data";
    private final ValueIndex<SlideRenderDataBase> delegate;

    public SlideRenderDataIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public @Nullable SlideRenderDataBase getSlideRenderData(String reportId, String slideId) throws StorageException {
        return (SlideRenderDataBase)this.delegate.getValue(SlideRenderDataIndex.makeKey(reportId, slideId));
    }

    public void setSlideRenderData(String reportId, PairList<String, @Nullable SlideRenderDataBase> slides) throws StorageException {
        this.delegate.setValues(slides.mapFirst(slideId -> SlideRenderDataIndex.makeKey(reportId, slideId)));
    }

    public void removeSlideRenderData(String reportId, List<String> slideIds) throws StorageException {
        this.delegate.removeValues((Collection)CollectionUtils.map(slideIds, slideId -> SlideRenderDataIndex.makeKey(reportId, slideId)));
    }

    public void removeRenderDataForAllSlides(String reportId) throws StorageException {
        this.delegate.removeEntriesStartingWith(List.of(SlideRenderDataIndex.makeKey(reportId, "")));
    }

    private static @NonNull String makeKey(String reportId, String slideId) {
        return reportId + "#!#" + slideId;
    }
}

