/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report;

import com.teamscale.index.report.EReportContentType;
import com.teamscale.reportparser.parser.ECoverageFormat;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.js_export.NotExported;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass
public enum EReportFormat {
    ASTREE("Astree", EReportContentType.FINDINGS),
    JACOCO("JaCoCo", ECoverageFormat.JACOCO),
    COBERTURA("Cobertura", ECoverageFormat.COBERTURA),
    GCOV("Gcov", ECoverageFormat.GCOV),
    LCOV("Lcov", ECoverageFormat.LCOV),
    CTC("Testwell CTC++", ECoverageFormat.CTC),
    XR_BABOON("XR.Baboon", EReportContentType.COVERAGE),
    MS_COVERAGE("MS Coverage", EReportContentType.COVERAGE),
    VS_COVERAGE("VS Coverage", ECoverageFormat.VS_COVERAGE),
    DOT_COVER("dotCover", ECoverageFormat.DOT_COVER),
    ROSLYN("Roslyn", EReportContentType.FINDINGS),
    GOLANG_COVERAGE("Go Cover", ECoverageFormat.GOLANG_COVERAGE),
    SIMPLE("Teamscale Simple Coverage", ECoverageFormat.SIMPLE),
    CPPCHECK("Cppcheck", EReportContentType.FINDINGS),
    PCLINT("PClint/FlexeLint", EReportContentType.FINDINGS),
    CLANG("Clang", EReportContentType.FINDINGS),
    PYLINT("Pylint", EReportContentType.FINDINGS),
    FINDBUGS("FindBugs/SpotBugs", EReportContentType.FINDINGS),
    BULLSEYE("Bullseye", EReportContentType.COVERAGE),
    RAW_TESTWISE("Raw Testwise Coverage", EReportContentType.COVERAGE),
    FXCOP("FxCop", EReportContentType.FINDINGS),
    JUNIT("JUnit", EReportContentType.TEST_EXECUTIONS),
    BOOST_TEST("Boost.Test", EReportContentType.TEST_EXECUTIONS),
    XUNIT("XUnit", EReportContentType.TEST_EXECUTIONS),
    MS_TEST("MSTest", EReportContentType.TEST_EXECUTIONS),
    CS_COMPILER_WARNING("C# Compiler Warning", EReportContentType.FINDINGS),
    MODEL_ADVISOR("Simulink Model Advisor", EReportContentType.FINDINGS),
    ISSUE_CSV("CSV Issues", EnumSet.of(EReportContentType.OTHER), false),
    REQUIREMENTS_CSV("CSV Spec Items", EnumSet.of(EReportContentType.OTHER), false),
    SAP_CODE_INSPECTOR("SAP Code Inspector Export", EReportContentType.FINDINGS),
    SAP_COVERAGE("SAP Coverage", EnumSet.of(EReportContentType.COVERAGE), false),
    TESTWISE_COVERAGE("Testwise Coverage", EnumSet.of(EReportContentType.COVERAGE, EReportContentType.TEST_EXECUTIONS), true),
    XCODE("Xcode Coverage", ECoverageFormat.XCODE),
    CLOVER("Clover", ECoverageFormat.CLOVER),
    OPEN_COVER("OpenCover", EReportContentType.COVERAGE),
    IEC_COVERAGE("IEC Coverage", ECoverageFormat.IEC_COVERAGE),
    LLVM("LLVM Coverage", ECoverageFormat.LLVM),
    GENERIC_FINDINGS("Teamscale Generic Findings", EReportContentType.FINDINGS),
    GENERIC_NON_CODE("Teamscale Custom Artifacts Metrics", EReportContentType.OTHER),
    PARASOFT_CPP_TEST("Parasoft C/C++test", EReportContentType.FINDINGS),
    COMPILATION_DATABASE("JSON Compilation Database", EReportContentType.OTHER),
    MYPY("Mypy", EReportContentType.FINDINGS),
    FORTIFY("Fortify", EReportContentType.FINDINGS),
    LAUTERBACH_TRACE32("Lauterbach Trace32", ECoverageFormat.LAUTERBACH_TRACE32),
    JQASSISTANT("jQAssistant", EReportContentType.FINDINGS),
    NUNIT("NUnit", EReportContentType.TEST_EXECUTIONS),
    SIMULINK_MAT("Simulink MAT", EnumSet.of(EReportContentType.OTHER), false),
    SONARQUBE("SonarQube", EReportContentType.FINDINGS),
    TEAMSCALE_COMPACT_COVERAGE("Teamscale Compact Coverage", ECoverageFormat.TEAMSCALE_COMPACT_COVERAGE),
    XCRESULT_JSON("XCResult JSON", EReportContentType.TEST_EXECUTIONS),
    JLINK_CSV("J-Link CSV", ECoverageFormat.JLINK_CSV),
    PREPARSED("Preparsed import infos", EReportContentType.OTHER);

    private final String readableName;
    private final boolean allowedForUpload;
    private final Set<EReportContentType> contentTypes;
    @NotExported
    private final @Nullable ECoverageFormat associatedCoverageFormat;

    private EReportFormat(String readableName, EReportContentType contentType) {
        this(readableName, EnumSet.of(contentType), true);
    }

    private EReportFormat(String readableName, EnumSet<EReportContentType> contentTypes, boolean allowedForUpload) {
        this.readableName = readableName;
        this.allowedForUpload = allowedForUpload;
        this.contentTypes = EnumSet.copyOf(contentTypes);
        this.associatedCoverageFormat = null;
    }

    private EReportFormat(String readableName, ECoverageFormat associatedCoverageFormat) {
        this.readableName = readableName;
        this.associatedCoverageFormat = associatedCoverageFormat;
        this.allowedForUpload = true;
        this.contentTypes = EnumSet.of(EReportContentType.COVERAGE);
    }

    public String getReadableName() {
        return this.readableName;
    }

    public boolean isAllowedForUpload() {
        return this.allowedForUpload;
    }

    public boolean containsCoverage() {
        return this.contentTypes.contains((Object)EReportContentType.COVERAGE);
    }

    public boolean containsTestExecutions() {
        return this.contentTypes.contains((Object)EReportContentType.TEST_EXECUTIONS);
    }

    public @Nullable ECoverageFormat getAssociatedCoverageFormat() {
        return this.associatedCoverageFormat;
    }
}

