/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.commons.service.XmlSerializationUtils;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.configuration.tools.JQAssistantConfiguration;
import com.teamscale.index.report.base.FindingCollectingReportParserBase;
import com.teamscale.index.report.parser.JQAssistantReport;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class JQAssistantReportParser
extends FindingCollectingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String JQASSISTANT_GROUP_NAME = "Architecture Guidelines";
    private static final String WARNING_GROUP_NAME = "jqassistant.warning";
    private static final String FAILURE_GROUP_NAME = "jqassistant.failure";
    private static final String CONSTRAINT_ID_FINDING_PROPERTY = "jQAssistant Constraint ID";
    private String fileForGlobalFindings = null;
    private JQAssistantConfiguration.JQAssistantOptions jqAssistantOptions = null;

    @Override
    protected void collectFindings() throws StorageException {
    }

    @Override
    protected void parseStringReportInternal(String report, String reportPath) throws ReportParserException {
        try {
            this.prepareReportParsing();
            this.processReport((JQAssistantReport)XmlSerializationUtils.deserializeFromXML((String)report, JQAssistantReport.class));
        }
        catch (IOException | StorageException e) {
            throw new ReportParserException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareReportParsing() throws StorageException {
        this.jqAssistantOptions = (JQAssistantConfiguration.JQAssistantOptions)this.projectMetaIndex.getValue(JQAssistantConfiguration.JQAssistantOptions.class);
        if (this.repositoryParameterShouldBeIgnored()) {
            this.repository = null;
        }
        LOGGER.debug("JQAssistant repository parameter: {}", (Object)this.repository);
        List<String> globalFindingsFiles = this.jqAssistantOptions.globalFindingsFiles();
        if (globalFindingsFiles == null || globalFindingsFiles.isEmpty()) {
            LOGGER.warn("No file for attaching global jQAssistant findings specified in analysis profile. Global findings will be ignored.");
            return;
        }
        for (String string : globalFindingsFiles) {
            void var3_3;
            Optional<String> lookupPath;
            if (this.repository != null) {
                String string2 = this.repository + "/" + string;
            }
            if (!(lookupPath = this.matchingPathsLookup.lookupBestPath((String)var3_3, PathLookupOptions.defaults())).isPresent() || !lookupPath.get().equals(var3_3)) continue;
            this.fileForGlobalFindings = var3_3;
            break;
        }
        if (this.fileForGlobalFindings == null) {
            LOGGER.warn("No matching file found for assigning global findings. Global findings will be ignored.");
        }
        LOGGER.debug("JQAssistant report file: {}", (Object)this.fileForGlobalFindings);
    }

    private boolean repositoryParameterShouldBeIgnored() throws StorageException {
        String optionName = "Prepend repository identifier";
        List repositoryConnectors = ConnectorUtils.getRepositoryConnectors((MetaIndex)this.projectMetaIndex);
        return repositoryConnectors.size() == 1 && !Boolean.parseBoolean(((ConnectorConfiguration)repositoryConnectors.getFirst()).getOptionValue(optionName));
    }

    private void processReport(JQAssistantReport report) throws StorageException {
        BiPredicate<JQAssistantReport.Element, CodeScopeName> elementRelevanceChecker;
        JQAssistantReport.JQAssistantElements constraintsAndElements = report.getElements();
        Set<JQAssistantReport.Element> constraints = constraintsAndElements.constraints();
        Set<JQAssistantReport.Element> concepts = constraintsAndElements.concepts();
        Map<String, TokenElementInfo> tokenElementsByPath = this.getAllTokenElementsForReport(CollectionUtils.unionSet(constraints, (Collection[])new Collection[]{concepts}));
        for (JQAssistantReport.Element constraint : constraints) {
            elementRelevanceChecker = (element, codeScopeName) -> JQAssistantReportParser.isRelevantForFindingCreation(constraint, (Boolean)this.jqAssistantOptions.warningsEnabledForConstraints().getValue(codeScopeName), (Boolean)this.jqAssistantOptions.failuresEnabledForConstraints().getValue(codeScopeName));
            this.addFindings(constraint, tokenElementsByPath, elementRelevanceChecker);
        }
        for (JQAssistantReport.Element concept : concepts) {
            elementRelevanceChecker = (element, codeScopeName) -> JQAssistantReportParser.isRelevantForFindingCreation(concept, (Boolean)this.jqAssistantOptions.warningsEnabledForConcepts().getValue(codeScopeName), (Boolean)this.jqAssistantOptions.failuresEnabledForConcepts().getValue(codeScopeName));
            this.addFindings(concept, tokenElementsByPath, elementRelevanceChecker);
        }
    }

    private void addFindings(JQAssistantReport.Element constraint, Map<String, TokenElementInfo> tokenElementsByPath, BiPredicate<JQAssistantReport.Element, CodeScopeName> elementRelevanceChecker) throws StorageException {
        Optional<String> findingGroup = JQAssistantReportParser.getFindingGroup(constraint);
        if (findingGroup.isPresent()) {
            this.addFindings(constraint, findingGroup.get(), tokenElementsByPath, elementRelevanceChecker);
        }
    }

    private static Optional<String> getFindingGroup(JQAssistantReport.Element element) {
        if (element.isFailure()) {
            return Optional.of(FAILURE_GROUP_NAME);
        }
        if (element.isWarning()) {
            return Optional.of(WARNING_GROUP_NAME);
        }
        return Optional.empty();
    }

    private Map<String, TokenElementInfo> getAllTokenElementsForReport(Collection<JQAssistantReport.Element> elements) throws StorageException {
        HashMap<String, TokenElementInfo> tokenElementsByPath = new HashMap<String, TokenElementInfo>();
        ArrayList<String> uniformPaths = new ArrayList<String>();
        for (JQAssistantReport.Element element : elements) {
            for (JQAssistantReport.Row row : element.getResult().getRows()) {
                JQAssistantReport.Source source = row.getSource(element.getResult().getPrimaryColumnIndex());
                if (source == null) continue;
                this.resolvePath(source.getFileName()).ifPresent(uniformPaths::add);
            }
        }
        this.tokenElementIndexCache.getValues(uniformPaths).forEach(tokenElement -> tokenElementsByPath.put(tokenElement.getUniformPath(), (TokenElementInfo)((Object)tokenElement)));
        return tokenElementsByPath;
    }

    private void addFindings(JQAssistantReport.Element element, String findingGroup, Map<String, TokenElementInfo> tokenElementsByPath, BiPredicate<JQAssistantReport.Element, CodeScopeName> elementRelevanceChecker) throws StorageException {
        for (JQAssistantReport.Row row : element.getResult().getRows()) {
            String findingDebugIdentifier;
            int primaryColumnIndex;
            JQAssistantReport.Source source = row.getSource(primaryColumnIndex = element.getResult().getPrimaryColumnIndex());
            ElementLocation location = this.getElementLocationFromSource(source, findingDebugIdentifier = row.getKey() != null ? row.getKey() : element.getDescription());
            if (location == null) continue;
            AtomicReference<CodeScopeName> codeScope = new AtomicReference<CodeScopeName>(CodeScopeAware.DEFAULT_CODE_SCOPE);
            Optional.ofNullable(tokenElementsByPath.get(location.getUniformPath())).ifPresent(tokenElementInfo -> codeScope.set(CodeScopeDetail.getCodeScopeNameFromTokenElement(tokenElementInfo)));
            if (!elementRelevanceChecker.test(element, codeScope.get())) continue;
            DetachedFinding finding = new DetachedFinding(findingGroup, JQASSISTANT_GROUP_NAME, element.getDescription(), location);
            JQAssistantReportParser.createFindingProperties(finding, element, row);
            this.addFindingForPath(location.getUniformPath(), finding);
        }
    }

    private static void createFindingProperties(DetachedFinding finding, JQAssistantReport.Element element, JQAssistantReport.Row row) {
        Map<String, String> properties = row.getProperties();
        properties.put(CONSTRAINT_ID_FINDING_PROPERTY, element.getId());
        properties.forEach((name, value) -> finding.setProperty(name + " [important]", value));
        if (row.getKey() != null) {
            finding.setProperty("external-id", (Object)row.getKey());
        }
    }

    private static boolean isRelevantForFindingCreation(JQAssistantReport.Element element, boolean warningsEnabled, boolean failuresEnabled) {
        if (element.isWarning() && warningsEnabled || element.isFailure() && failuresEnabled) {
            return element.getResult() != null;
        }
        return false;
    }

    private @Nullable ElementLocation getElementLocationFromSource(@Nullable JQAssistantReport.Source source, String findingDebugIdentifier) throws StorageException {
        Optional<String> fileName = Optional.ofNullable(source).map(JQAssistantReport.Source::getFileName);
        if (fileName.isEmpty()) {
            LOGGER.debug("Create finding for global finding file because finding has no file name: {}", (Object)findingDebugIdentifier);
            return this.createLocationForGlobalFinding();
        }
        Optional<String> uniformPath = this.resolvePath(fileName.get());
        if (uniformPath.isEmpty()) {
            LOGGER.debug("Create finding for global finding file because uniform path could not be found: {}", (Object)fileName.get());
            return this.createLocationForGlobalFinding();
        }
        if (this.isPathOfDifferentRepo(uniformPath.get())) {
            LOGGER.debug("Create finding for global finding file because matched file is from a different repository: {}", (Object)uniformPath.get());
            return this.createLocationForGlobalFinding();
        }
        if (source.getStartLine() == null || source.getEndLine() == null) {
            return new ElementLocation(uniformPath.get());
        }
        return JQAssistantReportParser.createLineLocation(uniformPath.get(), Integer.parseInt(source.getStartLine()), Integer.parseInt(source.getEndLine()));
    }

    private boolean isPathOfDifferentRepo(String uniformPath) {
        return this.repository != null && !uniformPath.startsWith(this.repository + "/");
    }

    private @Nullable ElementLocation createLocationForGlobalFinding() {
        if (this.fileForGlobalFindings != null) {
            return new ElementLocation(this.fileForGlobalFindings);
        }
        return null;
    }
}

