/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.roslyn;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.index.configuration.tools.message.IMessageManager;
import com.teamscale.index.report.base.OffsetConvertingFindingReportParserBase;
import com.teamscale.index.report.roslyn.RoslynMessageManagerProvider;
import com.teamscale.index.upload.roslyn.data.RoslynAnalysisToolRun;
import com.teamscale.index.upload.roslyn.data.RoslynLocation;
import com.teamscale.index.upload.roslyn.data.RoslynPhysicalLocation;
import com.teamscale.index.upload.roslyn.data.RoslynReport;
import com.teamscale.index.upload.roslyn.data.RoslynResult;
import com.teamscale.index.upload.roslyn.data.RoslynTextRegion;
import com.teamscale.reportparser.parser.ReportParserException;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.jspecify.annotations.Nullable;

public class RoslynReportParser
extends OffsetConvertingFindingReportParserBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private RoslynReport roslynReport;
    private RoslynMessageManagerProvider messageManagerProvider;

    @Override
    public void parseStringReportInternal(String report, @Nullable String reportPath) throws ReportParserException {
        try {
            this.messageManagerProvider = new RoslynMessageManagerProvider();
            this.roslynReport = (RoslynReport)JsonUtils.deserializeFromJsonWithNullCheck((String)report, RoslynReport.class);
        }
        catch (ProjectConfigurationException exception) {
            throw new ReportParserException("Problem occurred when configuring message manager provider: " + exception.getMessage(), (Throwable)exception);
        }
        catch (ConQATException exception) {
            throw new ReportParserException("Error when parsing report JSON: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    protected void collectFindings() throws StorageException {
        CCSMAssert.isNotNull((Object)this.roslynReport);
        List<RoslynAnalysisToolRun> runs = this.roslynReport.getRuns();
        if (runs == null) {
            LOGGER.warn("Report has no runs to import.");
        } else {
            for (RoslynAnalysisToolRun run : this.roslynReport.getRuns()) {
                this.addFindings(run);
            }
        }
    }

    private void addFindings(RoslynAnalysisToolRun run) throws StorageException {
        for (RoslynResult result : run.getResults()) {
            IMessageManager messageManager;
            String ruleId = result.getRuleId();
            try {
                messageManager = this.messageManagerProvider.getMessageManger(ruleId, this.externalFindingsGroupDescriptionIndex);
            }
            catch (ConQATException e) {
                LOGGER.error((Object)e);
                continue;
            }
            if (messageManager == null) {
                LOGGER.warn("Rule id '" + ruleId + "' from Roslyn analysis tool '" + run.getTool().getName() + "' unknown.");
                continue;
            }
            List<RoslynLocation> locations = result.getLocations();
            if (locations == null) {
                LOGGER.warn("Encountered rule with id '" + ruleId + "' without a corresponding code location.");
                continue;
            }
            for (RoslynLocation location : result.getLocations()) {
                this.addFinding(messageManager, result, location);
            }
        }
    }

    private void addFinding(IMessageManager messageManager, RoslynResult result, RoslynLocation reportLocation) throws StorageException {
        String pathFromReport = reportLocation.getResultLocation().getFullUri();
        Optional<String> pathInTeamscale = this.resolvePath(pathFromReport);
        if (pathInTeamscale.isEmpty()) {
            return;
        }
        Optional<TextRegionLocation> location = this.createTextRegionLocation(pathInTeamscale.get(), reportLocation.getResultLocation());
        if (location.isEmpty()) {
            LOGGER.error("Ignored finding '{}' at '{}'", (Object)result, (Object)reportLocation.getResultLocation());
            return;
        }
        String ruleId = result.getRuleId();
        DetachedFinding finding = RoslynReportParser.createFindingWithLocation(ruleId, messageManager.getFindingsGroupNameFor(ruleId), messageManager.getFindingCategoryName(), result.getMessage(), (ElementLocation)location.get(), RoslynReportParser.getAssessment(result));
        finding.setProperty("Rule name", (Object)messageManager.getReadableNameFor(ruleId));
        this.addFindingForPath(pathInTeamscale.get(), finding);
    }

    private static ETrafficLightColor getAssessment(RoslynResult result) {
        return switch (result.getLevel()) {
            case "error" -> ETrafficLightColor.RED;
            case "warning", "info" -> ETrafficLightColor.YELLOW;
            default -> {
                LOGGER.warn("Unknown Roslyn severity level '{}'", (Object)result.getLevel());
                yield ETrafficLightColor.YELLOW;
            }
        };
    }

    private Optional<TextRegionLocation> createTextRegionLocation(String pathInTeamscale, RoslynPhysicalLocation location) throws StorageException {
        RoslynTextRegion textRegion = location.getRegion();
        return this.createTextRegionLocation(pathInTeamscale, textRegion.getStartLine(), textRegion.getStartColumn(), textRegion.getEndLine(), textRegion.getEndColumn());
    }
}

