/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.committree.BranchRenamingCommitTreeFacade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public abstract class MergedRevisionsFilter {
    private final BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade;
    private String initialBranch = null;
    private final Set<MergeInfo> merges = new HashSet<MergeInfo>();
    private final Map<Long, String> transitiveForksToInitial = new HashMap<Long, String>();

    protected MergedRevisionsFilter(@Nullable BranchRenamingCommitTreeFacade branchRenamingCommitTreeFacade) {
        this.branchRenamingCommitTreeFacade = branchRenamingCommitTreeFacade;
    }

    public boolean isContainedInMergeOrOnInitialBranch(ParentedCommitDescriptor commit) throws RepositoryException {
        ICommitTreeNode commitTreeNode = this.getCommitTreeNodeForCommitDescriptor((CommitDescriptor)commit);
        if (commitTreeNode == null) {
            return true;
        }
        boolean isPartOfMerge = this.isPartOfMerge(commitTreeNode, this.merges);
        boolean isOnInitialBranch = false;
        String branchName = commit.getBranchName();
        if (!isPartOfMerge) {
            if (this.initialBranch == null) {
                this.initialBranch = branchName;
                long forkTimestamp = commit.getTimestamp();
                this.transitiveForksToInitial.put(forkTimestamp, this.initialBranch);
                isOnInitialBranch = true;
            } else {
                isOnInitialBranch = this.onTransitiveForkOfInitial(commit);
            }
        }
        if (!isOnInitialBranch && !isPartOfMerge) {
            return false;
        }
        UnmodifiableList parentCommits = commit.getParentCommits();
        if (parentCommits.size() >= 2) {
            this.merges.add(MergeInfo.getMergeInfo(commitTreeNode, this));
        } else if (isOnInitialBranch && parentCommits.size() == 1 && !((CommitDescriptor)parentCommits.getFirst()).isOnBranch(branchName)) {
            String forkSourceBranch = ((CommitDescriptor)parentCommits.getFirst()).getBranchName();
            this.transitiveForksToInitial.put(((CommitDescriptor)parentCommits.getFirst()).getTimestamp(), forkSourceBranch);
        }
        return true;
    }

    private boolean onTransitiveForkOfInitial(ParentedCommitDescriptor commitDescriptor) {
        Map<Long, String> transitiveForkList = this.transitiveForksToInitial;
        if (transitiveForkList.isEmpty()) {
            return false;
        }
        ArrayList forkTimestamps = new ArrayList(transitiveForkList.keySet().stream().sorted().toList());
        Collections.reverse(forkTimestamps);
        long timestampOfCurrentFork = -1L;
        Iterator iterator = forkTimestamps.iterator();
        while (iterator.hasNext()) {
            long timestampOfFork = (Long)iterator.next();
            if (timestampOfFork >= commitDescriptor.getTimestamp()) {
                timestampOfCurrentFork = timestampOfFork;
                continue;
            }
            if (timestampOfCurrentFork != -1L) break;
            return false;
        }
        String sourceOfForkBranch = transitiveForkList.get(timestampOfCurrentFork);
        return commitDescriptor.isOnBranch(sourceOfForkBranch);
    }

    private boolean isPartOfMerge(ICommitTreeNode commitTreeNode, Set<MergeInfo> potentialMerges) {
        if (potentialMerges.isEmpty()) {
            return false;
        }
        String revision = this.getRevisionFromCommitTreeRevision(commitTreeNode.getRevision());
        Optional<MergeInfo> merge = potentialMerges.stream().filter(mergeInfo -> mergeInfo.mergedRevisions.contains(revision)).findFirst();
        if (merge.isPresent()) {
            MergedRevisionsFilter.sawRevisionOfMerge(revision, merge.get(), potentialMerges);
            return true;
        }
        return false;
    }

    private static void sawRevisionOfMerge(String revision, MergeInfo merge, Set<MergeInfo> potentialMerges) {
        merge.mergedRevisions.remove(revision);
        if (merge.mergedRevisions.isEmpty()) {
            potentialMerges.remove(merge);
        }
    }

    private ICommitTreeNode getCommitTreeNodeForCommitDescriptor(CommitDescriptor commitDescriptor) {
        return this.branchRenamingCommitTreeFacade.getNodeByBranchAndAdjustedTimestamp(this.branchRenamingCommitTreeFacade.unrenameBranch(commitDescriptor.getBranchName()), commitDescriptor.getTimestamp());
    }

    protected abstract Set<String> getMergedRevisionsForMergeCommit(ICommitTreeNode var1) throws RepositoryException;

    protected abstract String getRevisionFromCommitTreeRevision(CommitTreeRevision var1);

    private record MergeInfo(Set<String> mergedRevisions) {
        private static MergeInfo getMergeInfo(ICommitTreeNode commitTreeNode, MergedRevisionsFilter mergedRevisionsFilter) throws RepositoryException {
            return new MergeInfo(mergedRevisionsFilter.getMergedRevisionsForMergeCommit(commitTreeNode));
        }
    }
}

