/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.FileSystemAccessOption;
import com.teamscale.index.repository.filesystem.FileSystemRepositoryConnection;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.NonNull;

public class FileSystemFilesRetriever
implements IFilesRetriever {
    private final @NonNull ServerOptionIndex serverOptionIndex;
    private final @NonNull ConnectorConfiguration connectorConfiguration;

    public FileSystemFilesRetriever(@NonNull ServerOptionIndex serverOptionIndex, @NonNull ConnectorConfiguration connectorConfiguration) {
        this.serverOptionIndex = serverOptionIndex;
        this.connectorConfiguration = connectorConfiguration;
    }

    @Override
    public @NonNull Collection<@NonNull String> fetchFiles() throws RepositoryException {
        Optional<String> inputDirectory = this.getInputDirectory(this.connectorConfiguration);
        if (inputDirectory.isEmpty()) {
            return new ArrayList<String>();
        }
        File baseDirectory = new File(inputDirectory.get());
        List systemFiles = FileSystemUtils.listFilesRecursively((File)baseDirectory, File::isFile);
        return FileSystemFilesRetriever.getAccessibleFilePaths(systemFiles, this.readFileSystemAccessOption(), baseDirectory);
    }

    private FileSystemAccessOption readFileSystemAccessOption() throws RepositoryException {
        try {
            return FileSystemAccessOption.getOption((ServerOptionIndex)this.serverOptionIndex);
        }
        catch (StorageException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    protected Optional<String> getInputDirectory(ConnectorConfiguration connectorConfiguration) throws RepositoryException {
        return Optional.ofNullable(connectorConfiguration.getOptionValue("Input directory"));
    }

    private static List<String> getAccessibleFilePaths(List<File> systemFiles, FileSystemAccessOption filesystemAccessOption, File baseDirectory) {
        ArrayList<String> filePaths = new ArrayList<String>();
        for (File file : systemFiles) {
            String filename = FileSystemRepositoryConnection.getRelativePath(file, baseDirectory);
            Path filePath = baseDirectory.toPath().resolve(filename);
            try {
                filesystemAccessOption.validateRepositoryAccess(filePath);
            }
            catch (IOException | RepositoryException e) {
                continue;
            }
            filePaths.add(filename);
        }
        return filePaths;
    }
}

