/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.core.analysis.BranchingLayerAccess;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.repository.base.RepositoryConnectorBase;
import com.teamscale.index.repository.filesystem.FileSystemCacheIndex;
import com.teamscale.index.repository.filesystem.FileSystemRepositoryConnection;
import java.io.File;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.lib.commons.date.DateTimeUtils;

public class FileSystemRepositoryConnector
extends RepositoryConnectorBase<FileSystemRepositoryConnection> {
    public static final String INPUT_DIRECTORY_PARAMETER = "input-directory";
    @StepParameter(value="input-directory")
    private File baseDirectory;
    @BranchingLayerAccess(value=FileSystemCacheIndex.class, indexName="fs-cache")
    protected IBranchingLayer fileSystemCacheBranchingLayer;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptionIndex;
    private boolean hiddenElementConnector;

    public void init(boolean hiddenElementConnector) {
        this.hiddenElementConnector = hiddenElementConnector;
    }

    @Override
    protected FileSystemRepositoryConnection createConnection(IProfilingMonitor profilingMonitor, ICancelable cancelable, IParallelTaskExecutor parallelTaskExecutor) throws RepositoryException {
        long timestamp = DateTimeUtils.millisNow();
        return new FileSystemRepositoryConnection(this.getBaseParameters(), this.baseDirectory, timestamp, this.fileSystemCacheBranchingLayer, this.hiddenElementConnector, this.serverOptionIndex);
    }
}

