/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.filesystem;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptor;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.index.repository.filesystem.FileSystemCacheIndex;
import com.teamscale.index.repository.filesystem.FileSystemChangeRetriever;
import com.teamscale.index.repository.filesystem.FileSystemContentUpdater;
import com.teamscale.index.repository.filesystem.FileSystemRepositoryConnectorDescriptorBase;
import org.conqat.engine.core.configuration.EFeatureToggle;

@ConnectorDescriptor(disabledByFeatureToggle=EFeatureToggle.DISABLE_FILE_SYSTEM_CONNECTOR)
public class FileSystemRepositoryConnectorDescriptor
extends FileSystemRepositoryConnectorDescriptorBase {
    public FileSystemRepositoryConnectorDescriptor() {
        super(ERepositoryConnector.FILE_SYSTEM);
        this.autoExpose();
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return FileSystemChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return FileSystemContentUpdater.class;
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.setCommonParameters(triggerBuilder, triggerCreator);
        triggerBuilder.renameIndex("fs-cache", this.repositoryIdentifier + "-fs-cache");
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        indexCreator.createProjectIndex(FileSystemCacheIndex.class, this.repositoryIdentifier + "-fs-cache");
    }
}

