/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.azure_devops;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.git.azure_devops.AzureDevOpsGitClient;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

final class AzureDevOpsGitUtils {
    public static URI getGitRepoUri(ExternalCredentials credentials, ConnectorConfiguration connectorConfiguration, Logger interactionLogger) throws ProjectConfigurationException, RepositoryException {
        try {
            String repositoryName = connectorConfiguration.getOptionValue("Repository name");
            AzureDevOpsGitClient client = new AzureDevOpsGitClient(credentials, repositoryName, ProjectConfigurationException::new, interactionLogger);
            String repoUrl = client.getRepository(client.getRepositoryName()).getRemoteUrl();
            return UrlUtils.parseUri((String)repoUrl);
        }
        catch (ServiceCallException e) {
            throw new RepositoryException("Cannot determine repository url: " + e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ProjectConfigurationException("Invalid repository url: " + e.getMessage(), (Throwable)e);
        }
    }

    private AzureDevOpsGitUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

