/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.teamscale.commons.links.TeamscaleProjectLinkProvider;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestAnnotationInput;
import com.teamscale.index.merge_request.MergeRequestAnnotationTriggerBase;
import com.teamscale.index.merge_request.MergeRequestAnnotationUtils;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.merge_request.MergeRequestUpdateTriggerBase;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.merge_request.voting.VotingException;
import com.teamscale.index.merge_request.voting.VotingRecord;
import com.teamscale.index.repository.git.bitbucket.BitbucketUtils;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestProvider;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerMergeRequestUpdateTrigger;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerRepositoryIdentifier;
import com.teamscale.index.repository.git.bitbucket.server.BitbucketServerUtils;
import com.teamscale.index.repository.git.bitbucket.server.client.BitbucketServerClient;
import com.teamscale.index.repository.git.bitbucket.server.model.commit_status.CommitStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightAnnotation;
import com.teamscale.index.repository.git.bitbucket.server.model.insights.BitbucketServerCodeInsightReport;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerPullRequest;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.BitbucketServerReviewer;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitBucketServerPullRequestChanges;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.BitbucketServerDiffPath;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerPullRequestDiffs;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerCodeStatus;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerInlinePullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.BitbucketServerPullRequestComment;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.comments.EBitbucketServerCodeStatus;
import com.teamscale.index.repository.git.common.CcpCommentUtils;
import com.teamscale.index.repository.git.common.CcpIntegrationFeatureEnablements;
import com.teamscale.index.repository.git.common.CommitVotingTriggerBase;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.index.repository.git.common.voting_info.FindingsVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.IVotingInfoWithRequirementsCheck;
import com.teamscale.index.repository.git.common.voting_info.LineCoverageVotingInfo;
import com.teamscale.index.repository.git.common.voting_info.TestGapVotingInfo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.core.logging.LoggingUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.error.FormatException;
import org.conqat.lib.commons.function.ConsumerWithTwoExceptions;
import org.conqat.lib.commons.version.Version;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class BitbucketServerMergeRequestAnnotationTrigger
extends MergeRequestAnnotationTriggerBase<BitbucketServerPullRequest, CommitStatus> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MARKER_START = "[//]: # (Teamscale start)";
    public static final String MARKER_END = "[//]: # (Teamscale end)";
    private static final String OUTDATED_PULL_REQUEST_MESSAGE = "You are attempting to add a comment on an out-of-date pull request";
    private static final String COMMENT_OUTDATED_TEXT = "This comment is potentially outdated! It could not be deleted because someone replied to it.";
    private static final long MAX_BITBUCKET_FILES_CHANGED_PER_PR = Long.parseLong(System.getProperty("com.teamscale.max-bitbucket-changes-per-pull-request", "1000"));
    private static final Version MIN_VERSION_FOR_NEW_COMMIT_STATUS_API = new Version(7, 4);
    private BitbucketServerClient client;
    private ExternalCredentials credentials;
    private BitbucketServerRepositoryIdentifier repositoryIdentifier;
    private final Supplier<Boolean> isNewCommitStatusApiSupported = Suppliers.memoize(this::bitbucketVersionSupportsNewCommitStatusApi);

    public BitbucketServerMergeRequestAnnotationTrigger() {
    }

    @VisibleForTesting
    protected BitbucketServerMergeRequestAnnotationTrigger(BitbucketServerClient client, BitbucketServerRepositoryIdentifier repositoryIdentifier) {
        this.client = client;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    @VisibleForTesting
    static @Nullable BitbucketServerReviewer[] handleInvalidReviewersException(@Language(value="JSON") String responseBody, BitbucketServerPullRequest pullRequest) throws ServiceCallException {
        JsonNode response;
        try {
            response = JsonUtils.deserializeFromJson((String)responseBody);
        }
        catch (JsonSerializationException e) {
            throw new ServiceCallException("Could not deserialize JSON response", (Throwable)e);
        }
        JsonNode firstError = response.get("errors").get(0);
        if (!"com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException".equals(firstError.get("exceptionName").textValue())) {
            return null;
        }
        ArrayList<BitbucketServerReviewer> reviewers = new ArrayList<BitbucketServerReviewer>(List.of(pullRequest.reviewers()));
        for (JsonNode reviewerError : firstError.get("reviewerErrors")) {
            if (!reviewerError.get("message").textValue().endsWith("is not a user.")) {
                throw new ServiceCallException("Could not fix reviewer error for BitbucketServer merge request.");
            }
            String user = reviewerError.get("context").textValue();
            reviewers.removeIf(reviewer -> reviewer.user().name().equals(user));
            LOGGER.debug("Removing invalid reviewer {} from pull request.", (Object)user);
        }
        return reviewers.toArray(new BitbucketServerReviewer[0]);
    }

    @Override
    protected MergeRequestProvider<BitbucketServerPullRequest, CommitStatus> createMergeRequestProvider(CommitVotingTriggerBase.SchedulingParameters schedulingParameters) throws StorageException {
        this.credentials = MergeRequestUpdateTriggerBase.extractCredentials(schedulingParameters.connector(), this.indexLayer.openGlobalStorageSystem());
        this.client = new BitbucketServerClient(this.credentials.uri, this.credentials.username, this.credentials.password, LOGGER);
        this.repositoryIdentifier = BitbucketServerRepositoryIdentifier.fromRepositoryName(BitbucketServerMergeRequestAnnotationTrigger.getRepositoryName(schedulingParameters.connector()));
        return new BitbucketServerMergeRequestProvider(this.repositoryIdentifier, this.client, VotingConnectorUtils.getBuildIncludeExcludePatterns(schedulingParameters.connector()));
    }

    @Override
    protected void handleVotingException(CommitVotingTriggerBase.SchedulingParameters schedulingParameters, MergeRequest mergeRequest, VotingException votingException) {
        if (!EFeatureToggle.ENABLE_MERGE_REQUEST_ANALYSIS_IN_PROGRESS_NOTIFICATION.isEnabled()) {
            return;
        }
        BitbucketServerRepositoryIdentifier repositoryIdentifier = BitbucketServerMergeRequestAnnotationTrigger.getPlatformRepositoryIdentifier(schedulingParameters.connector());
        try {
            Optional<BitbucketServerCodeInsightReport> existingReport = this.getExistingReport(mergeRequest, repositoryIdentifier);
            if (existingReport.isEmpty() || !BitbucketServerUtils.getAnalysisInProgressText(mergeRequest.sourceHead).equals(existingReport.get().details())) {
                LOGGER.debug(LoggingUtils.INTERACTION, "No clean up required: No existing pending report found.", (Throwable)votingException);
                return;
            }
            if (votingException instanceof VotingException.Skipped) {
                VotingException.Skipped skipped = (VotingException.Skipped)votingException;
                if (skipped.getReason() == VotingException.Skipped.Reason.ALREADY_VOTED) {
                    return;
                }
                this.client.deleteTeamscaleReport(repositoryIdentifier, mergeRequest.sourceHead);
                this.client.postAnalysisSkippedReport(repositoryIdentifier, mergeRequest.sourceHead, (TeamscaleProjectLinkProvider)schedulingParameters.linkProvider(), mergeRequest.identifier, skipped.getMessage());
            } else {
                this.client.postAnalysisErrorReport(repositoryIdentifier, mergeRequest.sourceHead, (TeamscaleProjectLinkProvider)schedulingParameters.linkProvider(), mergeRequest.identifier, votingException.getMessage());
            }
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed set conclusion for Code Insights report in merge request {}.", (Object)mergeRequest.identifier);
        }
    }

    private Optional<BitbucketServerCodeInsightReport> getExistingReport(MergeRequest mergeRequest, PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        try {
            return Optional.ofNullable(this.client.getTeamscaleReport(repositoryIdentifier, mergeRequest.sourceHead));
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
    }

    @VisibleForTesting
    protected ExternalCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    protected void addLineCommentLimitWarningToDescription(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String commentLimitWarningExceededMessage, String commentLimitWarningFormat) throws ServiceCallException {
        block2: {
            BitbucketServerRepositoryIdentifier repositoryIdentifier = BitbucketServerMergeRequestAnnotationTrigger.getPlatformRepositoryIdentifier(schedulingParams.connector());
            BitbucketServerPullRequest pullRequest = this.client.getPullRequest(repositoryIdentifier, input.mergeRequest.getId());
            String newDescription = MergeRequestAnnotationUtils.compileDescriptionWithLimitCommentWarning(commentLimitWarningExceededMessage, pullRequest.description(), MARKER_START, MARKER_END, commentLimitWarningFormat);
            try {
                this.client.putPullRequestDescription(repositoryIdentifier, input.mergeRequest.getId(), pullRequest.version(), newDescription, pullRequest.reviewers());
            }
            catch (ServiceCallException e) {
                BitbucketServerReviewer[] newReviewers = this.handle409Error(input, pullRequest, e);
                if (newReviewers == null) break block2;
                this.client.putPullRequestDescription(repositoryIdentifier, input.mergeRequest.getId(), pullRequest.version(), newDescription, newReviewers);
            }
        }
    }

    private @Nullable BitbucketServerReviewer[] handle409Error(MergeRequestAnnotationInput input, BitbucketServerPullRequest pullRequest, ServiceCallException e) throws ServiceCallException {
        if (e.getStatusCode() != 409) {
            throw e;
        }
        BitbucketServerReviewer[] newReviewers = BitbucketServerMergeRequestAnnotationTrigger.handleInvalidReviewersException(e.getResponseBody(), pullRequest);
        if (newReviewers != null) {
            LOGGER.warn("Attempted to fix pull request by removing reviewers. Trying again.");
            return newReviewers;
        }
        this.rescheduleTriggerIfNecessary(e, input);
        return null;
    }

    @Override
    protected Set<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> getMergeRequestAnnotationMechanisms(ConnectorConfiguration connector) {
        HashSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism> result = new HashSet<MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism>();
        if (CcpIntegrationFeatureEnablements.isOptionEnabled("Add Detailed Line Comments For Findings and Test Gaps as Pull Request Comments", false, connector)) {
            result.add(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.INLINE_COMMENTS);
        }
        if (CcpIntegrationFeatureEnablements.isOptionEnabled("Add Detailed Line Comments For Findings and Test Gaps as Code Insights Report", true, connector)) {
            result.add(MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism.PLATFORM_SPECIFIC);
        }
        return result;
    }

    @Override
    protected void deleteInlineFindingsCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteInlineCommentsAfterCommentLimitExceeded(schedulingParams, input, comment -> CcpCommentUtils.isTeamscaleFindingsComment(comment.getText()));
    }

    @Override
    protected void deleteInlineTestGapCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteInlineCommentsAfterCommentLimitExceeded(schedulingParams, input, comment -> CcpCommentUtils.isMarkdownTeamscaleTestGapComment(comment.getText()));
    }

    @VisibleForTesting
    public void deleteInlineCommentsAfterCommentLimitExceeded(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, Predicate<BitbucketServerPullRequestComment> filterPredicate) throws ServiceCallException {
        LOGGER.traceEntry();
        block4: for (MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism annotationMechanism : this.getMergeRequestAnnotationMechanisms(schedulingParams.connector())) {
            switch (annotationMechanism) {
                case PLATFORM_SPECIFIC: {
                    continue block4;
                }
                case INLINE_COMMENTS: {
                    BitBucketServerPullRequestChanges changes = this.client.getPullRequestChanges(this.repositoryIdentifier, input.mergeRequest.getId());
                    this.deleteExistingPullRequestComments(changes.getValues(), this.repositoryIdentifier, input.mergeRequest, filterPredicate);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown enum value " + String.valueOf((Object)annotationMechanism));
        }
        LOGGER.traceExit();
    }

    @Override
    protected void addBadgesToMergeRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, String badgeAsMarkdown) throws ServiceCallException, StorageException {
        block2: {
            BitbucketServerPullRequest pullRequest = this.client.getPullRequest(this.repositoryIdentifier, input.mergeRequest.getId());
            try {
                MergeRequestAnnotationUtils.updateDescription(pullRequest.description(), badgeAsMarkdown, MARKER_START, MARKER_END, BitbucketServerMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> this.client.putPullRequestDescription(this.repositoryIdentifier, input.mergeRequest.getId(), pullRequest.version(), (String)newDescription, pullRequest.reviewers())));
            }
            catch (ServiceCallException e) {
                BitbucketServerReviewer[] bitbucketServerReviewers = this.handle409Error(input, pullRequest, e);
                if (bitbucketServerReviewers == null) break block2;
                MergeRequestAnnotationUtils.updateDescription(pullRequest.description(), badgeAsMarkdown, MARKER_START, MARKER_END, BitbucketServerMergeRequestAnnotationTrigger.isBadgeSetToTopPosition(schedulingParams.connector()), (ConsumerWithTwoExceptions<String, ServiceCallException, StorageException>)((ConsumerWithTwoExceptions)newDescription -> this.client.putPullRequestDescription(this.repositoryIdentifier, input.mergeRequest.getId(), pullRequest.version(), (String)newDescription, bitbucketServerReviewers)));
            }
        }
    }

    @Override
    protected VotingRecord.EVotingState determineVotingStatesAndAddVotes(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException, StorageException {
        VotingRecord.EVotingState state = super.determineVotingStatesAndAddVotes(schedulingParams, input);
        this.reviewPullRequest(schedulingParams, input, state);
        return state;
    }

    @Override
    protected VotingRecord.EVotingState addFindingsVote(FindingsVotingInfo findingsVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        return this.postCommitStatus(schedulingParams, input, findingsVotingInfo, BitbucketUtils::createFindingsCommitStatus);
    }

    @Override
    protected VotingRecord.EVotingState addTestGapsVote(TestGapVotingInfo testGapVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        if (testGapVotingInfo.getVotingRequirementsCheckerResult() == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_GAP_VOTING_DISABLED) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        return this.checkRequirementsAndCreateCommitStatus(testGapVotingInfo, schedulingParams, input, BitbucketUtils::createTestGapCommitStatus);
    }

    @Override
    protected VotingRecord.EVotingState addTestCoverageVote(LineCoverageVotingInfo coverageVotingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        return this.checkRequirementsAndCreateCommitStatus(coverageVotingInfo, schedulingParams, input, BitbucketUtils::createTestCoverageCommitStatus);
    }

    private <T extends IVotingInfoWithRequirementsCheck> VotingRecord.EVotingState checkRequirementsAndCreateCommitStatus(T votingInfo, CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, BiFunction<T, String, CommitStatus> commitStatusCreator) throws ServiceCallException {
        if (votingInfo.isPositiveVote()) {
            return this.postCommitStatus(schedulingParams, input, votingInfo, commitStatusCreator);
        }
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult = votingInfo.getVotingRequirementsCheckerResult();
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.BUILD_INCOMPLETE) {
            return VotingRecord.EVotingState.VOTED_INCOMPLETE_BUILD;
        }
        if (votingRequirementsCheckerResult == TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult.TEST_GAP_VOTING_DISABLED) {
            return VotingRecord.EVotingState.VOTING_DISABLED;
        }
        if (!votingRequirementsCheckerResult.isRequirementsFulfilled()) {
            return VotingRecord.EVotingState.VOTED;
        }
        return this.postCommitStatus(schedulingParams, input, votingInfo, commitStatusCreator);
    }

    private <T extends IVotingInfo> VotingRecord.EVotingState postCommitStatus(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, T votingInfo, BiFunction<T, String, CommitStatus> commitStatusCreator) throws ServiceCallException {
        String targetUrl = input.createMergeRequestDetailsLink(schedulingParams.linkProvider());
        CommitStatus status = commitStatusCreator.apply(votingInfo, targetUrl);
        if (this.isNewCommitStatusApiSupported.get().booleanValue()) {
            this.client.postNewCommitStatus(PlatformRepositoryIdentifier.fromRepositoryName(input.mergeRequest.getRepositoryName()), status, input.mergeRequest.sourceHead);
        } else {
            this.client.postNewLegacyCommitStatus(status, input.mergeRequest.sourceHead);
        }
        return votingInfo.isPositiveVote() ? VotingRecord.EVotingState.VOTED_POSITIVE : VotingRecord.EVotingState.VOTED_NEGATIVE;
    }

    private void reviewPullRequest(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, VotingRecord.EVotingState state) throws ServiceCallException {
        if (!CcpIntegrationFeatureEnablements.isVotingReviewEnabled(schedulingParams.connector())) {
            return;
        }
        if (state != VotingRecord.EVotingState.VOTED_POSITIVE && state != VotingRecord.EVotingState.VOTED_NEGATIVE) {
            return;
        }
        BitbucketServerCodeStatus codeStatus = EBitbucketServerCodeStatus.NEEDS_WORK.getStatus();
        if (state == VotingRecord.EVotingState.VOTED_POSITIVE) {
            codeStatus = EBitbucketServerCodeStatus.APPROVED.getStatus();
        }
        this.client.putPullRequestReview(BitbucketServerMergeRequestAnnotationTrigger.getPlatformRepositoryIdentifier(schedulingParams.connector()), input.mergeRequest.getId(), this.getCredentials().username, codeStatus);
    }

    @Override
    protected void addInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism mechanism) throws ServiceCallException, StorageException {
        BitbucketServerPullRequestDiffs diffs = this.client.getPullRequestDiff(this.repositoryIdentifier, input.mergeRequest.getId());
        TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult testGapCheckerResult = this.checkTestGapLineCommentsRequirements(schedulingParams, input);
        block4: for (MergeRequestAnnotationTriggerBase.MergeRequestAnnotationMechanism annotationMechanism : this.getMergeRequestAnnotationMechanisms(schedulingParams.connector())) {
            switch (annotationMechanism) {
                case PLATFORM_SPECIFIC: {
                    this.postCodeInsightAnnotations(schedulingParams, input, reviewComments, this.repositoryIdentifier, diffs, testGapCheckerResult);
                    continue block4;
                }
                case INLINE_COMMENTS: {
                    BitBucketServerPullRequestChanges changes = this.client.getPullRequestChanges(this.repositoryIdentifier, input.mergeRequest.getId());
                    this.postInlineComments(schedulingParams, input, reviewComments, this.repositoryIdentifier, changes, diffs, testGapCheckerResult);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown enum value " + String.valueOf((Object)annotationMechanism));
        }
    }

    @Override
    protected void addBadgesAsMergeRequestComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteExistingPullRequestComments(input, comment -> CcpCommentUtils.isTeamscaleBadgeComment(comment.getText()));
        String badgeAsMarkdown = this.buildMergeRequestMarkdownContent(input, schedulingParams.linkProvider());
        this.postPullRequestComment(input.mergeRequest.getId(), badgeAsMarkdown);
    }

    @Override
    protected void deleteExistingTestGapSummaryComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input) throws ServiceCallException {
        this.deleteExistingPullRequestComments(input, comment -> CcpCommentUtils.isTeamscaleTestGapSummaryComment(comment.getText()));
    }

    @Override
    protected void postTestGapSummaryComment(CommitVotingTriggerBase.SchedulingParameters schedulingParams, long pullRequestId, String commentContent) throws ServiceCallException {
        this.postPullRequestComment(pullRequestId, commentContent);
    }

    private void deleteExistingPullRequestComments(MergeRequestAnnotationInput input, Predicate<BitbucketServerPullRequestComment> commentFilter) throws ServiceCallException {
        long pullRequestId = input.mergeRequest.getId();
        List<BitbucketServerPullRequestComment> pullRequestComments = this.client.getPullRequestComments(this.repositoryIdentifier, pullRequestId);
        List existingAggregatedTeamscaleComments = CollectionUtils.filter(pullRequestComments, commentFilter);
        for (BitbucketServerPullRequestComment comment : existingAggregatedTeamscaleComments) {
            this.deleteOrReplyToComment(comment, this.repositoryIdentifier, input.mergeRequest);
        }
    }

    private void postPullRequestComment(long pullRequestId, String commentContent) throws ServiceCallException {
        this.client.postGeneralPullRequestComment(this.repositoryIdentifier, pullRequestId, new BitbucketServerPullRequestComment(null, commentContent, null));
    }

    @VisibleForTesting
    protected void postInlineComments(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, PlatformRepositoryIdentifier repositoryIdentifier, BitBucketServerPullRequestChanges changes, BitbucketServerPullRequestDiffs diffs, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult testGapCheckerResult) throws ServiceCallException, StorageException {
        if (BitbucketServerMergeRequestAnnotationTrigger.exceedsMaximumChangesPerPrLimit(changes.getValues())) {
            LOGGER.warn("Merge request {} has too many changed files. Skipping updating and posting of diff line comments.", (Object)input.mergeRequest.identifier);
            this.concludeInProgressReport(repositoryIdentifier, input, schedulingParams, testGapCheckerResult);
            return;
        }
        List<BitbucketServerPullRequestComment> existingComments = this.getExistingPullRequestDiffComments(input.mergeRequest.getId(), changes.getValues());
        HashMap<String, BitbucketServerPullRequestComment> findingIdsToComments = new HashMap<String, BitbucketServerPullRequestComment>();
        HashMap<String, BitbucketServerPullRequestComment> normalisedExistingTestGapComments = new HashMap<String, BitbucketServerPullRequestComment>();
        BitbucketServerMergeRequestAnnotationTrigger.collectFindingsAndTestGapComments(existingComments, findingIdsToComments, normalisedExistingTestGapComments);
        for (BitbucketServerInlinePullRequestComment newComment : BitbucketServerUtils.createInlineComments(changes, reviewComments, diffs)) {
            this.updateOrCreatePullRequestComment(newComment, findingIdsToComments, normalisedExistingTestGapComments, input.mergeRequest.getId());
        }
        this.deleteOutdatedComments(input.mergeRequest, findingIdsToComments, normalisedExistingTestGapComments);
        this.concludeInProgressReport(repositoryIdentifier, input, schedulingParams, testGapCheckerResult);
    }

    @VisibleForTesting
    protected List<BitbucketServerPullRequestComment> getExistingPullRequestDiffComments(long pullRequestId, List<BitbucketServerDiffPath> diffChangedPaths) throws ServiceCallException {
        ArrayList<BitbucketServerPullRequestComment> existingComments = new ArrayList<BitbucketServerPullRequestComment>();
        for (BitbucketServerDiffPath diffPath : diffChangedPaths) {
            List pullRequestComments = this.client.getPullRequestCommentsForPath(this.repositoryIdentifier, pullRequestId, diffPath.getPath());
            pullRequestComments = CollectionUtils.filter(pullRequestComments, comment -> CcpCommentUtils.isDeletableTeamscaleComment(comment.getText()));
            existingComments.addAll(pullRequestComments);
        }
        return existingComments;
    }

    @VisibleForTesting
    protected static void collectFindingsAndTestGapComments(List<BitbucketServerPullRequestComment> existingComments, Map<String, BitbucketServerPullRequestComment> findingIdsToComments, Map<String, BitbucketServerPullRequestComment> normalisedExistingTestGapComments) {
        for (BitbucketServerPullRequestComment teamscaleComment : existingComments) {
            Optional<String> findingId = CcpCommentUtils.extractFindingIdFromComment(teamscaleComment.getText());
            findingId.ifPresent(s -> findingIdsToComments.put((String)s, teamscaleComment));
            if (findingId.isPresent()) continue;
            Optional<String> normalisedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(teamscaleComment.getText());
            normalisedTestGapComment.ifPresent(comment -> normalisedExistingTestGapComments.put((String)comment, teamscaleComment));
        }
    }

    @VisibleForTesting
    protected void deleteOutdatedComments(MergeRequest mergeRequest, Map<String, BitbucketServerPullRequestComment> findingIdsToComments, Map<String, BitbucketServerPullRequestComment> normalisedExistingTestGapComments) throws ServiceCallException {
        for (Map.Entry<String, BitbucketServerPullRequestComment> entry : findingIdsToComments.entrySet()) {
            this.deleteOrReplyToComment(entry.getValue(), this.repositoryIdentifier, mergeRequest);
        }
        for (Map.Entry<String, BitbucketServerPullRequestComment> entry : normalisedExistingTestGapComments.entrySet()) {
            this.deleteOrReplyToComment(entry.getValue(), this.repositoryIdentifier, mergeRequest);
        }
    }

    private void updateOrCreatePullRequestComment(BitbucketServerInlinePullRequestComment newComment, Map<String, BitbucketServerPullRequestComment> existingCommentsByFindingId, Map<String, BitbucketServerPullRequestComment> normalisedExistingTestGapComments, long pullRequestId) throws ServiceCallException {
        Optional<String> findingsId = CcpCommentUtils.extractFindingIdFromComment(newComment.text());
        if (findingsId.isEmpty() || !existingCommentsByFindingId.containsKey(findingsId.get())) {
            Optional<String> normalizedTestGapComment = CcpCommentUtils.extractNormalizedTestGapComment(newComment.text());
            if (normalizedTestGapComment.isPresent() && normalisedExistingTestGapComments.remove(normalizedTestGapComment.get()) != null) {
                return;
            }
            try {
                this.client.postInlinePullRequestComment(this.repositoryIdentifier, pullRequestId, newComment);
            }
            catch (ServiceCallException e) {
                this.logServiceCallFailures(e);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Posting pull request comment failed: {}", (Object)e.getMessage(), (Object)e);
            }
            return;
        }
        BitbucketServerPullRequestComment existingComment = existingCommentsByFindingId.remove(findingsId.get());
        if (CcpCommentUtils.normalizeCommentText(newComment.text()).equals(CcpCommentUtils.normalizeCommentText(existingComment.getText()))) {
            return;
        }
        BitbucketServerPullRequestComment updatedComment = new BitbucketServerPullRequestComment(existingComment.getId(), newComment.text(), existingComment.getVersion());
        this.client.updateInlinePullRequestComment(this.repositoryIdentifier, pullRequestId, existingComment.getId(), updatedComment);
    }

    @VisibleForTesting
    public void postCodeInsightAnnotations(CommitVotingTriggerBase.SchedulingParameters schedulingParams, MergeRequestAnnotationInput input, List<IReviewComment> reviewComments, PlatformRepositoryIdentifier repositoryIdentifier, BitbucketServerPullRequestDiffs diffs, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult testGapCheckerResult) throws ServiceCallException, StorageException {
        boolean shouldAddTeamscalePrefix = this.client.hasForeignReport(repositoryIdentifier, input.mergeRequest.sourceHead);
        List<BitbucketServerCodeInsightAnnotation> commentsToBeAdded = BitbucketServerUtils.createCodeInsightAnnotationsFromFindings(reviewComments, diffs, shouldAddTeamscalePrefix);
        this.concludeInProgressReport(repositoryIdentifier, input, schedulingParams, testGapCheckerResult);
        for (BitbucketServerCodeInsightAnnotation codeInsightAnnotation : commentsToBeAdded) {
            try {
                this.client.postCodeInsightAnnotation(repositoryIdentifier, input.mergeRequest.getId(), codeInsightAnnotation, input.mergeRequest);
            }
            catch (ServiceCallException e) {
                this.logServiceCallFailures(e);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Posting code insight annotation failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void concludeInProgressReport(PlatformRepositoryIdentifier repositoryIdentifier, MergeRequestAnnotationInput input, CommitVotingTriggerBase.SchedulingParameters schedulingParams, TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult testGapCheckerResult) throws ServiceCallException, StorageException {
        if (this.client.hasTeamscaleReport(repositoryIdentifier, input.mergeRequest.sourceHead)) {
            this.client.deleteTeamscaleReport(repositoryIdentifier, input.mergeRequest.sourceHead);
        }
        FindingsVotingInfo findingsVotingInfo = new FindingsVotingInfo(input.getAddedRedFindings(), input.getAddedYellowFindings(), input.ignoreYellowFindingsForVotes);
        TestGapVotingInfo testGapVotingInfo = VotingConnectorUtils.computeTestGapVotingInfo(testGapCheckerResult, schedulingParams, input);
        LineCoverageVotingInfo lineCoverageVotingInfo = VotingConnectorUtils.computeLineCoverageVotingInfo(this.openProjectStorageSystem(), this.getExternalUploadsVotingCondition(), schedulingParams, input);
        String reportDetails = BitbucketServerMergeRequestAnnotationTrigger.createConcludedReportDetails(input, findingsVotingInfo, testGapVotingInfo, lineCoverageVotingInfo);
        this.client.postConcludedReport(repositoryIdentifier, schedulingParams.linkProvider(), input.mergeRequest, reportDetails);
    }

    private static String createConcludedReportDetails(MergeRequestAnnotationInput input, FindingsVotingInfo findingsVotingInfo, TestGapVotingInfo testGapVotingInfo, LineCoverageVotingInfo lineCoverageVotingInfo) {
        return "Teamscale finished analyzing commit " + input.mergeRequest.sourceHead + ".\n\n- Findings: " + findingsVotingInfo.toReadableDescription() + "\n- Test Gaps: " + testGapVotingInfo.toReadableDescription() + "\n- Line Coverage: " + lineCoverageVotingInfo.toReadableDescription();
    }

    private void logServiceCallFailures(ServiceCallException e) {
        if (e.getStatusCode() == 409 && e.getResponseBody().contains(OUTDATED_PULL_REQUEST_MESSAGE)) {
            LOGGER.warn("Pull request became outdated while commenting. This can happen if new commits are pushed while voting on an older commit. Teamscale will comment on the new latest commit instead and skip commit {}", (Object)this.jobDescriptor.getSchedulingCommit(), (Object)e);
            return;
        }
        LOGGER.error("Posting pull request comment failed: {}", (Object)e.getMessage(), (Object)e);
    }

    @VisibleForTesting
    public void deleteExistingPullRequestComments(List<BitbucketServerDiffPath> diffChangedPaths, PlatformRepositoryIdentifier repositoryIdentifier, MergeRequest mergeRequest, Predicate<BitbucketServerPullRequestComment> filterPredicate) throws ServiceCallException {
        if (BitbucketServerMergeRequestAnnotationTrigger.exceedsMaximumChangesPerPrLimit(diffChangedPaths)) {
            LOGGER.warn("Merge request {} has too many changed files. Skipping deletion of existing pull request diff comments.", (Object)mergeRequest.identifier);
            return;
        }
        for (BitbucketServerDiffPath diffPath : diffChangedPaths) {
            List pullRequestComments = this.client.getPullRequestCommentsForPath(repositoryIdentifier, mergeRequest.getId(), diffPath.getPath());
            pullRequestComments = CollectionUtils.filter(pullRequestComments, filterPredicate);
            for (BitbucketServerPullRequestComment comment : pullRequestComments) {
                this.deleteOrReplyToComment(comment, repositoryIdentifier, mergeRequest);
            }
        }
    }

    @VisibleForTesting
    public static boolean exceedsMaximumChangesPerPrLimit(List<BitbucketServerDiffPath> diffChangedPaths) {
        return (long)diffChangedPaths.size() > MAX_BITBUCKET_FILES_CHANGED_PER_PR;
    }

    private void deleteOrReplyToComment(BitbucketServerPullRequestComment comment, PlatformRepositoryIdentifier repositoryIdentifier, MergeRequest mergeRequest) throws ServiceCallException {
        if (comment.getReplies().isEmpty()) {
            this.deleteComment(comment, repositoryIdentifier, mergeRequest);
        } else {
            this.declareCommentPotentiallyOutdated(comment, repositoryIdentifier, mergeRequest);
        }
    }

    private void declareCommentPotentiallyOutdated(BitbucketServerPullRequestComment comment, PlatformRepositoryIdentifier repositoryIdentifier, MergeRequest mergeRequest) throws ServiceCallException {
        for (BitbucketServerPullRequestComment reply : comment.getReplies()) {
            if (!reply.getText().contains(COMMENT_OUTDATED_TEXT)) continue;
            return;
        }
        BitbucketServerPullRequestComment newReply = new BitbucketServerPullRequestComment(null, COMMENT_OUTDATED_TEXT, null, comment.getId());
        this.client.postGeneralPullRequestComment(repositoryIdentifier, mergeRequest.getId(), newReply);
    }

    private void deleteComment(BitbucketServerPullRequestComment comment, PlatformRepositoryIdentifier repositoryIdentifier, MergeRequest mergeRequest) throws ServiceCallException {
        Preconditions.checkArgument((boolean)comment.getReplies().isEmpty(), (Object)"Comment must not have replies.");
        this.client.deletePullRequestComment(repositoryIdentifier, mergeRequest.getId(), comment.getId(), comment.getVersion());
    }

    private static BitbucketServerRepositoryIdentifier getPlatformRepositoryIdentifier(ConnectorConfiguration connector) {
        return BitbucketServerRepositoryIdentifier.fromRepositoryName(BitbucketServerMergeRequestAnnotationTrigger.getRepositoryName(connector));
    }

    @Override
    protected ERepositoryConnector getRepositoryConnector() {
        return ERepositoryConnector.BITBUCKET_SERVER;
    }

    private void rescheduleTriggerIfNecessary(ServiceCallException serviceCallException, MergeRequestAnnotationInput input) throws ServiceCallException {
        try {
            MergeRequestUpdateTriggerBase.JobParameter parameter = new MergeRequestUpdateTriggerBase.JobParameter(input.mergeRequest.identifier, false, null);
            JobDescriptor job = new JobDescriptor(this.jobDescriptor.getInternalProjectId(), BitbucketServerMergeRequestUpdateTrigger.class, null, (Object)parameter, "Reschedule trigger created with reason '" + this.jobDescriptor.getSchedulingReason() + "' because we tried to update a pull request with outdated information.");
            ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
            throw serviceCallException;
        }
        catch (StorageException exception) {
            throw new ServiceCallException("Could not reschedule trigger after pull request description update failed", (Throwable)exception);
        }
    }

    private boolean bitbucketVersionSupportsNewCommitStatusApi() {
        String bitbucketVersion;
        try {
            bitbucketVersion = this.client.getServerVersion();
        }
        catch (ServiceCallException e) {
            BitbucketServerMergeRequestAnnotationTrigger.logVersionCheckError("fetching the Bitbucket version failed", (Exception)((Object)e));
            return false;
        }
        try {
            Version version = Version.parseVersion((String)bitbucketVersion);
            return version.isGreaterOrEqual(MIN_VERSION_FOR_NEW_COMMIT_STATUS_API);
        }
        catch (FormatException e) {
            BitbucketServerMergeRequestAnnotationTrigger.logVersionCheckError("parsing the Bitbucket version '" + bitbucketVersion + "' failed", (Exception)((Object)e));
            return false;
        }
    }

    private static void logVersionCheckError(String message, Exception cause) {
        LOGGER.atError().withThrowable((Throwable)cause).log("Cannot check if new build status API is supported because {}. Will use the legacy API.", (Object)message);
    }

    @Override
    protected boolean appendSizeValuesToMarkdownImage() {
        boolean shouldResize = false;
        Version minimumVersion = new Version(7, 5);
        try {
            shouldResize = !BitbucketServerRepositoryConnectorDescriptor.isOutdatedServerVersion(minimumVersion, this.client.getServerVersion());
        }
        catch (ServiceCallException e) {
            LOGGER.error("Failed to retrieve server version for Bitbucket. Markdown images will not be resized in pull requests.", (Throwable)e);
        }
        return shouldResize;
    }

    @Override
    protected boolean omitTitleInMarkdownImage() {
        return true;
    }
}

