/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.git.bitbucket.server.client.IParsedDiffHandler;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerDiffLine;
import com.teamscale.index.repository.git.bitbucket.server.model.pull_requests.changes.diff.BitbucketServerPullRequestDiff;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

public class BitbucketServerPullRequestDiffs
implements IParsedDiffHandler<BitbucketServerPullRequestDiff> {
    @JsonProperty(value="fromHash")
    private String fromHash;
    @JsonProperty(value="toHash")
    private String toHash;
    @JsonProperty(value="diffs")
    private BitbucketServerPullRequestDiff[] diffs = new BitbucketServerPullRequestDiff[0];

    @VisibleForTesting
    public BitbucketServerPullRequestDiffs() {
    }

    private List<BitbucketServerPullRequestDiff> getDiffs() {
        return Arrays.asList(this.diffs);
    }

    @Override
    public Map<String, PairList<Integer, Integer>> getPathToDiffRightSideRangesMap() {
        HashMap<String, PairList<Integer, Integer>> result = new HashMap<String, PairList<Integer, Integer>>();
        this.getRightSideDiffs().forEach(diff -> result.put(diff.getDestinationPath(), diff.getDestinationRangesFromHunks()));
        return result;
    }

    public Map<String, PairList<Integer, Integer>> getPathToChangedLinesDiffRightSideRangesMap() {
        HashMap<String, PairList<Integer, Integer>> result = new HashMap<String, PairList<Integer, Integer>>();
        this.getRightSideDiffs().forEach(diff -> result.put(diff.getDestinationPath(), diff.getDestinationRangesForChangedLinesOnlyFromHunks()));
        return result;
    }

    @Override
    public Map<String, Map<Integer, Integer>> getPathToDiffLinesMap() {
        HashMap<String, Map<Integer, Integer>> result = new HashMap<String, Map<Integer, Integer>>();
        this.getRightSideDiffs().forEach(diff -> {
            Map<Integer, Integer> contextLinesMap = diff.getAllDiffLines().stream().filter(line -> line.lineType().equals("CONTEXT")).collect(Collectors.toMap(BitbucketServerDiffLine::destinationLine, BitbucketServerDiffLine::sourceLine));
            result.put(diff.getDestinationPath(), contextLinesMap);
        });
        return result;
    }

    @Override
    public List<BitbucketServerPullRequestDiff> getRightSideDiffs() {
        return CollectionUtils.filter(this.getDiffs(), diff -> diff.getDestinationPath() != null && !diff.getHunks().isEmpty());
    }
}

