/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.conqat.lib.commons.string.StringUtils;

public class VoteOutputDetailsCreator<T> {
    private static final String AND_MORE_SUFFIX = "\nand more ...";
    private final String voteItemName;
    private final int maxTextLength;
    private final Function<T, String> voteItemDetailsCreator;

    public VoteOutputDetailsCreator(String voteItemName, Function<T, String> voteItemDetailsCreator, int maxTextLength) {
        this.voteItemName = voteItemName.toLowerCase();
        this.voteItemDetailsCreator = voteItemDetailsCreator;
        this.maxTextLength = maxTextLength;
    }

    public String createWithSeparatedItems(List<T> redItems, List<T> yellowItems, String redSectionTitle, String yellowSectionTitle) {
        return this.create(() -> redItems.isEmpty() && yellowItems.isEmpty(), builder -> this.addSeparatedVoteItems((StringBuilder)builder, redItems, yellowItems, redSectionTitle, yellowSectionTitle));
    }

    private void addSeparatedVoteItems(StringBuilder builder, List<T> redItems, List<T> yellowItems, String redSectionTitle, String yellowSectionTitle) {
        boolean textLimitNotReached = true;
        if (!redItems.isEmpty()) {
            builder.append("### ").append(redSectionTitle).append(" to be fixed before merging\n");
            textLimitNotReached = this.addVoteItems(redItems, builder);
        }
        if (textLimitNotReached && !yellowItems.isEmpty() && this.addTextWithMaxLengthCheck(builder, "### " + yellowSectionTitle + " that may be fixed after merging\n")) {
            this.addVoteItems(yellowItems, builder);
        }
    }

    public String createWithCombinedItems(List<T> items, String sectionTitle) {
        return this.create(items::isEmpty, builder -> {
            builder.append("### ").append(StringUtils.capitalize((String)sectionTitle)).append("\n");
            this.addVoteItems(items, (StringBuilder)builder);
        });
    }

    private String create(Supplier<Boolean> isEmpty, Consumer<StringBuilder> itemDetailsCreator) {
        if (isEmpty.get().booleanValue()) {
            return VoteOutputDetailsCreator.getNoDetailsText(this.voteItemName);
        }
        StringBuilder builder = new StringBuilder();
        itemDetailsCreator.accept(builder);
        Preconditions.checkState((builder.length() <= this.maxTextLength ? 1 : 0) != 0, (Object)"Details text is longer than text field limit.");
        return builder.toString();
    }

    public static String getNoDetailsText(String voteItemName) {
        return "There are no " + voteItemName + " details to show.";
    }

    private boolean addVoteItems(List<T> items, StringBuilder builder) {
        for (T item : items) {
            String nextLine = this.voteItemDetailsCreator.apply(item);
            if (this.addTextWithMaxLengthCheck(builder, nextLine)) continue;
            return false;
        }
        return true;
    }

    private boolean addTextWithMaxLengthCheck(StringBuilder builder, String textToAdd) {
        if (builder.length() + textToAdd.length() > this.maxTextLength - AND_MORE_SUFFIX.length()) {
            builder.append(AND_MORE_SUFFIX);
            return false;
        }
        builder.append(textToAdd);
        return true;
    }
}

