/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github;

import com.google.common.base.Suppliers;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.trigger.OptionScheduledTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.GitHubAppBasedRepositoryAccessHelper;
import com.teamscale.index.repository.git.github.GitHubCheckRunCleanupOption;
import com.teamscale.index.repository.git.github.GitHubRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.github.client.GitHubPullRequestClient;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunIndex;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunInfo;
import jakarta.ws.rs.InternalServerErrorException;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class GitHubCheckRunMaintenanceTrigger
extends OptionScheduledTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Supplier<LocalDateTime> now = Suppliers.memoize(LocalDateTime::now);
    private static final String SKIP_REASON = "Skipping Teamscale analysis as this check run as been running for more than a day. Please talk to your Teamscale administrator if this happens for the most recent commits on your pull requests.";
    private boolean shouldStillBeScheduled = false;

    public GitHubCheckRunMaintenanceTrigger() {
    }

    @TestOnly
    public GitHubCheckRunMaintenanceTrigger(IndexLayer indexLayer) {
        this.indexLayer = indexLayer;
    }

    public void execute() throws Exception {
        if (((Boolean)TeamscaleSystemProperties.FORCE_DISABLE_GITHUB_CHECK_RUN_CLEANUP.getValue()).booleanValue()) {
            GitHubCheckRunCleanupOption.disable(this.indexLayer);
            return;
        }
        try {
            this.cleanupCheckRuns();
            if (!this.shouldStillBeScheduled) {
                GitHubCheckRunCleanupOption.disable(this.indexLayer);
            }
        }
        catch (InterruptedException e) {
            LOGGER.atInfo().withThrowable((Throwable)e).log("Cleaning check runs was cancelled and will be continued on next schedule.");
        }
    }

    private void cleanupCheckRuns() throws StorageException, InterruptedException, InternalServerErrorException {
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorage.openGlobalIndex(ServerOptionIndex.class);
        if (ShadowModeOption.isShadowModeEnabled((ServerOptionIndex)serverOptionIndex)) {
            LOGGER.info("Skipping because shadow mode is enabled.");
            this.shouldStillBeScheduled = true;
            return;
        }
        GitHubCheckRunMaintenanceTrigger.forEachCollectingExceptions(((ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class)).getAllInternalProjectIds(), this::handleProject);
    }

    private void handleProject(InternalProjectId projectId) throws StorageException, InterruptedException, ProjectConfigurationException {
        Map<PlatformRepositoryIdentifier, String> gitHubUrlByRepositoryName = GitHubCheckRunMaintenanceTrigger.getGitHubServerUrlByRepositoryName(this.indexLayer, projectId, (ProjectStorageSystem)this.indexLayer.openProjectStorageSystem((IProjectId)projectId));
        if (gitHubUrlByRepositoryName.isEmpty()) {
            return;
        }
        this.shouldStillBeScheduled = true;
        GitHubCheckRunMaintenanceTrigger.closeCheckRunsInProject(this.indexLayer, projectId, gitHubUrlByRepositoryName, checkRun -> GitHubCheckRunMaintenanceTrigger.shouldNotCloseCheckRun(checkRun, this.now.get()), () -> ((GitHubCheckRunMaintenanceTrigger)this).isCanceled());
    }

    public static void closeCheckRunsInProject(IndexLayer indexLayer, InternalProjectId projectId) throws StorageException, ProjectConfigurationException, InterruptedException {
        Map<PlatformRepositoryIdentifier, String> gitHubServerUrlByRepositoryName = GitHubCheckRunMaintenanceTrigger.getGitHubServerUrlByRepositoryName(indexLayer, projectId, (ProjectStorageSystem)indexLayer.openProjectStorageSystem((IProjectId)projectId));
        GitHubCheckRunMaintenanceTrigger.closeCheckRunsInProject(indexLayer, projectId, gitHubServerUrlByRepositoryName, checkRun -> false, () -> false);
    }

    private static void closeCheckRunsInProject(IndexLayer indexLayer, InternalProjectId projectId, Map<PlatformRepositoryIdentifier, String> gitHubUrlByRepositoryName, Predicate<CheckRun> shouldNotCloseCheckRunPredicate, Supplier<Boolean> cancelSupplier) throws StorageException, InterruptedException {
        CommitResolvingStorageSystem projectStorage = indexLayer.openProjectStorageSystem((IProjectId)projectId);
        GitHubCheckRunIndex checkRunIndex = (GitHubCheckRunIndex)projectStorage.openProjectIndex(GitHubCheckRunIndex.class, null);
        Map<PlatformRepositoryIdentifier, List<GitHubCheckRunInfo>> postedCheckRunsByRepo = checkRunIndex.readAll().stream().collect(Collectors.groupingBy(GitHubCheckRunInfo::getRepositoryIdentifier));
        ArrayList<GitHubCheckRunInfo> closedCheckRuns = new ArrayList<GitHubCheckRunInfo>();
        ArrayList<GitHubCheckRunInfo> notClosedCheckRuns = new ArrayList<GitHubCheckRunInfo>();
        for (Map.Entry<PlatformRepositoryIdentifier, List<GitHubCheckRunInfo>> entriesForRepo : postedCheckRunsByRepo.entrySet()) {
            if (cancelSupplier.get().booleanValue()) {
                throw new InterruptedException();
            }
            Optional<GitHubPullRequestClient> client = GitHubCheckRunMaintenanceTrigger.createClientForRepository(entriesForRepo.getKey(), gitHubUrlByRepositoryName, indexLayer.openGlobalStorageSystem());
            if (client.isEmpty()) continue;
            GitHubCheckRunMaintenanceTrigger.closeCheckRunsInRepository(entriesForRepo.getValue(), checkRunIndex, client.get(), shouldNotCloseCheckRunPredicate, cancelSupplier, closedCheckRuns, notClosedCheckRuns);
        }
        LOGGER.warn(StringUtils.pluralize((String)"Closed {} check run", (int)closedCheckRuns.size()), (Object)closedCheckRuns.size());
        LOGGER.warn(StringUtils.pluralize((String)"Could not close {} check run", (int)notClosedCheckRuns.size()), (Object)notClosedCheckRuns.size());
    }

    private static Optional<GitHubPullRequestClient> createClientForRepository(PlatformRepositoryIdentifier platformRepoIdentifier, Map<PlatformRepositoryIdentifier, String> gitHubUrlByRepositoryName, GlobalStorageSystem globalStorageSystem) throws StorageException {
        if (!gitHubUrlByRepositoryName.containsKey(platformRepoIdentifier)) {
            LOGGER.error("Could not find a GitHub connector for repository '{}'. Skipping check runs of this repository.", (Object)platformRepoIdentifier);
            return Optional.empty();
        }
        try {
            return Optional.of(new GitHubAppBasedRepositoryAccessHelper<ServiceCallException>(gitHubUrlByRepositoryName.get(platformRepoIdentifier), platformRepoIdentifier.asRepositoryName(), globalStorageSystem, ServiceCallException::new, LOGGER).createGitHubPullRequestClient());
        }
        catch (ServiceCallException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Could not create GitHub client for repository '{}'. Skipping check runs of this repository.", (Object)platformRepoIdentifier);
            return Optional.empty();
        }
    }

    private static void closeCheckRunsInRepository(List<GitHubCheckRunInfo> checkRunEntries, GitHubCheckRunIndex checkRunIndex, GitHubPullRequestClient client, Predicate<CheckRun> shouldNotCloseCheckRunPredicate, Supplier<Boolean> cancelSupplier, List<GitHubCheckRunInfo> closedCheckRuns, List<GitHubCheckRunInfo> notClosedCheckRuns) throws InterruptedException {
        for (GitHubCheckRunInfo checkRunEntry : checkRunEntries) {
            if (cancelSupplier.get().booleanValue()) {
                throw new InterruptedException();
            }
            try {
                boolean closed = GitHubCheckRunMaintenanceTrigger.closeCheckRun(checkRunEntry, checkRunIndex, client, shouldNotCloseCheckRunPredicate);
                if (closed) {
                    closedCheckRuns.add(checkRunEntry);
                    continue;
                }
                notClosedCheckRuns.add(checkRunEntry);
            }
            catch (Exception e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Failed to close check run with id '{}' for revision '{}'.", (Object)checkRunEntry.getCheckRunId(), (Object)checkRunEntry.getRevision());
                notClosedCheckRuns.add(checkRunEntry);
            }
        }
    }

    private static boolean closeCheckRun(GitHubCheckRunInfo checkRunEntry, GitHubCheckRunIndex checkRunIndex, GitHubPullRequestClient client, Predicate<CheckRun> shouldNotCloseCheckRun) throws StorageException {
        long checkRunId = checkRunEntry.getCheckRunId();
        PlatformRepositoryIdentifier platformRepoIdentifier = checkRunEntry.getRepositoryIdentifier();
        Optional<CheckRun> checkRun = client.getCheckRunById(platformRepoIdentifier, checkRunId);
        if (checkRun.isEmpty()) {
            LOGGER.warn("No check run found for revision '{}' and id '{}'. Will be retried next time.", (Object)checkRunEntry.getRevision(), (Object)checkRunId);
            return false;
        }
        if (shouldNotCloseCheckRun.test(checkRun.get())) {
            LOGGER.debug("Not closing check run with ID '{}', as it matches the predicate.", (Object)checkRunId);
            return false;
        }
        if (client.closeCheckRun(checkRun.get(), platformRepoIdentifier, "Skipped: running too long", SKIP_REASON)) {
            checkRunIndex.removeCheckRun(checkRunEntry.getRevision(), platformRepoIdentifier, checkRunEntry.getCheckRunType());
            LOGGER.warn("Closed check run '{}'.", (Object)checkRunId);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static boolean shouldNotCloseCheckRun(CheckRun checkRun, LocalDateTime now) {
        LocalDateTime checkRunDate = GitHubCheckRunMaintenanceTrigger.parseCreationDate(checkRun);
        if (checkRunDate == null) {
            return true;
        }
        if (checkRunDate.isAfter(now.minusDays(1L))) {
            LOGGER.debug("Check run '{}' is younger than one day; it will not be skipped yet.", (Object)checkRun.id());
            return true;
        }
        return false;
    }

    private static @Nullable LocalDateTime parseCreationDate(CheckRun checkRun) {
        try {
            return checkRun.parseStartDate();
        }
        catch (DateTimeParseException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to parse creation date for check run '{}'.", (Object)checkRun);
            return null;
        }
    }

    private static Map<PlatformRepositoryIdentifier, String> getGitHubServerUrlByRepositoryName(IndexLayer indexLayer, InternalProjectId projectId, ProjectStorageSystem projectStorage) throws ProjectConfigurationException, StorageException {
        IExternalCredentialsProvider credentialsProvider = (IExternalCredentialsProvider)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class);
        MetaIndex metaIndex = (MetaIndex)projectStorage.openProjectIndex(MetaIndex.class, null);
        return (Map)IStreamWithException.wrap(ConnectorUtils.getRepositoryConnectors((MetaIndex)metaIndex, (ERepositoryConnector)ERepositoryConnector.GITHUB).stream()).withException(ProjectConfigurationException.class).map(connector -> (GitHubRepositoryConnectorDescriptor)ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(indexLayer, credentialsProvider), (InternalProjectId)projectId)).collect(Collectors.toMap(descriptor -> PlatformRepositoryIdentifier.fromRepositoryName(descriptor.getRepositoryName()), descriptor -> descriptor.getGitHubServerUrl().url()));
    }

    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    private static <T> void forEachCollectingExceptions(Iterable<T> iterable, ConsumerWithException<T, Exception> consumer) throws InternalServerErrorException, InterruptedException {
        InternalServerErrorException aggregateException = null;
        for (T item : iterable) {
            try {
                consumer.accept(item);
            }
            catch (InterruptedException e) {
                if (aggregateException != null) {
                    aggregateException.addSuppressed((Throwable)e);
                    throw aggregateException;
                }
                throw e;
            }
            catch (Exception e) {
                if (aggregateException == null) {
                    aggregateException = new InternalServerErrorException("Errors occurred for some projects.");
                }
                aggregateException.addSuppressed((Throwable)e);
            }
        }
        if (aggregateException != null) {
            throw aggregateException;
        }
    }
}

