/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubClientBase;
import com.teamscale.core.rest.client.HttpPaginationUtils;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import com.teamscale.index.repository.git.github.client.IGitHubPullRequestApi;
import com.teamscale.index.repository.git.github.data.CheckRun;
import com.teamscale.index.repository.git.github.data.CheckRuns;
import com.teamscale.index.repository.git.github.data.CombinedCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubChangedFile;
import com.teamscale.index.repository.git.github.data.GitHubCommitStatus;
import com.teamscale.index.repository.git.github.data.GitHubPullRequest;
import com.teamscale.index.repository.git.github.data.GitHubPullRequestComment;
import com.teamscale.index.repository.git.github.data.MetaInfo;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class GitHubPullRequestClient
extends GitHubClientBase<IGitHubPullRequestApi> {
    public GitHubPullRequestClient(GitHubApplicationDescription applicationDescription, String accessToken, @Nullable Logger interactionLogger) {
        super(applicationDescription.getApiServer(), accessToken, interactionLogger, IGitHubPullRequestApi.class);
    }

    public List<GitHubPullRequestComment> getPullRequestComments(PlatformRepositoryIdentifier repositoryIdentifier, int pullRequestNumber) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getPullRequestComments(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, 100), ((IGitHubPullRequestApi)this.gitHubApi)::getPullRequestCommentsFromNextPage);
    }

    public void deletePullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, long commentId) throws ServiceCallException {
        ((IGitHubPullRequestApi)this.gitHubApi).deletePullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), commentId);
    }

    public void createPullRequestComment(PlatformRepositoryIdentifier repositoryIdentifier, int pullRequestNumber, GitHubPullRequestComment comment) throws ServiceCallException {
        ((IGitHubPullRequestApi)this.gitHubApi).createPullRequestComment(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, comment);
    }

    public List<GitHubPullRequest> getOpenPullRequests(PlatformRepositoryIdentifier repositoryIdentifier) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getOpenPullRequests(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), 100), ((IGitHubPullRequestApi)this.gitHubApi)::getOpenPullRequestsFromNextPage);
    }

    public GitHubPullRequest getPullRequest(PlatformRepositoryIdentifier repositoryIdentifier, int pullRequestNumber) throws ServiceCallException {
        return ((IGitHubPullRequestApi)this.gitHubApi).getPullRequest(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber);
    }

    public List<GitHubChangedFile> getPullRequestFiles(PlatformRepositoryIdentifier repositoryIdentifier, int pullRequestNumber) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getPullRequestFiles(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), pullRequestNumber, 100), ((IGitHubPullRequestApi)this.gitHubApi)::getPullRequestFilesFromNextPage);
    }

    public long createCheckRun(PlatformRepositoryIdentifier repositoryIdentifier, CheckRun checkRun) throws ServiceCallException {
        return ((IGitHubPullRequestApi)this.gitHubApi).createCheckRun(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), checkRun).id();
    }

    public Optional<CheckRun> getCheckRunById(PlatformRepositoryIdentifier repositoryIdentifier, long checkRunId) {
        try {
            return Optional.of(((IGitHubPullRequestApi)this.gitHubApi).getCheckRunById(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), checkRunId));
        }
        catch (ServiceCallException e) {
            this.logger.atWarn().withThrowable((Throwable)e).log("Failed to fetch check run for id '{}'. This might happen when a user force pushed on a branch.", (Object)checkRunId);
            return Optional.empty();
        }
    }

    public void updateCheckRun(PlatformRepositoryIdentifier repositoryIdentifier, long checkRunId, CheckRun checkRun) throws ServiceCallException {
        ((IGitHubPullRequestApi)this.gitHubApi).updateCheckRun(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), checkRunId, checkRun);
    }

    public boolean closeCheckRun(CheckRun checkRun, PlatformRepositoryIdentifier repositoryIdentifier, String reason, String explanation) {
        if (checkRun.status() == CheckRun.Status.COMPLETED) {
            return true;
        }
        try {
            this.logger.info("Setting check run '{}' at revision '{}' to 'skipped'.", (Object)checkRun.id(), (Object)checkRun.headSha());
            this.updateCheckRun(repositoryIdentifier, checkRun.id(), CheckRun.builder(checkRun).withOutputTitle(reason).withOutputText(explanation).withConclusion(CheckRun.Conclusion.SKIPPED).build());
            return true;
        }
        catch (ServiceCallException e) {
            this.logger.atError().withThrowable((Throwable)e).log("Failed to close outdated check run '{}'.", (Object)checkRun.id());
            return false;
        }
    }

    public List<CheckRun> getCheckRuns(PlatformRepositoryIdentifier repositoryIdentifier, String sha) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getCheckRunsForCommit(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sha, 100), ((IGitHubPullRequestApi)this.gitHubApi)::getCheckRunsForCommitFromNextPage, CheckRuns::getCheckRuns);
    }

    public List<CheckRun> getCheckRuns(PlatformRepositoryIdentifier repositoryIdentifier, String sha, String status) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getCheckRunsForCommit(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sha, status, 100), ((IGitHubPullRequestApi)this.gitHubApi)::getCheckRunsForCommitFromNextPage, CheckRuns::getCheckRuns);
    }

    public List<GitHubCommitStatus> getCommitStatuses(PlatformRepositoryIdentifier repositoryIdentifier, String sha) throws ServiceCallException {
        return HttpPaginationUtils.executeGetWithLinkHeaderPagination(() -> ((IGitHubPullRequestApi)this.gitHubApi).getCombinedCommitStatus(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), sha, 100), ((IGitHubPullRequestApi)this.gitHubApi)::getCombinedCommitStatusFromNextPage, CombinedCommitStatus::getCommitStatuses);
    }

    public boolean isUserCollaborator(PlatformRepositoryIdentifier repositoryIdentifier, String username) throws ServiceCallException {
        try {
            ((IGitHubPullRequestApi)this.gitHubApi).checkUserIsCollaborator(repositoryIdentifier.getOwner(), repositoryIdentifier.getRepo(), username);
            return true;
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public MetaInfo getMetaInfoForEnterpriseInstance() throws ServiceCallException {
        return ((IGitHubPullRequestApi)this.gitHubApi).getMetaInfoForEnterpriseInstance();
    }
}

