/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.mock_connector;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.index.merge_request.EMergeRequestStatus;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestBuildJob;
import com.teamscale.index.merge_request.MergeRequestBuildPipelineInfo;
import com.teamscale.index.merge_request.MergeRequestProvider;
import com.teamscale.index.repository.git.GitUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.net.UrlUtils;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ArtificialMergeRequestProvider
extends MergeRequestProvider<MergeRequest, MergeRequestBuildJob> {
    private final Repository repository;
    private final PairList<String, String> branchNamesForMergeRequests;
    private final String repositoryName;
    private static final Long CREATED_AT = Instant.parse("2002-02-02T02:02:02Z").toEpochMilli();

    public ArtificialMergeRequestProvider(String repositoryName, String repositoryUri, PairList<String, String> branchNamesForMergeRequests) throws URISyntaxException, RepositoryException, IOException {
        super(null, null);
        this.repositoryName = repositoryName;
        this.repository = GitUtils.getExistingLocalRepository(UrlUtils.parseUri((String)repositoryUri));
        this.branchNamesForMergeRequests = new PairList(branchNamesForMergeRequests);
    }

    private List<MergeRequest> createArtificialMergeRequests() throws IOException {
        ArrayList<MergeRequest> mergeRequests = new ArrayList<MergeRequest>();
        for (int i = 0; i < this.branchNamesForMergeRequests.size(); ++i) {
            this.createMergeRequestForListItem(i).ifPresent(mergeRequests::add);
        }
        return mergeRequests;
    }

    private Optional<MergeRequest> createMergeRequestForListItem(int i) {
        return this.createArtificialMergeRequest(i, ((String)this.branchNamesForMergeRequests.getFirst(i)).trim(), ((String)this.branchNamesForMergeRequests.getSecond(i)).trim());
    }

    @Override
    public @Nullable MergeRequest getPlatformMergeRequest(long id) throws ServiceCallException {
        if (id >= (long)this.branchNamesForMergeRequests.size()) {
            return null;
        }
        return this.createMergeRequestForListItem((int)id).orElse(null);
    }

    @Override
    protected List<MergeRequest> getAllOpenPlatformMergeRequests() throws ServiceCallException {
        try {
            return this.createArtificialMergeRequests();
        }
        catch (IOException e) {
            throw new ServiceCallException("Error creating artificial merge requests", (Throwable)e);
        }
    }

    private Optional<MergeRequest> createArtificialMergeRequest(long id, String sourceBranch, String targetBranch) {
        Ref branchRef;
        try {
            branchRef = this.repository.findRef(sourceBranch);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        if (branchRef == null) {
            return Optional.empty();
        }
        String sourceBranchName = GitRefUtils.getBranchNameFromRef((String)branchRef.getName()).orElse(null);
        if (sourceBranchName == null) {
            return Optional.empty();
        }
        MergeRequestIdentifier identifier = new MergeRequestIdentifier(this.repositoryName, id);
        return Optional.of(new MergeRequest(identifier, EMergeRequestStatus.OPEN, "Request to merge " + sourceBranchName + " into " + targetBranch, sourceBranchName, branchRef.getObjectId().getName(), targetBranch, "https://cqse.eu", CREATED_AT, CREATED_AT, new MergeRequestBuildPipelineInfo(false, (List<MergeRequestBuildJob>)CollectionUtils.emptyList())));
    }

    @Override
    protected MergeRequestProvider.IMergeRequestAdapter createMergeRequestAdapter(MergeRequest mergeRequest) {
        return new ArtificialMergeRequestAdapter(mergeRequest);
    }

    @Override
    protected boolean isCrossRepositoryMergeRequest(@NonNull MergeRequest mergeRequest) {
        return false;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    private record ArtificialMergeRequestAdapter(MergeRequest mergeRequest) implements MergeRequestProvider.IMergeRequestAdapter
    {
        @Override
        public MergeRequestIdentifier getIdentifier() {
            return this.mergeRequest.identifier;
        }

        @Override
        public EMergeRequestStatus getStatus() {
            return this.mergeRequest.status;
        }

        @Override
        public String getTitle() {
            return this.mergeRequest.title;
        }

        @Override
        public String getSourceBranch() {
            return this.mergeRequest.sourceBranch;
        }

        @Override
        public String getCommit() {
            return this.mergeRequest.sourceHead;
        }

        @Override
        public String getTargetBranch() {
            return this.mergeRequest.targetBranch;
        }

        @Override
        public String getUrl() {
            return this.mergeRequest.url;
        }

        @Override
        public Long getCreatedAt() {
            return this.mergeRequest.createdAt;
        }

        @Override
        public Long getUpdatedAt() {
            return this.mergeRequest.updatedAt;
        }
    }
}

