/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.sap.abapsystem.snc;

import com.teamscale.index.repository.sap.abapsystem.snc.ISapgenpseRunner;
import com.teamscale.index.repository.sap.abapsystem.snc.SapgenpseRunner;
import com.teamscale.index.repository.sap.abapsystem.snc.SncException;
import com.teamscale.index.repository.sap.abapsystem.snc.SncUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SncCredentialsManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CREDENTIALS_FILE_NAME = "cred_v2";
    private static SncCredentialsManager instance;
    private final ISapgenpseRunner sapgenpseRunner;
    private final String securityDirectory;
    private final Set<String> registeredPseFiles = new HashSet<String>();

    public static synchronized SncCredentialsManager getInstance(String sncServiceLibrary) throws SncException {
        if (instance == null) {
            instance = SncCredentialsManager.createInstance(sncServiceLibrary);
        }
        return instance;
    }

    private static synchronized SncCredentialsManager createInstance(String sncServiceLibrary) throws SncException {
        String securityDirectory = SncUtils.getSecurityDirectoryFromEnvVar();
        Optional<String> optValidation = SncUtils.validateSecurityDirectory(securityDirectory);
        if (optValidation.isPresent()) {
            throw new SncException(optValidation.get());
        }
        String sapgenpsePath = SncUtils.getSapgenpseExecutablePath(sncServiceLibrary);
        optValidation = SncUtils.validateSapgenpseExecutablePath(sapgenpsePath);
        if (optValidation.isPresent()) {
            throw new SncException(optValidation.get());
        }
        return new SncCredentialsManager(new SapgenpseRunner(securityDirectory, sapgenpsePath, SncUtils.getCredentialsUser()), securityDirectory);
    }

    @VisibleForTesting
    SncCredentialsManager(ISapgenpseRunner sapgenpseRunner, String securityDirectory) {
        this.sapgenpseRunner = sapgenpseRunner;
        this.securityDirectory = securityDirectory;
    }

    public void validatePseFiles() throws SncException {
        File pseFolder = new File(this.securityDirectory);
        List<String> sortedPseFiles = SncCredentialsManager.getSortedPseFiles(pseFolder);
        if (sortedPseFiles.isEmpty()) {
            throw new SncException("ABAP SNC: No Personal Security Environment (PSE) files found in " + pseFolder.getAbsolutePath());
        }
    }

    @VisibleForTesting
    static List<String> getSortedPseFiles(File securityDirectory) {
        String[] pseFiles = securityDirectory.list((dir, name) -> name.endsWith(".pse"));
        if (pseFiles == null) {
            return List.of();
        }
        List<String> files = Arrays.stream(pseFiles).sorted().toList();
        LOGGER.debug("ABAP SNC: PSE files inside security directory {} : {}", (Object)securityDirectory.getAbsolutePath(), files);
        return files;
    }

    public String createCredentials() {
        File securityDirFile = new File(this.securityDirectory);
        SncCredentialsManager.backupCredentialsFile(securityDirFile);
        ISapgenpseRunner.ExecutionResult executionResult = this.sapgenpseRunner.createCredentials(SncCredentialsManager.getSortedPseFiles(securityDirFile));
        return this.createResponse(SncCredentialsManager.getCredentialsFile(securityDirFile).getAbsolutePath(), executionResult);
    }

    private String createResponse(String credentialsFilePath, ISapgenpseRunner.ExecutionResult result) {
        if (result.returnCode() == 0) {
            this.registerAllAddedPseFiles(result.errorsAndWarnings());
            String successMessage = "ABAP SNC: credentials file " + credentialsFilePath + " has been (re)created. ";
            LOGGER.info(successMessage);
            successMessage = successMessage + "Detailed output from sapgenpse:\n\n" + result.errorsAndWarnings();
            return successMessage;
        }
        String errorMessage = String.format("ABAP SNC: sapgenpse could not update credentials file %s\nReturn code: %s\nOutput from sapgenpse: %s\nErrors & Warnings: %s\n", credentialsFilePath, result.returnCode(), result.output(), result.errorsAndWarnings());
        LOGGER.error(errorMessage);
        return errorMessage;
    }

    private void registerAllAddedPseFiles(String response) {
        String lineIndicatingPSEAdded = "Added SSO-credentials for PSE";
        this.registeredPseFiles.clear();
        for (String line : StringUtils.splitLines((String)response)) {
            int indexOfOpenDoubleQuote;
            if (!(line = line.trim()).startsWith(lineIndicatingPSEAdded) || (indexOfOpenDoubleQuote = line.indexOf(34)) == -1) continue;
            String restOfLine = line.substring(indexOfOpenDoubleQuote + 1);
            restOfLine = restOfLine.replace("\"", "").replace("\\", "/").trim();
            restOfLine = restOfLine.toLowerCase();
            this.registeredPseFiles.add(restOfLine);
        }
    }

    private static File getCredentialsFile(File securityDirectory) {
        return new File(securityDirectory, CREDENTIALS_FILE_NAME);
    }

    @VisibleForTesting
    static String getCredentialsBackupFileName() {
        return "cred_v2_backup";
    }

    @VisibleForTesting
    static void backupCredentialsFile(File securityDirectory) {
        File credentialsFile = SncCredentialsManager.getCredentialsFile(securityDirectory);
        if (!credentialsFile.exists()) {
            return;
        }
        try {
            File backupFile = new File(securityDirectory, SncCredentialsManager.getCredentialsBackupFileName());
            if (backupFile.exists()) {
                Files.delete(backupFile.toPath());
            }
            Files.move(credentialsFile.toPath(), backupFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("ABAP SNC: Could not backup credentials file {}. {}", (Object)credentialsFile.getAbsolutePath(), (Object)e);
        }
    }

    public String viewCredentials() {
        ISapgenpseRunner.ExecutionResult result = this.sapgenpseRunner.viewCredentials();
        return result.errorsAndWarnings() + "\n" + result.output();
    }

    @VisibleForTesting
    static Set<String> parseRegisteredPseFiles(String outputFromSapgenpse) {
        HashSet<String> pseFiles = new HashSet<String>();
        if (StringUtils.isEmpty((String)outputFromSapgenpse)) {
            return pseFiles;
        }
        for (String line : StringUtils.splitLines((String)outputFromSapgenpse)) {
            int indexOfRightParenthesis;
            if (!(line = line.trim()).startsWith("(LPS") || (indexOfRightParenthesis = line.indexOf(41)) == -1) continue;
            String path = line.substring(indexOfRightParenthesis + 3).trim();
            path = path.replace("\\", "/");
            path = path.toLowerCase();
            pseFiles.add(path);
        }
        return pseFiles;
    }

    public boolean isPseRegisteredInCredentials(String connectionId) {
        File pseFolder = new File(this.securityDirectory);
        Object expectedPath = pseFolder.getAbsolutePath().replace("\\", "/") + "/" + connectionId + ".pse";
        expectedPath = ((String)expectedPath).toLowerCase();
        if (this.registeredPseFiles.isEmpty()) {
            String output = this.viewCredentials();
            this.registeredPseFiles.addAll(SncCredentialsManager.parseRegisteredPseFiles(output));
        }
        return this.registeredPseFiles.contains(expectedPath);
    }

    public String addPseIntoCredentials(String pseFile) throws SncException {
        String pseFilePath = this.securityDirectory + File.separator + pseFile;
        Optional<String> optValidation = SncUtils.validateSomeFile(pseFilePath, "PSE file");
        if (optValidation.isPresent()) {
            throw new SncException(optValidation.get());
        }
        ISapgenpseRunner.ExecutionResult result = this.sapgenpseRunner.addPseIntoCredentials(pseFile);
        if (result.returnCode() == 0) {
            String output = this.viewCredentials();
            this.registeredPseFiles.clear();
            this.registeredPseFiles.addAll(SncCredentialsManager.parseRegisteredPseFiles(output));
        }
        return result.errorsAndWarnings() + "\n" + result.output();
    }

    public String removePseFromCredentials(String pseFile) {
        ISapgenpseRunner.ExecutionResult result = this.sapgenpseRunner.removePseFromCredentials(pseFile);
        if (result.returnCode() == 0) {
            String output = this.viewCredentials();
            this.registeredPseFiles.clear();
            this.registeredPseFiles.addAll(SncCredentialsManager.parseRegisteredPseFiles(output));
        }
        return result.errorsAndWarnings() + "\n" + result.output();
    }

    public static void createSNCCredentials() {
        if (!SncUtils.shouldCreateCredentialsAtStartup()) {
            return;
        }
        String serviceLibrary = SncUtils.getSncServiceLibraryFromEnvVar();
        if (!SncUtils.isSapCryptoSncOsLibrary(serviceLibrary)) {
            return;
        }
        Optional<String> optValidation = SncUtils.validateServiceLibrary(serviceLibrary);
        if (optValidation.isPresent()) {
            return;
        }
        try {
            SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance(serviceLibrary);
            sncCredentialsManager.validatePseFiles();
            sncCredentialsManager.createCredentials();
        }
        catch (SncException e) {
            LOGGER.debug(e.getMessage());
        }
    }
}

