/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.PartOfTestCodeDetail;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.engine.sourcecode.coverage.volume.CoverableLineUtils;
import org.conqat.engine.sourcecode.coverage.volume.CoverableStatementUtils;
import org.conqat.engine.sourcecode.coverage.volume.CoverableVolumeUtils;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.ctc.LineBasedCtcSkipPragmaFilter;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.lcov.GcovLcovExclusionFilter;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TokenElementLineInfoBuilder {
    public static TokenElementLineInfo build(TokenElementInfo tokenElementInfo) {
        List<ShallowEntity> entities = TokenElementLineInfoBuilder.getShallowEntitiesForLineCoverageCorrection(tokenElementInfo);
        Collection<ShallowEntity> coverableEntities = TokenElementLineInfoBuilder.getCoverableEntities(entities);
        LineOffsetConverter rawLineOffsetConverter = new LineOffsetConverter(tokenElementInfo.getText());
        Function<Integer, Integer> filteredToRawLineConverter = TokenElementLineInfoBuilder.getFilteredToRawLineConverter(tokenElementInfo, rawLineOffsetConverter);
        Set<Integer> rawCoverableLines = TokenElementLineInfoBuilder.getCoverableLines(tokenElementInfo, coverableEntities, filteredToRawLineConverter);
        List<Integer> excludedRawLines = TokenElementLineInfoBuilder.getExcludedRawLines(tokenElementInfo, entities, filteredToRawLineConverter);
        CollectionUtils.removeAll(rawCoverableLines, excludedRawLines);
        List<LineBasedRegion> multilineStatements = TokenElementLineInfoBuilder.getMultilineLeafStatements(coverableEntities, filteredToRawLineConverter);
        boolean isTestCode = tokenElementInfo.getFirstDetailOfType(PartOfTestCodeDetail.class).isPresent();
        return new TokenElementLineInfo(multilineStatements, rawLineOffsetConverter, rawCoverableLines, tokenElementInfo.getLanguage(), excludedRawLines, isTestCode);
    }

    private static @NonNull List<LineBasedRegion> getMultilineLeafStatements(Collection<ShallowEntity> coverableEntities, Function<Integer, Integer> filteredToRawLineConverter) {
        ArrayList<LineBasedRegion> multiLineRegions = new ArrayList<LineBasedRegion>();
        for (ShallowEntity entity : coverableEntities) {
            List ownStartTokens = CollectionUtils.filter((Collection)entity.ownStartTokens(), token -> !token.getType().isSynthetic());
            if (ownStartTokens.isEmpty()) continue;
            int startLine = ((IToken)ownStartTokens.get(0)).getLineNumber() + 1;
            IToken lastToken = Objects.requireNonNull((IToken)CollectionUtils.getLast((List)ownStartTokens));
            int endLine = lastToken.getLineNumber() + 1;
            if (lastToken.getType() == ETokenType.STRING_LITERAL) {
                String tokenText = lastToken.getText();
                endLine += StringUtils.countLines((String)tokenText);
            }
            if ((startLine = filteredToRawLineConverter.apply(startLine).intValue()) == (endLine = filteredToRawLineConverter.apply(endLine).intValue())) continue;
            multiLineRegions.add(new LineBasedRegion(startLine, endLine));
        }
        return multiLineRegions;
    }

    public static @Nullable List<ShallowEntity> getShallowEntitiesForLineCoverageCorrection(TokenElementInfo elementInfo) {
        if (CoverableVolumeUtils.useCoverableVolumeFilterForCpp((String)elementInfo.getUniformPath())) {
            try {
                return ShallowParserFactory.createParser((ELanguage)elementInfo.getLanguage()).parseTopLevel(elementInfo.getTokens());
            }
            catch (ShallowParserException e) {
                throw new AssertionError("Expecting " + String.valueOf(elementInfo.getLanguage()) + " parser to be present!", e);
            }
        }
        return elementInfo.getShallowEntitiesWithPreprocessorTokens();
    }

    private static @NonNull Collection<ShallowEntity> getCoverableEntities(@Nullable List<ShallowEntity> entities) {
        if (entities == null) {
            return Collections.emptyList();
        }
        List shallowEntities = ShallowEntityTraversalUtils.listAllEntities(entities);
        return CoverableStatementUtils.filterNonCoverableStatements((List)shallowEntities);
    }

    private static Set<Integer> getCoverableLines(TokenElementInfo elementInfo, Collection<ShallowEntity> coverableEntities, Function<Integer, Integer> filteredToRawLineConverter) {
        return CollectionUtils.mapToSet((Collection)CoverableLineUtils.determineLinesFromEntities((ELanguage)elementInfo.getLanguage(), coverableEntities), filteredToRawLineConverter);
    }

    private static Function<Integer, Integer> getFilteredToRawLineConverter(TokenElementInfo elementInfo, LineOffsetConverter rawLineOffsetConverter) {
        if (elementInfo.getFilterDeletions().isEmpty()) {
            return Function.identity();
        }
        LineOffsetConverter filteredLineOffsetConverter = new LineOffsetConverter(elementInfo.getFilteredText());
        StringOffsetTransformer deletionTransformer = new StringOffsetTransformer((List)elementInfo.getFilterDeletions());
        return line -> rawLineOffsetConverter.getLine(deletionTransformer.getUnfilteredOffset(filteredLineOffsetConverter.getOffset(line.intValue())));
    }

    private static @NonNull List<Integer> getExcludedRawLines(TokenElementInfo tokenElementInfo, List<ShallowEntity> entities, Function<Integer, Integer> filteredToRawLineConverter) {
        if (tokenElementInfo.getLanguage() == ELanguage.CPP || tokenElementInfo.getLanguage() == ELanguage.CPP_MS_CLI) {
            return TokenElementLineInfoBuilder.getCppExcludedRawLines(entities, tokenElementInfo.getTokens(), filteredToRawLineConverter);
        }
        return new ArrayList<Integer>();
    }

    private static @NonNull List<Integer> getCppExcludedRawLines(Collection<ShallowEntity> coverableEntities, List<IToken> tokens, Function<Integer, Integer> filteredToRawLineConverter) {
        LineBasedCtcSkipPragmaFilter coverableLinesCtcFilter = new LineBasedCtcSkipPragmaFilter();
        ShallowEntityTraversalUtils.selectEntities(coverableEntities, (Predicate)coverableLinesCtcFilter);
        HashSet excludedFilteredLines = CollectionUtils.unionSet((Collection)coverableLinesCtcFilter.getLinesInCtcSkip(), (Collection[])new Collection[]{GcovLcovExclusionFilter.computeExcludedLines(tokens, (boolean)false)});
        return CollectionUtils.map((Collection)excludedFilteredLines, filteredToRawLineConverter);
    }
}

