/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.retrieval_strategy;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

abstract class SchemaChangingRetrievalStrategyBase
implements IMetricRetrievalStrategy {
    private final IMetricRetrievalStrategy delegate;

    protected SchemaChangingRetrievalStrategyBase(IMetricRetrievalStrategy delegate) {
        this.delegate = delegate;
    }

    protected abstract MetricDirectorySchema updateSchema(MetricDirectorySchema var1);

    protected abstract UnaryOperator<Object[]> getMetricsUpdaterForSchema(MetricDirectorySchema var1);

    @Override
    public MetricDirectorySchema getMetricDirectorySchema(HistoryAccessOption historyAccess) throws StorageException {
        return this.updateSchema(this.delegate.getMetricDirectorySchema(historyAccess));
    }

    @Override
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        return this.updateSchema(this.delegate.getMetricDirectorySchema());
    }

    @Override
    public MetricDirectorySchemaEntry getMetricDirectorySchemaEntry(String metricName) throws StorageException {
        return this.getMetricDirectorySchema().getEntry(metricName);
    }

    @Override
    public MetricDirectoryEntry getMetricDirectoryEntry(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricDirectoryEntry metricDirectoryEntry = this.delegate.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (metricDirectoryEntry == null) {
            return null;
        }
        MetricDirectorySchema schema = this.delegate.getMetricDirectorySchema(historyAccessOption);
        return this.updateMetricDirectoryEntries(List.of(metricDirectoryEntry), schema).get(0);
    }

    @Override
    public List<MetricDirectoryEntry> getMetricDirectoryEntries(List<String> uniformPathPrefixes, HistoryAccessOption historyAccessOption) throws StorageException {
        List<MetricDirectoryEntry> entries = this.delegate.getMetricDirectoryEntries(uniformPathPrefixes, historyAccessOption);
        MetricDirectorySchema schema = this.delegate.getMetricDirectorySchema(historyAccessOption);
        return this.updateMetricDirectoryEntries(entries, schema);
    }

    private List<MetricDirectoryEntry> updateMetricDirectoryEntries(Collection<MetricDirectoryEntry> originalEntries, MetricDirectorySchema originalSchema) {
        UnaryOperator<Object[]> metricsUpdater = this.getMetricsUpdaterForSchema(originalSchema);
        return (List)originalEntries.stream().map(directoryEntry -> SchemaChangingRetrievalStrategyBase.updateMetrics(directoryEntry, metricsUpdater)).collect(CollectionUtils.toArrayList());
    }

    private static MetricDirectoryEntry updateMetrics(MetricDirectoryEntry originalEntry, UnaryOperator<Object[]> metricsUpdater) {
        MetricDirectoryEntry updatedEntry = new MetricDirectoryEntry(originalEntry.getUniformPath(), (Object[])metricsUpdater.apply(originalEntry.getValues()));
        originalEntry.getChildMetricsMap().forEach((uniformPath, values) -> updatedEntry.setChildMetrics(uniformPath, (Object[])metricsUpdater.apply((Object[])values)));
        return updatedEntry;
    }

    @Override
    public List<TrendIndexBase.TrendEntry<Object[]>> extractMetricHistory(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        List<TrendIndexBase.TrendEntry<Object[]>> trendEntries = this.delegate.extractMetricHistory(uniformPath, start, end);
        MetricDirectorySchema schema = this.delegate.getMetricDirectorySchema(HistoryAccessOption.readCommit((CommitDescriptor)end));
        return this.updateMetricTrendEntries(trendEntries, schema);
    }

    private List<TrendIndexBase.TrendEntry<Object[]>> updateMetricTrendEntries(Collection<TrendIndexBase.TrendEntry<Object[]>> trendEntries, MetricDirectorySchema schema) {
        UnaryOperator<Object[]> metricsUpdater = this.getMetricsUpdaterForSchema(schema);
        return (List)trendEntries.stream().map(trendEntry -> SchemaChangingRetrievalStrategyBase.updateMetrics((TrendIndexBase.TrendEntry<Object[]>)trendEntry, metricsUpdater)).collect(CollectionUtils.toArrayList());
    }

    private static TrendIndexBase.TrendEntry<Object[]> updateMetrics(TrendIndexBase.TrendEntry<Object[]> trendEntry, UnaryOperator<Object[]> metricsUpdater) {
        return new TrendIndexBase.TrendEntry(trendEntry.timestamp(), (Object)((Object[])metricsUpdater.apply((Object[])trendEntry.value())));
    }
}

