/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.analysis.naming_convention;

import eu.cqse.check.framework.core.CheckException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SubExpressionBasedNamingConventionAnalysisUtils {
    private static final String MARKDOWN_HIGHLIGHTING_TAG_BEGIN = "<mark>";
    private static final String MARKDOWN_HIGHLIGHTING_TAG_END = "</mark>";

    public static PairList<String, Pattern> compileRegexComponents(String regex, Map<String, String> subExpressions) {
        List regexComponents = StringUtils.splitTopLevel((String)regex, (char)'(', (char)'(', (char)')');
        PairList compiledComponents = new PairList();
        for (String regexComponent : regexComponents) {
            if (regexComponent.isEmpty()) continue;
            String expandedRegexComponent = SubExpressionBasedNamingConventionAnalysisUtils.injectSubExpressions(regexComponent, subExpressions);
            compiledComponents.add((Object)regexComponent, (Object)Pattern.compile("^" + expandedRegexComponent));
        }
        return compiledComponents;
    }

    public static String injectSubExpressions(String regex, Map<String, String> subExpressions) {
        for (Map.Entry<String, String> subExpression : subExpressions.entrySet()) {
            String newRegex = regex;
            while (!(newRegex = (regex = newRegex).replace(subExpression.getKey(), "(" + subExpression.getValue() + ")")).equals(regex)) {
            }
        }
        return regex;
    }

    public static PatternFindingMessage createFindingMessage(String name, int firstUnmatchedCharacterIndex, int firstUnmatchedRegexComponentIndex, PairList<String, Pattern> patternComponents, String patternName) {
        name = name.replace(" ", "\u2423");
        StringBuilder findingMessage = new StringBuilder();
        findingMessage.append(MarkupUtils.formatAsSourceCode((String)name));
        SubExpressionBasedNamingConventionAnalysisUtils.appendToStringBuilder(findingMessage, " violates naming conventions for '", patternName, "'. ");
        String partToCutOffForShortMessage = findingMessage.toString();
        findingMessage.append("Marked parts don't match: ");
        findingMessage.append(StringUtils.escapeMarkdownChars((String)name.substring(0, firstUnmatchedCharacterIndex)));
        if (firstUnmatchedCharacterIndex < name.length()) {
            findingMessage.append(MARKDOWN_HIGHLIGHTING_TAG_BEGIN);
            findingMessage.append(StringUtils.escapeMarkdownChars((String)name.substring(firstUnmatchedCharacterIndex)));
            findingMessage.append(MARKDOWN_HIGHLIGHTING_TAG_END);
        }
        findingMessage.append(" Regular Expression: ");
        patternComponents.extractFirstList().subList(0, firstUnmatchedRegexComponentIndex).forEach(regexComponent -> findingMessage.append(StringUtils.escapeMarkdownChars((String)regexComponent)));
        if (firstUnmatchedRegexComponentIndex < patternComponents.size()) {
            findingMessage.append(MARKDOWN_HIGHLIGHTING_TAG_BEGIN);
            patternComponents.extractFirstList().subList(firstUnmatchedRegexComponentIndex, patternComponents.size()).forEach(regexComponent -> findingMessage.append(StringUtils.escapeMarkdownChars((String)regexComponent)));
            findingMessage.append(MARKDOWN_HIGHLIGHTING_TAG_END);
        }
        return new PatternFindingMessage(findingMessage.toString(), StringUtils.stripPrefix((String)findingMessage.toString(), (String)partToCutOffForShortMessage).trim());
    }

    private static void appendToStringBuilder(StringBuilder stringBuilder, String ... strings) {
        Arrays.stream(strings).forEach(stringBuilder::append);
    }

    public static Map<String, String> parseSubExpressions(String subExpressionsParameter) throws ConQATException {
        HashMap<String, String> subExpressions = new HashMap<String, String>();
        for (String line : StringUtils.splitLines((String)subExpressionsParameter)) {
            if (line.trim().isEmpty() || line.startsWith("//")) continue;
            String[] lineComponents = line.split("=", 2);
            if (lineComponents.length != 2) {
                throw new ConQATException("Syntax error in sub expression " + line + ". Must have chars before and after a '='.");
            }
            subExpressions.put(lineComponents[0].trim(), lineComponents[1].trim());
        }
        return subExpressions;
    }

    public static SubjectNamePattern buildPattern(String patternName, String regex, Map<String, String> subExpressionMap) throws CheckException {
        CCSMAssert.isNotNull((Object)regex, () -> "No regex pattern for " + patternName + " was given.");
        try {
            return new SubjectNamePattern(patternName, Pattern.compile(SubExpressionBasedNamingConventionAnalysisUtils.injectSubExpressions(regex, subExpressionMap)), SubExpressionBasedNamingConventionAnalysisUtils.compileRegexComponents(regex, subExpressionMap));
        }
        catch (PatternSyntaxException e) {
            throw new CheckException("Error compiling pattern " + patternName, (Exception)e);
        }
    }

    public static Optional<PatternFindingMessage> checkName(String subjectName, SubjectNamePattern subjectNamePattern) {
        if (subjectNamePattern.compiledCompleteRegex.matcher(subjectName).matches()) {
            return Optional.empty();
        }
        PairList<String, Pattern> patternComponents = subjectNamePattern.compiledRegexComponents;
        int startIndex = 0;
        int lastMatchedComponentIndex = -1;
        int i = 0;
        while (i < patternComponents.size()) {
            Pattern pattern = (Pattern)patternComponents.getSecond(i);
            Matcher matcher = pattern.matcher(subjectName.substring(startIndex));
            if (!matcher.find()) {
                return Optional.of(SubExpressionBasedNamingConventionAnalysisUtils.createFindingMessage(subjectName, startIndex, i, patternComponents, subjectNamePattern.patternName));
            }
            startIndex += matcher.end();
            lastMatchedComponentIndex = i++;
        }
        if (startIndex < subjectName.length()) {
            return Optional.of(SubExpressionBasedNamingConventionAnalysisUtils.createFindingMessage(subjectName, startIndex, lastMatchedComponentIndex + 1, patternComponents, subjectNamePattern.patternName));
        }
        return Optional.empty();
    }

    private SubExpressionBasedNamingConventionAnalysisUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    public record PatternFindingMessage(String fullMessage, String patternPart) {
    }

    public static class SubjectNamePattern {
        public final String patternName;
        public final Pattern compiledCompleteRegex;
        public final PairList<String, Pattern> compiledRegexComponents;

        SubjectNamePattern(String patternName, Pattern compiledCompleteRegex, PairList<String, Pattern> compiledRegexComponents) {
            this.patternName = patternName;
            this.compiledCompleteRegex = compiledCompleteRegex;
            this.compiledRegexComponents = compiledRegexComponents;
        }
    }
}

