/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.signal_type.dimensions;

import com.google.common.collect.Multimap;
import com.teamscale.index.simulink.signal_type.SimulinkResolvedInformationUpdater;
import com.teamscale.index.simulink.signal_type.SimulinkTypeLink;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkMatrix;
import org.conqat.lib.simulink.model.SimulinkMatrixFactory;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;
import org.conqat.lib.simulink.model.SimulinkResolvedInformation;

class SimulinkDimensionUpdater
extends SimulinkResolvedInformationUpdater {
    public SimulinkDimensionUpdater(SimulinkResolvedDimensions resolvedDimensions, Multimap<SimulinkBlock, SimulinkTypeLink> typeLinks) {
        super((SimulinkResolvedInformation)resolvedDimensions, typeLinks);
    }

    void updateDimension(SimulinkBlock block, String index, SimulinkMatrix newDimension) {
        this.updateInformation(block, index, newDimension.toDimensionFormat());
    }

    void updateDimension(SimulinkBlock block, SimulinkMatrix newDimension) {
        this.updateInformation(block, newDimension.toDimensionFormat());
    }

    @Override
    protected boolean updateRequired(Set<String> currentDimensions, String newDimension) {
        if (newDimension == null) {
            return false;
        }
        List<SimulinkMatrix> currentDimensionsMatrix = currentDimensions.stream().map(SimulinkMatrixFactory::createMatrixFromDimensions).toList();
        HashSet<SimulinkMatrix> possibleDimensions = new HashSet<SimulinkMatrix>(currentDimensionsMatrix);
        SimulinkMatrix newDimensionMatrix = SimulinkMatrixFactory.createMatrixFromDimensions((String)newDimension);
        possibleDimensions.add(newDimensionMatrix);
        Optional<SimulinkMatrix> updatedDimension = SimulinkDimensionUtils.selectLargestMatrix(possibleDimensions);
        return updatedDimension.filter(simulinkMatrix -> currentDimensionsMatrix.stream().noneMatch(m -> SimulinkDimensionUtils.haveEqualDimension(m, newDimensionMatrix)) && SimulinkDimensionUtils.haveEqualDimension(newDimensionMatrix, simulinkMatrix)).isPresent();
    }
}

