/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.tracing;

import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.simulink.tracing.PlcCoderSimulinkCodeGenerationSourceFileMapper;
import com.teamscale.index.simulink.tracing.SimulinkCoderCodeGenerationSourceFileMapper;
import com.teamscale.index.simulink.tracing.SimulinkPlcCoderTraceIndex;
import com.teamscale.index.simulink.tracing.TracelinkAbbreviationIndex;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;

public class SimulinkSourceFileMapper {
    private static final String CODE_LINK_ELEMENT_REGEX = "[ A-Za-z0-9_-]+";
    public static final Pattern CODE_LINK_PATTERN = Pattern.compile("'((<[ A-Za-z0-9_-]+>|[ A-Za-z0-9_-]+)([/:][ A-Za-z0-9_-]+)+)'");
    private final List<TracingBeacon> beacons = new ArrayList<TracingBeacon>();

    public SimulinkSourceFileMapper(TokenElementInfo sourceElement, SimulinkModelInfoIndex modelInfoIndex, TracelinkAbbreviationIndex tracelinkAbbreviationIndex, SimulinkPlcCoderTraceIndex plcCoderTraceIndex, ElementLocation defaultSimulinkLocation) throws StorageException {
        if (defaultSimulinkLocation != null) {
            this.beacons.add(new TracingBeacon(0, Integer.MAX_VALUE, Collections.singletonList(defaultSimulinkLocation)));
        }
        if (sourceElement.getLanguage() == ELanguage.IEC61131) {
            this.beacons.addAll(PlcCoderSimulinkCodeGenerationSourceFileMapper.generateTracingBeaconsForPlcCoder(sourceElement, plcCoderTraceIndex));
        }
        if (sourceElement.getLanguage().isCppOrC()) {
            this.beacons.addAll(SimulinkCoderCodeGenerationSourceFileMapper.generateTracingBeacons(sourceElement, modelInfoIndex, tracelinkAbbreviationIndex, defaultSimulinkLocation));
        }
    }

    static boolean fileMayBeGeneratedFromSimulinkModel(TokenElementInfo element) {
        ELanguage language = element.getLanguage();
        return language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI || language == ELanguage.C || language == ELanguage.IEC61131;
    }

    public List<ElementLocation> resolveSimulinkLocationsForLine(int line) {
        if (this.beacons.isEmpty()) {
            return Collections.emptyList();
        }
        int index = Collections.binarySearch(this.beacons, new TracingBeacon(line, 0, null));
        if (index < 0) {
            index = -index - 1;
            index = Math.max(0, index - 1);
        }
        for (int i = index; i >= 0; --i) {
            if (!this.beacons.get(i).containsLine(line)) continue;
            return this.beacons.get((int)i).targetLocations;
        }
        return Collections.emptyList();
    }

    public List<String> getAllReferencedSimulinkUniformPaths() {
        return this.beacons.stream().map(beacon -> beacon.targetLocations).flatMap(Collection::stream).map(ElementLocation::getUniformPath).distinct().collect(Collectors.toList());
    }

    static class TracingBeacon
    implements Comparable<TracingBeacon> {
        private final int startLine;
        private final int endLine;
        private final List<ElementLocation> targetLocations;

        TracingBeacon(int startLine, int endLine, List<ElementLocation> targetLocations) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.targetLocations = targetLocations;
        }

        @Override
        public int compareTo(TracingBeacon other) {
            return Integer.compare(this.startLine, other.startLine);
        }

        private boolean containsLine(int line) {
            return this.startLine <= line && line <= this.endLine;
        }

        public List<ElementLocation> getTargetLocations() {
            return this.targetLocations;
        }
    }
}

