/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.tokenizer;

import com.teamscale.index.stacktrace.tokenizer.token.IStacktraceToken;
import com.teamscale.index.stacktrace.tokenizer.token.cs.CsEndOfExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.cs.CsExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.cs.CsStackFrameToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaCauseExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaInitialExceptionToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaMoreIdentifierToken;
import com.teamscale.index.stacktrace.tokenizer.token.java.JavaStackFrameToken;
import java.util.function.Function;
import java.util.regex.Matcher;

public enum EStacktraceTokenType {
    JAVA_INITIAL_EXCEPTION(JavaInitialExceptionToken.class, "(Exception in thread \\\"(?<threadName>[^\"]+)\\\" )?(?<exceptionName>[^\\s\\:]+)(\\: (?<exceptionMessage>.*))?", matcher -> {
        String threadName = matcher.group("threadName");
        String exceptionName = matcher.group("exceptionName");
        String exceptionMessage = matcher.group("exceptionMessage");
        return new JavaInitialExceptionToken(exceptionName, exceptionMessage, threadName);
    }),
    JAVA_CAUSE_EXCEPTION(JavaCauseExceptionToken.class, "Caused by\\: (?<exceptionName>[^\\s\\:]+)(\\: (?<exceptionMessage>.*))?", matcher -> {
        String exceptionName = matcher.group("exceptionName");
        String exceptionMessage = matcher.group("exceptionMessage");
        return new JavaCauseExceptionToken(exceptionName, exceptionMessage);
    }),
    JAVA_STACK_FRAME(JavaStackFrameToken.class, "at (?<className>.+)\\.(?<methodName>.+)\\(((?<fileName>.+\\..+)\\:(?<lineNumber>[1-9][0-9]*)|(?<unknownSource>.*))\\)", matcher -> {
        String className = matcher.group("className");
        String methodName = matcher.group("methodName");
        String fileName = matcher.group("fileName");
        Integer lineNumber = null;
        if (matcher.group("lineNumber") != null) {
            lineNumber = Integer.parseInt(matcher.group("lineNumber"));
        }
        return new JavaStackFrameToken(className, methodName, fileName, lineNumber);
    }),
    JAVA_MORE_IDENTIFIER(JavaMoreIdentifierToken.class, "\\.{3} (?<amount>[1-9][0-9]*) more", matcher -> {
        String amount = matcher.group("amount");
        return new JavaMoreIdentifierToken(amount);
    }),
    CS_EXCEPTION(CsExceptionToken.class, "(?<name>.+?)\\: (?<message>.+)", matcher -> {
        String exceptionName = matcher.group("name");
        String exceptionMessage = matcher.group("message");
        return new CsExceptionToken(exceptionName, exceptionMessage);
    }),
    CS_STACK_FRAME(CsStackFrameToken.class, "at (?<className>([^\\.]+\\.)*[^\\.]+)\\.\\.?(?<methodName>[^\\.]+)\\(.*\\) in (?<fileName>.+)\\:line (?<lineNumber>[1-9][0-9]*)", matcher -> {
        String className = matcher.group("className");
        String methodName = matcher.group("methodName");
        String fileName = matcher.group("fileName");
        Integer lineNumber = Integer.parseInt(matcher.group("lineNumber"));
        return new CsStackFrameToken(className, methodName, fileName, lineNumber);
    }),
    CS_END_OF_EXCEPTION(CsEndOfExceptionToken.class, "--- End of inner exception stack trace ---", matcher -> new CsEndOfExceptionToken());

    private final Class<? extends IStacktraceToken> tokenClass;
    private final String regularExpression;
    private final Function<Matcher, ? extends IStacktraceToken> tokenCreationFunction;

    public Function<Matcher, ? extends IStacktraceToken> getTokenCreationFunction() {
        return this.tokenCreationFunction;
    }

    private <T extends IStacktraceToken> EStacktraceTokenType(Class<T> tokenClass, String regularExpression, Function<Matcher, T> tokenCreationFunction) {
        this.tokenClass = tokenClass;
        this.regularExpression = regularExpression;
        this.tokenCreationFunction = tokenCreationFunction;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public Class<? extends IStacktraceToken> getTokenClass() {
        return this.tokenClass;
    }
}

