/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class CodeSnippet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOCATION_PROPERTY = "location";
    public static final String COMMIT_DESCRIPTOR_PROPERTY = "commit";
    public static final String FINDING_IDS_PROPERTY = "findingIds";
    public static final String TIME_CREATED_PROPERTY = "timeCreated";
    public static final String SHOULD_RENDER_FROM_FINDING_PROPERTY = "shouldRenderFromFinding";
    @JsonProperty(value="location")
    private final TextRegionLocation location;
    @JsonProperty(value="commit")
    private final CommitDescriptor commit;
    @JsonProperty(value="findingIds")
    private List<String> findingIds;
    @JsonProperty(value="timeCreated")
    private final long timeCreated;
    @JsonProperty(value="shouldRenderFromFinding")
    private final boolean renderFromFinding;

    @JsonCreator
    public CodeSnippet(@JsonProperty(value="location") TextRegionLocation location, @JsonProperty(value="commit") CommitDescriptor commit, @JsonProperty(value="findingIds") List<String> findingIds, @JsonProperty(value="timeCreated") long timeCreated, @JsonProperty(value="shouldRenderFromFinding") boolean renderFromFinding) {
        this.location = location;
        this.commit = commit;
        this.findingIds = new ArrayList<String>();
        if (findingIds != null) {
            this.findingIds = findingIds;
        }
        this.timeCreated = timeCreated;
        this.renderFromFinding = renderFromFinding;
    }

    public TextRegionLocation getLocation() {
        return this.location;
    }

    public CommitDescriptor getCommit() {
        return this.commit;
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public boolean shouldRenderFromFinding() {
        return this.renderFromFinding;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.commit, this.findingIds, this.timeCreated, this.renderFromFinding);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeSnippet otherCodeSnippet = (CodeSnippet)o;
        return Objects.equals(this.location, otherCodeSnippet.getLocation()) && Objects.equals(this.commit, otherCodeSnippet.getCommit()) && Objects.equals(this.findingIds, otherCodeSnippet.getFindingIds()) && Objects.equals(this.timeCreated, otherCodeSnippet.getTimeCreated()) && Objects.equals(this.renderFromFinding, otherCodeSnippet.shouldRenderFromFinding());
    }
}

