/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.IDeltaTranslatingIndex;
import com.teamscale.core.analysis.IndexDelta;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoContainer;
import com.teamscale.index.testgap.MethodLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.UniformPathSerializer;
import org.conqat.engine.persistence.index.UniformPathToValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Index(name="tga-method-info", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={MethodInfoContainer.class})
public class MethodInfoIndex
implements IProjectIndex,
IDeltaTranslatingIndex<IndexDelta<UniformPath>> {
    public static final String INDEX_NAME = "tga-method-info";
    private final UniformPathToValueIndex<byte[]> crossAnnotationInfoIndex;
    private final UniformPathToValueIndex<byte[]> methodInfoContainer;

    public MethodInfoIndex(IStore store) {
        this.crossAnnotationInfoIndex = UniformPathToValueIndex.of((IStore)new DelegatingPartitionStore(store, "#ca#"), (UniformPathSerializer)UniformPathSerializer.defaultSerializer((boolean)false), (ISerializer)ISerializer.identity());
        this.methodInfoContainer = UniformPathToValueIndex.of((IStore)new DelegatingPartitionStore(store, "#mc#"), (UniformPathSerializer)UniformPathSerializer.defaultSerializer((boolean)false), (ISerializer)ISerializer.identity());
    }

    public MethodInfo getMethodInfoWithCrossAnnotationInfo(UniformPath uniformPath, OffsetBasedRegion region) throws StorageException {
        MethodInfoContainer container = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (container == null) {
            return null;
        }
        return container.getMethodInfo(region);
    }

    private MethodInfoContainer readContainerWithoutCrossAnnotationInfo(UniformPath uniformPath) throws StorageException {
        return this.methodInfoContainer.getValue(uniformPath).map(MethodInfoContainer::deserializeWithoutCrossAnnotations).orElse(null);
    }

    private @Nullable MethodInfoContainer readContainerWithCrossAnnotationInfo(UniformPath uniformPath) throws StorageException {
        MethodInfoContainer baseContainer = this.readContainerWithoutCrossAnnotationInfo(uniformPath);
        if (baseContainer == null) {
            return null;
        }
        byte[] crossAnnotationData = (byte[])this.crossAnnotationInfoIndex.getValue(uniformPath).orElseThrow(() -> new IllegalStateException("Did not store cross annotation data for %s".formatted(uniformPath)));
        baseContainer.deserializeAndAddCrossAnnotationInfo(crossAnnotationData);
        return baseContainer;
    }

    public AssociatedMethodInfo getAssociatedMethodInfoWithCrossAnnotationInfoLoaded(UniformPath uniformPath, OffsetBasedRegion region) throws StorageException {
        MethodInfo methodInfo = this.getMethodInfoWithCrossAnnotationInfo(uniformPath, region);
        if (methodInfo == null) {
            return null;
        }
        return new AssociatedMethodInfo(uniformPath, region, methodInfo);
    }

    public Map<MethodLocation, MethodInfo> getMethodInfoMapForExactPaths(PairList<UniformPath, OffsetBasedRegion> uniformPathsAndRegions) throws StorageException {
        HashMap<MethodLocation, MethodInfo> methodInfos = new HashMap<MethodLocation, MethodInfo>();
        List allUniformPaths = uniformPathsAndRegions.extractFirstList();
        List<UniformPath> distinctUniformPaths = allUniformPaths.stream().distinct().collect(Collectors.toList());
        List<MethodInfoContainer> values = this.getMethodContainersWithCrossAnnotationInfo(distinctUniformPaths);
        Map methodInfoContainers = CollectionUtils.zipAsMap(distinctUniformPaths, values);
        for (int i = 0; i < allUniformPaths.size(); ++i) {
            MethodInfoContainer methodInfoContainer = (MethodInfoContainer)methodInfoContainers.get(allUniformPaths.get(i));
            if (methodInfoContainer == null) continue;
            UniformPath uniformPath = (UniformPath)uniformPathsAndRegions.getFirst(i);
            OffsetBasedRegion region = (OffsetBasedRegion)uniformPathsAndRegions.getSecond(i);
            MethodLocation methodLocation = new MethodLocation(uniformPath, region);
            methodInfos.put(methodLocation, methodInfoContainer.getMethodInfo(region));
        }
        return methodInfos;
    }

    private List<MethodInfoContainer> getMethodContainersWithCrossAnnotationInfo(List<UniformPath> distinctUniformPaths) throws StorageException {
        List<MethodInfoContainer> methodInfoContainers = this.methodInfoContainer.getValues(distinctUniformPaths).stream().map(MethodInfoContainer::deserializeWithoutCrossAnnotations).toList();
        this.loadCrossAnnotationInfoIntoMethodContainers(distinctUniformPaths, methodInfoContainers);
        return methodInfoContainers;
    }

    private void loadCrossAnnotationInfoIntoMethodContainers(List<UniformPath> distinctUniformPaths, List<MethodInfoContainer> methodInfoContainers) throws StorageException {
        List annotationInfos = this.crossAnnotationInfoIndex.getValues(distinctUniformPaths);
        for (int i = 0; i < distinctUniformPaths.size(); ++i) {
            if (methodInfoContainers.get(i) == null) continue;
            methodInfoContainers.get(i).deserializeAndAddCrossAnnotationInfo((byte[])annotationInfos.get(i));
        }
    }

    public List<MethodInfoContainer> getMethodContainersWithoutCrossAnnotationInfo(List<UniformPath> uniformPaths) throws StorageException {
        return CollectionUtils.mapWithException((Collection)this.methodInfoContainer.getValues(uniformPaths), MethodInfoContainer::deserializeWithoutCrossAnnotations);
    }

    public Map<UniformPath, MethodInfoContainer> getMethodContainersWithoutCrossAnnotationInfoByUniformPath(List<UniformPath> uniformPaths) throws StorageException {
        uniformPaths = new ArrayList<UniformPath>(new HashSet<UniformPath>(uniformPaths));
        List<MethodInfoContainer> values = this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        HashMap<UniformPath, MethodInfoContainer> result = HashMap.newHashMap(uniformPaths.size());
        for (int i = 0; i < uniformPaths.size(); ++i) {
            result.put(uniformPaths.get(i), values.get(i));
        }
        return result;
    }

    public List<AssociatedMethodInfo> getMethodInfosForPathPrefix(UniformPath uniformPathPrefix) throws StorageException {
        PairList<UniformPath, MethodInfoContainer> entriesStartingWith = this.getMethodInfoContainerEntriesWithUniformPathPrefix(uniformPathPrefix);
        this.loadCrossAnnotationInfoIntoMethodContainers((List<UniformPath>)entriesStartingWith.getFirstList(), (List<MethodInfoContainer>)entriesStartingWith.getSecondList());
        return MethodInfoIndex.convertToAssociatedMethodInfos(entriesStartingWith);
    }

    private PairList<UniformPath, MethodInfoContainer> getMethodInfoContainerEntriesWithUniformPathPrefix(UniformPath uniformPathPrefix) throws StorageException {
        Map entries = this.methodInfoContainer.getEntriesStartingWith(uniformPathPrefix);
        PairList results = new PairList();
        for (Map.Entry entry : entries.entrySet()) {
            results.add((Object)((UniformPath)entry.getKey()), (Object)MethodInfoContainer.deserializeWithoutCrossAnnotations((byte[])entry.getValue()));
        }
        results.sort(Comparator.comparing(ImmutablePair::getFirst));
        return results;
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPaths(List<UniformPath> uniformPaths, boolean includeCrossAnnotationInformation) throws StorageException {
        if (includeCrossAnnotationInformation) {
            return this.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(uniformPaths);
        }
        return this.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(uniformPaths);
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(List<UniformPath> uniformPaths) throws StorageException {
        List<MethodInfoContainer> values = this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        return MethodInfoIndex.convertToAssociatedMethodInfos((PairList<UniformPath, MethodInfoContainer>)PairList.zip(uniformPaths, values));
    }

    public List<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(List<UniformPath> uniformPaths) throws StorageException {
        List<MethodInfoContainer> values = this.getMethodContainersWithCrossAnnotationInfo(uniformPaths);
        return MethodInfoIndex.convertToAssociatedMethodInfos((PairList<UniformPath, MethodInfoContainer>)PairList.zip(uniformPaths, values));
    }

    public Set<AssociatedMethodInfo> getAssociatedMethodInfosForExactPathsAndRegions(Collection<MethodLocation> methodLocations, boolean includeCrossAnnotationInformation) throws StorageException {
        Map<UniformPath, List<MethodLocation>> methodLocationsByUniformPath = methodLocations.stream().collect(Collectors.groupingBy(MethodLocation::getUniformPath));
        ArrayList<UniformPath> uniformPaths = new ArrayList<UniformPath>(methodLocationsByUniformPath.keySet());
        List<MethodInfoContainer> values = includeCrossAnnotationInformation ? this.getMethodContainersWithCrossAnnotationInfo(uniformPaths) : this.getMethodContainersWithoutCrossAnnotationInfo(uniformPaths);
        HashSet<AssociatedMethodInfo> associatedMethodInfos = new HashSet<AssociatedMethodInfo>();
        for (int i = 0; i < values.size(); ++i) {
            UniformPath uniformPath = (UniformPath)uniformPaths.get(i);
            MethodInfoContainer container = values.get(i);
            if (container == null) continue;
            for (MethodLocation methodLocation : methodLocationsByUniformPath.get(uniformPath)) {
                OffsetBasedRegion region = methodLocation.getRegion();
                MethodInfo methodInfo = container.getMethodInfo(region);
                if (methodInfo == null) {
                    throw new StorageException("No method with region " + String.valueOf(region) + " found for " + String.valueOf(uniformPath) + ". This can happen when the project is in analysis, and the retrieved data is inconsistent. The error should disappear when the analysis is finished for the selected branch.");
                }
                associatedMethodInfos.add(new AssociatedMethodInfo(uniformPath, region, methodInfo));
            }
        }
        return associatedMethodInfos;
    }

    @TestOnly
    public void setMethodInfo(UniformPath uniformPath, OffsetBasedRegion region, MethodInfo methodInfo) throws StorageException {
        MethodInfoContainer container = new MethodInfoContainer(region, methodInfo);
        this.setOrMergeMethodInfoContainer(uniformPath, container);
    }

    private void setOrMergeMethodInfoContainer(UniformPath uniformPath, MethodInfoContainer newValue) throws StorageException {
        MethodInfoContainer oldValue = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (oldValue != null) {
            newValue = MethodInfoContainer.merge(oldValue, newValue);
        }
        this.setMethodContainer(uniformPath, newValue);
    }

    @TestOnly
    public void removeMethodInfos(UniformPath uniformPath, Collection<OffsetBasedRegion> regions) throws StorageException {
        MethodInfoContainer container = this.readContainerWithCrossAnnotationInfo(uniformPath);
        if (container != null) {
            regions.forEach(container::removeMethodInfo);
            if (container.isEmpty()) {
                this.removeValues(Collections.singletonList(uniformPath));
            } else {
                this.setMethodContainer(uniformPath, container);
            }
        }
    }

    public void setMethodContainer(UniformPath uniformPath, MethodInfoContainer container) throws StorageException {
        this.setMethodContainers((PairList<UniformPath, MethodInfoContainer>)PairList.from((Object)uniformPath, (Object)container));
    }

    public void setMethodContainers(PairList<UniformPath, MethodInfoContainer> methodContainersByUniformPath) throws StorageException {
        PairList methodInfos = new PairList(methodContainersByUniformPath.size());
        PairList crossAnnotations = new PairList(methodContainersByUniformPath.size());
        for (Pair entry : methodContainersByUniformPath) {
            methodInfos.add((Object)((UniformPath)entry.getFirst()), (Object)((MethodInfoContainer)entry.getSecond()).serializeWithoutCrossAnnotations());
            crossAnnotations.add((Object)((UniformPath)entry.getFirst()), (Object)((MethodInfoContainer)entry.getSecond()).serializeCrossAnnotationInfo());
        }
        this.methodInfoContainer.setValues(methodInfos);
        this.crossAnnotationInfoIndex.setValues(crossAnnotations);
    }

    private static List<AssociatedMethodInfo> convertToAssociatedMethodInfos(PairList<UniformPath, MethodInfoContainer> containers) {
        ArrayList<AssociatedMethodInfo> associatedMethodInfos = new ArrayList<AssociatedMethodInfo>();
        for (Pair container : containers) {
            if (container.getSecond() == null) continue;
            for (Map.Entry<OffsetBasedRegion, MethodInfo> entry : ((MethodInfoContainer)container.getSecond()).entrySet()) {
                associatedMethodInfos.add(new AssociatedMethodInfo((UniformPath)container.getFirst(), entry.getKey(), entry.getValue()));
            }
        }
        return associatedMethodInfos;
    }

    public PairList<UniformPath, MethodInfoContainer> getAllEntries() throws StorageException {
        PairList<UniformPath, MethodInfoContainer> entries = this.getMethodInfoContainerEntriesWithUniformPathPrefix(UniformPath.codeRoot());
        this.loadCrossAnnotationInfoIntoMethodContainers(entries.extractFirstList(), (List<MethodInfoContainer>)entries.getSecondList());
        return entries;
    }

    public void removeValues(Collection<UniformPath> uniformPaths) throws StorageException {
        this.methodInfoContainer.removeValues(uniformPaths);
        this.crossAnnotationInfoIndex.removeValues(uniformPaths);
    }

    public Set<UniformPath> getAllMethodInfoContainerKeys() throws StorageException {
        return this.methodInfoContainer.getAllKeys();
    }

    public @NonNull IndexDelta<UniformPath> resolveDelta(@NonNull KeyDelta storeDelta) throws StorageException {
        Set<UniformPath> addedOrChanged = this.resolveKeys((Collection<StorageKey>)storeDelta.getAddedOrChangedKeys());
        Set<UniformPath> deleted = this.resolveKeys((Collection<StorageKey>)storeDelta.getDeletedKeys());
        deleted.removeAll(addedOrChanged);
        return new IndexDelta(addedOrChanged, deleted);
    }

    private Set<UniformPath> resolveKeys(Collection<StorageKey> keys) throws StorageException {
        HashSet<UniformPath> resolvedKeys = new HashSet<UniformPath>();
        for (StorageKey addedOrChangedKey : keys) {
            DelegatingPartitionStore store;
            DelegatingPartitionStore store2;
            byte[] bytes = addedOrChangedKey.getKey();
            IStore iStore = this.methodInfoContainer.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (store2 = (DelegatingPartitionStore)iStore).isFromThisPartition(bytes)) {
                resolvedKeys.add((UniformPath)this.methodInfoContainer.getKeySerializer().deserialize((Object)store2.getOriginalKey(bytes)));
                continue;
            }
            iStore = this.crossAnnotationInfoIndex.getWrappedStore(DelegatingPartitionStore.class);
            if (iStore instanceof DelegatingPartitionStore && (store = (DelegatingPartitionStore)iStore).isFromThisPartition(bytes)) {
                resolvedKeys.add((UniformPath)this.crossAnnotationInfoIndex.getKeySerializer().deserialize((Object)store.getOriginalKey(bytes)));
                continue;
            }
            throw new IllegalStateException("Received unexpected key: " + String.valueOf(addedOrChangedKey));
        }
        return resolvedKeys;
    }
}

