/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.user;

import com.teamscale.core.utils.TimestampedInteraction;
import com.teamscale.index.user.UserRecentInteractionIndex;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="user-recently-viewed-projects", options={EStorageOption.BACKUP}, valueClasses={TimestampedInteraction.class})
public class UserRecentlyViewedProjectsIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "user-recently-viewed-projects";
    private final UserRecentInteractionIndex<String> delegate;

    public UserRecentlyViewedProjectsIndex(IStore store) {
        this.delegate = new UserRecentInteractionIndex(store);
    }

    public void registerProjectViewed(String userName, PublicProjectId projectId) throws StorageException {
        this.delegate.registerItemInteraction(userName, projectId.toString());
    }

    public List<PublicProjectId> getRecentProjectIds(String userName) throws StorageException {
        return PublicProjectId.of(this.delegate.getRecentItems(userName));
    }
}

