/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.utils;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CollectionValidationUtils {
    public static <T, R> Collection<R> validateAndMap(Collection<T> items, FunctionWithException<T, R, Exception> validatingMapper) throws ConnectorValidationException {
        ArrayList validMappedItems = new ArrayList();
        PairList itemsWithErrors = new PairList();
        items.forEach(item -> {
            Optional<Object> exception = Optional.empty();
            try {
                Object result = validatingMapper.apply(item);
                validMappedItems.add(result);
            }
            catch (Exception e2) {
                exception = Optional.of(e2);
            }
            exception.map(e -> Pair.createPair((Object)item, (Object)e)).ifPresent(arg_0 -> ((PairList)itemsWithErrors).add(arg_0));
        });
        if (!itemsWithErrors.isEmpty()) {
            CollectionValidationUtils.throwAggregatedError(itemsWithErrors);
        }
        return validMappedItems;
    }

    public static <T> void validateCollection(Collection<T> items, ConsumerWithException<T, Exception> validator) throws ConnectorValidationException {
        CollectionValidationUtils.validateAndMap(items, item -> {
            validator.accept(item);
            return null;
        });
    }

    private static <T> void throwAggregatedError(PairList<T, Exception> invalidPatternsWithErrors) throws ConnectorValidationException {
        String joinedErrors = String.join((CharSequence)"\n", invalidPatternsWithErrors.map((item, error) -> "Invalid configuration item '%s': %s".formatted(item, error.getMessage())));
        ConnectorValidationException aggregatedException = new ConnectorValidationException("Invalid entries in configuration: \n" + joinedErrors);
        invalidPatternsWithErrors.extractSecondList().forEach(aggregatedException::addSuppressed);
        throw aggregatedException;
    }

    private CollectionValidationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

