/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AssessmentUtils {
    public static final ETrafficLightColor[][] ASSESSMENT_SORT_ORDER = new ETrafficLightColor[][]{{ETrafficLightColor.RED, ETrafficLightColor.ORANGE, ETrafficLightColor.YELLOW, ETrafficLightColor.BASELINE, ETrafficLightColor.UNKNOWN}};

    public static int compareAssessments(Assessment o1, Assessment o2) {
        double red1 = (double)o1.getColorFrequency(ETrafficLightColor.RED) / (double)o1.getSize();
        double red2 = (double)o2.getColorFrequency(ETrafficLightColor.RED) / (double)o2.getSize();
        double yellow1 = (double)o1.getColorFrequency(ETrafficLightColor.YELLOW) / (double)o1.getSize();
        double yellow2 = (double)o2.getColorFrequency(ETrafficLightColor.YELLOW) / (double)o2.getSize();
        double yFactor = 0.4;
        return Double.compare(red1 + yFactor * yellow1, red2 + yFactor * yellow2);
    }

    private AssessmentUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

