/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;

public enum ByteUnit {
    BYTES("B"),
    KIBIBYTES("KiB"),
    MEBIBYTES("MiB"),
    GIBIBYTES("GiB"),
    TEBIBYTES("TiB"),
    PEBIBYTES("PiB"),
    EXBIBYTES("EiB");

    private static final Map<String, ByteUnit> UNIT_FOR_ABBREVIATION;
    private static final Pattern VALUE_WITH_ABBREVIATION;
    private final String abbreviation;

    private ByteUnit(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String toString() {
        return this.abbreviation;
    }

    public long toBytes(long size) {
        return BYTES.convert(size, this);
    }

    public double toBytes(double size) {
        return BYTES.convert(size, this);
    }

    public long toKibiBytes(long size) {
        return KIBIBYTES.convert(size, this);
    }

    public double toKibiBytes(double size) {
        return KIBIBYTES.convert(size, this);
    }

    public long toMebiBytes(long size) {
        return MEBIBYTES.convert(size, this);
    }

    public double toMebiBytes(double size) {
        return MEBIBYTES.convert(size, this);
    }

    public long toGibiBytes(long size) {
        return GIBIBYTES.convert(size, this);
    }

    public double toGibiBytes(double size) {
        return GIBIBYTES.convert(size, this);
    }

    public long toTebiBytes(long size) {
        return TEBIBYTES.convert(size, this);
    }

    public double toTebiBytes(double size) {
        return TEBIBYTES.convert(size, this);
    }

    public long convert(long sourceSize, ByteUnit sourceUnit) {
        return ByteUnit.convert(sourceSize, sourceUnit, this);
    }

    public double convert(double sourceSize, ByteUnit sourceUnit) {
        return ByteUnit.convert(sourceSize, sourceUnit, this);
    }

    public long getMultiplier(ByteUnit targetUnit) {
        return ByteUnit.getMultiplier(this, targetUnit);
    }

    public static long getMultiplier(ByteUnit sourceUnit, ByteUnit targetUnit) {
        int scaleDifference = sourceUnit.ordinal() - targetUnit.ordinal();
        if (scaleDifference < 0) {
            throw new IllegalArgumentException(String.format("Cannot compute multiplier from %s to %s", sourceUnit.name(), targetUnit.name()));
        }
        return ByteUnit.computeScale(scaleDifference);
    }

    private static long convert(long size, ByteUnit sourceUnit, ByteUnit targetUnit) {
        if (sourceUnit == targetUnit || size == 0L) {
            return size;
        }
        long result = size;
        int scaleDifference = sourceUnit.ordinal() - targetUnit.ordinal();
        result = scaleDifference > 0 ? ByteUnit.boundedMultiply(result, ByteUnit.computeScale(scaleDifference)) : (result /= ByteUnit.computeScale(scaleDifference * -1));
        return result;
    }

    private static double convert(double size, ByteUnit sourceUnit, ByteUnit targetUnit) {
        if (sourceUnit == targetUnit || size == 0.0 || !Double.isFinite(size)) {
            return size;
        }
        double result = size;
        int scaleDifference = sourceUnit.ordinal() - targetUnit.ordinal();
        result = scaleDifference > 0 ? (result *= (double)ByteUnit.computeScale(scaleDifference)) : (result /= (double)ByteUnit.computeScale(scaleDifference * -1));
        return result;
    }

    private static long computeScale(int steps) {
        if (steps > 6) {
            throw new ArithmeticException("Unable to compute conversions larger than the size of long");
        }
        return 1L << 10 * steps;
    }

    private static long boundedMultiply(long x, long y) {
        long ay;
        long r = x * y;
        long ax = Math.abs(x);
        if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
            return ByteUnit.getOverflowValue(x, y);
        }
        return r;
    }

    private static long getOverflowValue(long x, long y) {
        if (x < 0L ^ y < 0L) {
            return Long.MIN_VALUE;
        }
        return Long.MAX_VALUE;
    }

    public static ByteUnit fromAbbreviation(String abbreviation) {
        ByteUnit unit = UNIT_FOR_ABBREVIATION.get(abbreviation);
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Unknown abbreviation: %s", abbreviation));
        }
        return unit;
    }

    public static Pair<Long, ByteUnit> parseUnitMeasurement(String value) {
        Matcher matcher = VALUE_WITH_ABBREVIATION.matcher(value);
        if (matcher.matches()) {
            long amount = Long.parseLong(matcher.group(1));
            ByteUnit unit = ByteUnit.fromAbbreviation(matcher.group(2));
            return new Pair<Long, ByteUnit>(amount, unit);
        }
        throw new IllegalArgumentException(String.format("Provided argument does not match the expected pattern: %s", VALUE_WITH_ABBREVIATION));
    }

    public static long parseUnitMeasurementAs(String value, ByteUnit targetUnit) {
        Pair<Long, ByteUnit> valueAndUnit = ByteUnit.parseUnitMeasurement(value);
        return targetUnit.convert((Long)valueAndUnit.getFirst(), (ByteUnit)((Object)valueAndUnit.getSecond()));
    }

    static {
        UNIT_FOR_ABBREVIATION = Collections.unmodifiableMap(Arrays.stream(ByteUnit.values()).collect(Collectors.toMap(ByteUnit::getAbbreviation, Function.identity())));
        VALUE_WITH_ABBREVIATION = Pattern.compile("^(\\d+)\\s*" + Arrays.stream(ByteUnit.values()).map(ByteUnit::getAbbreviation).collect(Collectors.joining("|", "(", ")")) + "$");
    }
}

