/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.html;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.conqat.lib.commons.html.EHTMLAttribute;
import org.conqat.lib.commons.html.EHTMLElement;
import org.conqat.lib.commons.html.HTMLWriterException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.xml.IXMLResolver;
import org.conqat.lib.commons.xml.XMLWriter;

public class HTMLWriter
extends XMLWriter<EHTMLElement, EHTMLAttribute> {
    public HTMLWriter(File file) throws IOException {
        this(new PrintStream(file, StandardCharsets.UTF_8));
    }

    public HTMLWriter(OutputStream stream) {
        super(new PrintWriter(HTMLWriter.wrapStream(stream)), new HTMLResolver());
    }

    private static OutputStreamWriter wrapStream(OutputStream stream) {
        return new OutputStreamWriter(stream, StandardCharsets.UTF_8);
    }

    public HTMLWriter(PrintWriter writer) {
        super(writer, new HTMLResolver());
    }

    public void addStdHeader(Charset encoding) {
        this.addHeader("1.0", encoding);
        this.addPublicDocTypeDefinition(EHTMLElement.HTML, "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
    }

    public void addStdHeader() {
        this.addStdHeader(StandardCharsets.UTF_8);
    }

    @Override
    public void addRawString(String html) {
        super.addRawString(html);
    }

    public void addRawNewLine() {
        this.addRawString(StringUtils.LINE_SEPARATOR);
    }

    public void addExternalJavaScript(String scriptFilePath) {
        this.insertEmptyElement(EHTMLElement.SCRIPT, new Object[]{EHTMLAttribute.SRC, scriptFilePath, EHTMLAttribute.TYPE, "text/javascript"});
    }

    public void insertEmptyElement(EHTMLElement element, Object ... attributes) {
        this.openElement(element, attributes);
        this.addText("");
        this.closeElement(element);
    }

    @Override
    public void addAttribute(EHTMLAttribute attribute, Object value) {
        if (!((EHTMLElement)((Object)this.getCurrentElement())).allowsAttribute(attribute)) {
            throw new HTMLWriterException("Attribute " + String.valueOf((Object)attribute) + " not allowed for element " + String.valueOf(this.getCurrentElement()));
        }
        super.addAttribute(attribute, value);
    }

    public static class HTMLResolver
    implements IXMLResolver<EHTMLElement, EHTMLAttribute> {
        @Override
        public String resolveAttributeName(EHTMLAttribute attribute) {
            return attribute.toString();
        }

        @Override
        public String resolveElementName(EHTMLElement element) {
            return element.toString();
        }

        @Override
        public Class<EHTMLAttribute> getAttributeClass() {
            return EHTMLAttribute.class;
        }
    }
}

