/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.classes;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedArrayField;
import org.conqat.lib.commons.serialization.classes.SerializedClassBase;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.classes.SerializedPrimitiveFieldBase;

public class SerializedClass
extends SerializedClassBase {
    private static final byte ENUM_CLASS_DESCRIPTION_FLAGS = 18;
    private static final byte CLASS_DESCRIPTION_FLAGS = 2;
    private String name;
    private long serialVersionUid;
    private byte classDescriptionFlags;
    private List<SerializedFieldBase> fields;

    public SerializedClass(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser) throws IOException {
        super(din, pool, parser);
    }

    public SerializedClass(String name, long serialVersionUid, byte classDescriptionFlags, SerializedEntityPool pool) {
        super(pool);
        this.name = name;
        this.serialVersionUid = serialVersionUid;
        this.classDescriptionFlags = classDescriptionFlags;
        this.fields = new ArrayList<SerializedFieldBase>();
    }

    @Override
    protected void parseClass(DataInputStream din, SerializedEntityPool pool, SerializedEntityParser parser) throws IOException {
        this.name = din.readUTF();
        this.serialVersionUid = din.readLong();
        this.classDescriptionFlags = din.readByte();
        int fieldCount = din.readShort();
        this.fields = new ArrayList<SerializedFieldBase>();
        for (int i = 0; i < fieldCount; ++i) {
            this.fields.add(SerializedClass.readFieldDescription(din, parser));
        }
    }

    private static SerializedFieldBase readFieldDescription(DataInputStream din, SerializedEntityParser parser) throws IOException {
        byte next = din.readByte();
        String fieldName = din.readUTF();
        return switch (next) {
            case 91 -> new SerializedArrayField(fieldName, parser);
            case 76 -> new SerializedObjectField(fieldName, parser);
            default -> SerializedPrimitiveFieldBase.fromTypeCode((char)next, fieldName);
        };
    }

    @Override
    protected void serializeClass(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        dos.writeByte(114);
        dos.writeUTF(this.name);
        dos.writeLong(this.serialVersionUid);
        dos.writeByte(this.classDescriptionFlags);
        dos.writeShort(this.fields.size());
        for (SerializedFieldBase field : this.fields) {
            if (!(field instanceof SerializedPrimitiveFieldBase)) continue;
            field.serialize(dos, serializer);
        }
        for (SerializedFieldBase field : this.fields) {
            if (field instanceof SerializedPrimitiveFieldBase) continue;
            field.serialize(dos, serializer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSerialVersionUid() {
        return this.serialVersionUid;
    }

    public void setSerialVersionUid(long serialVersionUid) {
        this.serialVersionUid = serialVersionUid;
    }

    public byte getClassDescriptionFlags() {
        return this.classDescriptionFlags;
    }

    public UnmodifiableList<SerializedFieldBase> getFields() {
        return CollectionUtils.asUnmodifiable(this.fields);
    }

    public String toString() {
        return "Plain class " + this.name;
    }

    public SerializedFieldBase getField(String name) {
        for (SerializedFieldBase field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean containsField(String name) {
        return this.getField(name) != null;
    }

    public void addField(SerializedFieldBase newField) {
        CCSMAssert.isFalse(this.containsField(newField.getName()), "Field with name '" + newField.getName() + "' already exists in " + this.name);
        this.fields.add(newField);
    }

    public void removeField(String name) {
        this.fields.removeIf(field -> field.getName().equals(name));
    }

    public void renameField(String oldFieldName, String newFieldName) {
        SerializedFieldBase field = this.getField(oldFieldName);
        if (field != null) {
            field.setName(newFieldName);
        }
    }

    public boolean isExternalizable() {
        return (this.classDescriptionFlags & 4) != 0;
    }

    public boolean isSerializable() {
        return (this.classDescriptionFlags & 2) != 0;
    }

    public boolean hasWriteMethod() {
        return (this.classDescriptionFlags & 1) != 0;
    }

    public boolean hasBlockData() {
        return (this.classDescriptionFlags & 8) != 0;
    }

    public static SerializedClass createSimpleEnum(SerializedEntityPool entityPool, String enumName) {
        SerializedClass resultClass = new SerializedClass(enumName, 0L, 18, entityPool);
        SerializedClass enumClass = entityPool.findClass(Enum.class.getName());
        if (enumClass == null) {
            enumClass = new SerializedClass(Enum.class.getName(), 0L, 18, entityPool);
        }
        resultClass.superClassHandle = enumClass.getHandle();
        return resultClass;
    }

    public static SerializedClass createClass(SerializedEntityPool entityPool, String className) {
        return new SerializedClass(className, 1L, 2, entityPool);
    }
}

