/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataOutputStream;
import java.io.IOException;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;

public class SerializedEnumLiteral
extends SerializedObjectBase {
    private String literalName;

    public SerializedEnumLiteral(SerializedEntityPool pool, SerializedEntityParser parser, int classHandle) throws IOException {
        super(pool, classHandle);
        this.literalName = parser.parseStringObject().getValue();
    }

    public SerializedEnumLiteral(SerializedEntityPool pool, int classHandle, String literalName) {
        super(pool, classHandle);
        this.literalName = literalName;
    }

    @Override
    protected byte getObjectTagConstant() {
        return 126;
    }

    @Override
    protected void serializeObjectContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        serializer.serializeStringObject(this.literalName, false);
    }

    public String getLiteralName() {
        return this.literalName;
    }

    public void setLiteralName(String literalName) {
        this.literalName = literalName;
    }

    public static <E extends Enum<E>> int createLiteral(SerializedEntityPool entityPool, int enumClassHandle, E value) {
        SerializedEnumLiteral enumLiteral = new SerializedEnumLiteral(entityPool, enumClassHandle, value.name());
        return enumLiteral.getHandle();
    }
}

