/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.utils;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.classes.SerializedLongField;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;

public class SerializedClassFieldMigrator {
    private final SerializedEntityPool entityPool;

    public SerializedClassFieldMigrator(SerializedEntityPool entityPool) {
        this.entityPool = entityPool;
    }

    public void renameField(String serializedClassName, String oldFieldName, String newFieldName) {
        SerializedClass serializedClass = this.entityPool.findClass(serializedClassName);
        if (serializedClass == null) {
            return;
        }
        serializedClass.renameField(oldFieldName, newFieldName);
    }

    public void updateStringFieldValue(String serializedClassName, String fieldName, Function<String, String> fieldValueUpdater) throws IOException {
        SerializedClass serializedClass = this.entityPool.findClass(serializedClassName);
        if (serializedClass == null) {
            return;
        }
        for (SerializedObject serializedObject : SerializedEntityUtils.findInstancesOf(serializedClass, this.entityPool)) {
            int stringObjectHandle = (Integer)serializedObject.getFieldValue(fieldName);
            String oldValue = this.entityPool.getEntity(stringObjectHandle, SerializedStringObject.class).getValue();
            String newValue = fieldValueUpdater.apply(oldValue);
            serializedObject.setFieldValue(fieldName, new SerializedStringObject(newValue, this.entityPool).getHandle());
        }
    }

    public void addBooleanField(String serializedClassName, String fieldName, boolean defaultValue) throws IOException {
        this.addField(serializedClassName, fieldName, new SerializedBooleanField(fieldName), defaultValue);
    }

    public void addLongField(String serializedClassName, String fieldName, long defaultValue) throws IOException {
        this.addField(serializedClassName, fieldName, new SerializedLongField(fieldName), defaultValue);
    }

    public void addIntField(String serializedClassName, String fieldName, int defaultValue) throws IOException {
        this.addField(serializedClassName, fieldName, new SerializedIntField(fieldName), defaultValue);
    }

    public void addStringField(String serializedClassName, String fieldName, String defaultValue) throws IOException {
        this.addField(serializedClassName, fieldName, new SerializedObjectField(fieldName, SerializedObjectField.STRING_TYPE), new SerializedStringObject(defaultValue, this.entityPool).getHandle());
    }

    public void addListField(String serializedClassName, String fieldName, int defaultValueHandle) throws IOException {
        this.addField(serializedClassName, fieldName, new SerializedObjectField(fieldName, SerializedObjectField.LIST_TYPE), defaultValueHandle);
    }

    private void addField(String serializedClassName, String fieldName, SerializedFieldBase serializedField, Object defaultValue) throws IOException {
        SerializedClass serializedClass = this.entityPool.findClass(serializedClassName);
        if (serializedClass == null) {
            return;
        }
        CCSMAssert.isTrue(serializedClass.getField(fieldName) == null, () -> "Can't add the already existing field " + fieldName + " to class " + serializedClassName);
        serializedClass.addField(serializedField);
        for (SerializedObject entity : SerializedEntityUtils.findInstancesOf(serializedClass, this.entityPool)) {
            entity.setFieldValue(fieldName, defaultValue);
        }
    }

    public void removeField(String className, String fieldName) throws IOException {
        SerializedClass serializedClass = this.entityPool.findClass(className);
        if (serializedClass == null) {
            return;
        }
        List<SerializedObject> instances = SerializedEntityUtils.findInstancesOf(serializedClass, this.entityPool);
        for (SerializedObject instance : instances) {
            instance.removeFieldValue(fieldName);
        }
        serializedClass.removeField(fieldName);
    }
}

