/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class CacheConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static CacheConfiguration instance;
    private boolean disableServiceCache = false;

    private CacheConfiguration() {
        Path propertiesFile = Paths.get("config/cache.properties", new String[0]);
        if (!FileSystemUtils.isReadableFile((Path)propertiesFile)) {
            return;
        }
        try {
            Properties properties = FileSystemUtils.readProperties((Path)propertiesFile);
            this.disableServiceCache = Boolean.parseBoolean(properties.getProperty("disableMemoryCache"));
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to read compiler config from " + String.valueOf(propertiesFile) + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized CacheConfiguration getInstance() {
        if (instance == null) {
            instance = new CacheConfiguration();
        }
        return instance;
    }

    public synchronized boolean isServiceCacheDisabled() {
        return this.disableServiceCache;
    }

    public synchronized void setDisableServiceCache(boolean disableServiceCache) {
        this.disableServiceCache = disableServiceCache;
    }
}

