/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.internal.signer.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;

@SdkInternalApi
public class UnbufferedChecksumSubscriber
implements Subscriber<ByteBuffer> {
    private final List<SdkChecksum> checksums;
    private final Subscriber<? super ByteBuffer> wrapped;

    public UnbufferedChecksumSubscriber(List<SdkChecksum> checksums, Subscriber<? super ByteBuffer> wrapped) {
        this.checksums = new ArrayList<SdkChecksum>(checksums);
        this.wrapped = wrapped;
    }

    public void onSubscribe(Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription is null");
        }
        this.wrapped.onSubscribe(subscription);
    }

    public void onNext(ByteBuffer byteBuffer) {
        this.checksums.forEach(ck -> ck.update(byteBuffer.duplicate()));
        this.wrapped.onNext((Object)byteBuffer);
    }

    public void onError(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is null");
        }
        this.wrapped.onError(throwable);
    }

    public void onComplete() {
        this.wrapped.onComplete();
    }
}

