/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;

@IndexValueClass(containedInBackup=true)
public class MetricThresholdConfiguration
extends NamedConfigurableObjectBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="metricThresholdGroupList")
    private final List<MetricThresholdGroup> metricThresholdGroupList = new ArrayList<MetricThresholdGroup>();

    @JsonCreator
    public MetricThresholdConfiguration(@JsonProperty(value="name") String name) {
        super(name);
    }

    public MetricThresholdConfiguration(String name, List<MetricThresholdGroup> groups) {
        this(name);
        this.metricThresholdGroupList.addAll(groups);
    }

    @TestOnly
    public MetricThresholdGroup addMetricThresholdGroup(String metricThresholdGroupName) {
        MetricThresholdGroup group = new MetricThresholdGroup(metricThresholdGroupName);
        this.metricThresholdGroupList.add(group);
        return group;
    }

    public void addMetricThresholdGroup(MetricThresholdGroup metricThresholdGroup) {
        this.metricThresholdGroupList.add(metricThresholdGroup);
    }

    public List<MetricThresholdGroup> getMetricThresholdGroups() {
        return this.metricThresholdGroupList;
    }

    public Optional<MetricThreshold> findThreshold(String thresholdGroupName, String thresholdDisplayName) {
        Optional<MetricThresholdGroup> metricThresholdGroup = this.findGroup(thresholdGroupName);
        if (metricThresholdGroup.isPresent()) {
            return metricThresholdGroup.get().findThresholdByDisplayName(thresholdDisplayName);
        }
        return Optional.empty();
    }

    private Optional<MetricThresholdGroup> findGroup(String groupName) {
        CCSMAssert.isNotNull((Object)groupName);
        return this.metricThresholdGroupList.stream().filter(group -> group.getName().equals(groupName)).findFirst();
    }

    public void adjustAndValidateData() throws MetricThresholdConfigurationException {
        this.adjustData();
        this.validateData();
    }

    private void adjustData() {
        for (MetricThresholdGroup metricThresholdGroup : this.metricThresholdGroupList) {
            metricThresholdGroup.adjustValues();
        }
    }

    private void validateData() throws MetricThresholdConfigurationException {
        for (MetricThresholdGroup metricThresholdGroup : this.metricThresholdGroupList) {
            metricThresholdGroup.validate();
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MetricThresholdConfiguration) {
            MetricThresholdConfiguration otherConfiguration = (MetricThresholdConfiguration)obj;
            return this.getName().equals(otherConfiguration.getName());
        }
        return false;
    }

    @Override
    public String toString() {
        return "MetricThresholdConfiguration [name=" + this.getName() + "]";
    }
}

