/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.client;

import com.teamscale.core.authenticate.github.client.GitHubRateLimiter;
import com.teamscale.core.rest.client.HttpRequestRateLimiter;
import com.teamscale.core.rest.client.IRetrofitApi;
import com.teamscale.core.rest.client.Retrofit;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class GitHubClientBase<GITHUB_API extends IRetrofitApi> {
    protected final GITHUB_API gitHubApi;
    protected final Logger logger;

    protected GitHubClientBase(String baseUrl, String accessToken, @Nullable Logger interactionLogger, Class<GITHUB_API> gitHubApiClass) {
        this(baseUrl, null, accessToken, interactionLogger, gitHubApiClass);
    }

    protected GitHubClientBase(String baseUrl, @Nullable Logger interactionLogger, Class<GITHUB_API> gitHubApiClass) {
        this(baseUrl, null, null, interactionLogger, gitHubApiClass);
    }

    protected GitHubClientBase(String baseUrl, @Nullable String username, @Nullable String accessTokenOrPassword, @Nullable Logger interactionLogger, Class<GITHUB_API> gitHubApiClass) {
        this.logger = Optional.ofNullable(interactionLogger).orElse(LogManager.getLogger());
        this.gitHubApi = this.configureAuthenticationMode(Retrofit.builder((String)StringUtils.ensureEndsWith((String)baseUrl, (String)"/")), username, accessTokenOrPassword).withInteractionLogger(interactionLogger).withCustomRateLimiter((HttpRequestRateLimiter)new GitHubRateLimiter()).create(gitHubApiClass);
    }

    private Retrofit.Builder configureAuthenticationMode(Retrofit.Builder builder, @Nullable String username, @Nullable String passwordOrAccessToken) {
        if (StringUtils.isEmpty((String)passwordOrAccessToken)) {
            this.logger.debug("Configuring client for GitHubAuthApi without authentication");
            return builder.withNoAuthentication();
        }
        if (StringUtils.isEmpty((String)username) || username.equals("x-access-token")) {
            this.logger.debug("Configuring client for GitHubAuthApi with Bearer authentication");
            return builder.withBearerAuthentication(passwordOrAccessToken);
        }
        this.logger.debug("Configuring client for GitHubAuthApi with Basic authentication");
        return builder.withBasicAuthentication(username, passwordOrAccessToken, null);
    }
}

