/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.github.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.teamscale.core.authenticate.github.dto.InstallationRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class InstallationRepositories {
    @JsonProperty(value="repositories")
    private final List<InstallationRepository> repositories = new ArrayList<InstallationRepository>();

    public Optional<InstallationRepository> getRepositoryByFullName(String repositoryName) {
        return this.repositories.stream().filter(repo -> repositoryName.equalsIgnoreCase(repo.getFullName())).findFirst();
    }

    public ImmutableList<InstallationRepository> getRepositories() {
        return ImmutableList.copyOf(this.repositories);
    }

    public void addAll(List<InstallationRepository> installationRepositories) {
        this.repositories.addAll(installationRepositories);
    }
}

