/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.ProjectIndexWithDynamicNameBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Index(name="(dynamic)", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={Object.class, byte[].class})
public class MetricsIndex
extends ProjectIndexWithDynamicNameBase {
    public static final String INDEX_NAME = "metrics";

    public MetricsIndex(IStore store) {
        super(store);
    }

    public List<Object> getMetricValues(PairList<String, String> partitionsAndPaths) throws StorageException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (byte[] value : this.getRawMetricValues(partitionsAndPaths)) {
            result.add(StorageUtils.deserializeCompactObject((byte[])value));
        }
        return result;
    }

    public Map<UniformPath, Object> getMetricValues(String partition, Collection<UniformPath> paths) throws StorageException {
        HashMap<UniformPath, Object> result = HashMap.newHashMap(paths.size());
        List<Object> metricValues = this.getMetricValues((PairList<String, String>)((PairList)paths.stream().map(UniformPath::toStringAsMigrationFrontier).collect(PairList.toPairList(ignored -> partition, Function.identity()))));
        CollectionUtils.forEach(paths, metricValues, (path, metric) -> {
            if (metric != null) {
                result.put((UniformPath)path, metric);
            }
        });
        return result;
    }

    public List<byte[]> getRawMetricValues(PairList<String, String> partitionsAndPaths) throws StorageException {
        return this.store.get(this.createRawKeys(partitionsAndPaths));
    }

    private List<byte[]> createRawKeys(PairList<String, String> partitionsAndPaths) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        Map<String, Integer> abbreviationMap = this.buildAbbreviationMap(partitionsAndPaths.extractFirstList(), partitionsAndPaths.extractSecondList());
        for (int i = 0; i < partitionsAndPaths.size(); ++i) {
            keys.add(MetricsIndex.createRawKey(abbreviationMap.get(partitionsAndPaths.getFirst(i)), abbreviationMap.get(partitionsAndPaths.getSecond(i))));
        }
        return keys;
    }

    public static PairList<String, String> buildPartitionAndPathList(List<String> partitions, List<String> paths) {
        PairList partitionAndPaths = new PairList();
        for (String partition : partitions) {
            for (String file : paths) {
                partitionAndPaths.add((Object)partition, (Object)file);
            }
        }
        return partitionAndPaths;
    }

    public Object getMetricValue(String partition, String uniformPath) throws StorageException {
        PairList partitionsAndPaths = new PairList();
        partitionsAndPaths.add((Object)partition, (Object)uniformPath);
        return this.getMetricValues((PairList<String, String>)partitionsAndPaths).get(0);
    }

    @Deprecated
    public void removeEntries(Collection<String> uniformPaths, String ... partition) throws StorageException {
        this.removeEntries(uniformPaths, Arrays.asList(partition));
    }

    public void removeEntriesForUniformPaths(Collection<UniformPath> uniformPaths, String ... partition) throws StorageException {
        this.removeEntries((Collection<String>)CollectionUtils.map(uniformPaths, UniformPath::toString), Arrays.asList(partition));
    }

    public void removeEntries(Collection<String> uniformPaths, Collection<String> partitions) throws StorageException {
        List<byte[]> keysToDelete = this.createRawKeys(uniformPaths, partitions);
        this.store.remove(keysToDelete);
    }

    public void removeEntries(Collection<PartitionAndPath> deletedPartitionAndPaths) throws StorageException {
        PairList partitionsAndPaths = (PairList)deletedPartitionAndPaths.stream().collect(PairList.toPairList(PartitionAndPath::getPartition, PartitionAndPath::getUniformPath));
        List<byte[]> keysToDelete = this.createRawKeys((PairList<String, String>)partitionsAndPaths);
        this.store.remove(keysToDelete);
    }

    public List<byte[]> createRawKeys(Collection<String> uniformPaths, Collection<String> partitions) throws StorageException {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        Map<String, Integer> abbreviationMap = this.buildAbbreviationMap(uniformPaths, partitions);
        for (String partition : partitions) {
            for (String uniformPath : uniformPaths) {
                keys.add(MetricsIndex.createRawKey(abbreviationMap.get(partition), abbreviationMap.get(uniformPath)));
            }
        }
        return keys;
    }

    @SafeVarargs
    private Map<String, Integer> buildAbbreviationMap(Collection<String> keyStrings, Collection<String> ... moreKeys) throws StorageException {
        return this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(keyStrings, (Collection[])moreKeys));
    }

    public byte[] createRawKey(String partition, String uniformPath) throws StorageException {
        return MetricsIndex.createRawKey(this.store.getAbbreviator().abbreviate(partition), this.store.getAbbreviator().abbreviate(uniformPath));
    }

    private static byte[] createRawKey(int abbreviatedPartition, int abbreviatedUniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviatedPartition), ByteArrayUtils.intToByteArray((int)abbreviatedUniformPath)});
    }

    public <T extends Serializable> void setMetricValues(PairList<String, T> values, String partition) throws StorageException {
        this.setMetricValues(Collections.singletonList(values), Collections.singletonList(partition));
    }

    public <T extends Serializable> void setValuesForUniformPaths(PairList<UniformPath, T> values, String partition) throws StorageException {
        this.setValuesForUniformPaths(Collections.singletonList(values), Collections.singletonList(partition));
    }

    private <T extends Serializable> void setValuesForUniformPaths(List<PairList<UniformPath, T>> allValues, List<String> partitions) throws StorageException {
        this.setMetricValues(CollectionUtils.map(allValues, UniformPathCompatibilityUtil::convertPairList), partitions);
    }

    public <T extends Serializable> void setMetricValues(List<PairList<String, T>> allValues, List<String> partitions) throws StorageException {
        CCSMAssert.isTrue((allValues.size() == partitions.size() ? 1 : 0) != 0, (String)"Values and partitions must have same length.");
        PairList valuesToWrite = new PairList();
        for (int i = 0; i < allValues.size(); ++i) {
            String partition = partitions.get(i);
            PairList<String, T> values = allValues.get(i);
            Map<String, Integer> abbreviationMap = this.buildAbbreviationMap(partitions, values.extractFirstList());
            for (int j = 0; j < values.size(); ++j) {
                valuesToWrite.add((Object)MetricsIndex.createRawKey(abbreviationMap.get(partition), abbreviationMap.get(values.getFirst(j))), (Object)StorageUtils.serializeCompactObject((Object)values.getSecond(j)));
            }
        }
        this.store.put(valuesToWrite);
    }

    public ListMap<String, String> rawIndexKeysToPartitionToUniformMap(List<byte[]> indexKeys) throws StorageException {
        ListMap result = new ListMap();
        ArrayList allKeysAsInts = new ArrayList();
        indexKeys.forEach(key -> {
            allKeysAsInts.add(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)0));
            allKeysAsInts.add(ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4));
        });
        Map unabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(new HashSet(allKeysAsInts));
        CCSMAssert.isTrue((2 * indexKeys.size() == allKeysAsInts.size() ? 1 : 0) != 0, (String)"Expected two integer keys for every raw index key");
        for (int i = 0; i < allKeysAsInts.size(); i += 2) {
            result.add((Object)((String)unabbreviationMap.get(allKeysAsInts.get(i))), (Object)((String)unabbreviationMap.get(allKeysAsInts.get(i + 1))));
        }
        return result;
    }

    public void setRawMetricValues(PairList<byte[], byte[]> keyValueMapping) throws StorageException {
        if (!keyValueMapping.isEmpty()) {
            this.store.put(keyValueMapping);
        }
    }

    public Set<String> rawIndexKeysToUniformPaths(List<byte[]> addedOrChangedRawKeys) throws StorageException {
        HashSet<String> uniformPaths = new HashSet<String>();
        List pathKeysAsInts = CollectionUtils.map(addedOrChangedRawKeys, key -> ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4));
        Map unabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(new HashSet(pathKeysAsInts));
        Iterator iterator = pathKeysAsInts.iterator();
        while (iterator.hasNext()) {
            int abbreviatedPath = (Integer)iterator.next();
            uniformPaths.add((String)unabbreviationMap.get(abbreviatedPath));
        }
        return uniformPaths;
    }
}

