/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.values;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.AssessmentMetricValue;
import com.teamscale.core.metrics.values.CounterSetMetricValue;
import com.teamscale.core.metrics.values.DateOnlyMetricValue;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.NumericMetricValue;
import com.teamscale.core.metrics.values.StringMetricValue;
import com.teamscale.core.metrics.values.TimestampMetricValue;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonSubTypes(value={@JsonSubTypes.Type(value=NumericMetricValue.class), @JsonSubTypes.Type(value=TimestampMetricValue.class), @JsonSubTypes.Type(value=AssessmentMetricValue.class), @JsonSubTypes.Type(value=CounterSetMetricValue.class)})
@IndexValueClass(containedInBackup=true)
public abstract class MetricValueBase<T extends Serializable>
implements IMetricValue<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String SCHEMA_ENTRY_PROPERTY = "schemaEntry";
    protected static final String VALUE_PROPERTY = "value";
    @JsonProperty(value="schemaEntry")
    private final MetricDirectorySchemaEntry schemaEntry;
    @JsonProperty(value="value")
    private final @Nullable T value;

    protected MetricValueBase(MetricDirectorySchemaEntry schemaEntry, @Nullable T value) {
        this.schemaEntry = schemaEntry;
        this.value = value;
    }

    public static MetricValueBase<?> createWithRawValue(MetricDirectorySchemaEntry schemaEntry, Object value) {
        CCSMAssert.isFalse((boolean)(value instanceof Optional), (String)"Use createWithOptional instead.");
        return MetricValueBase.createWithOptional(schemaEntry, Optional.ofNullable(value));
    }

    public static MetricValueBase<?> createWithOptional(MetricDirectorySchemaEntry schemaEntry, Optional<?> optionalValue) {
        CCSMAssert.isNotNull((Object)schemaEntry);
        CCSMAssert.isNotNull(optionalValue);
        Object value = optionalValue.orElse(null);
        return switch (schemaEntry.getValueType()) {
            default -> throw new MatchException(null, null);
            case EMetricValueType.NUMERIC -> new NumericMetricValue(schemaEntry, MetricValueBase.toDouble(value));
            case EMetricValueType.ASSESSMENT -> new AssessmentMetricValue(schemaEntry, value);
            case EMetricValueType.TIMESTAMP -> new TimestampMetricValue(schemaEntry, value);
            case EMetricValueType.COUNTER_SET -> new CounterSetMetricValue(schemaEntry, (CounterSet<String>)((CounterSet)value));
            case EMetricValueType.STRING -> new StringMetricValue(schemaEntry, value);
            case EMetricValueType.DATE_ONLY -> new DateOnlyMetricValue(schemaEntry, value);
        };
    }

    private static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new AssertionError((Object)("Expected numeric value at this point but got " + String.valueOf(value.getClass())));
    }

    @Override
    public MetricDirectorySchemaEntry getSchemaEntry() {
        return this.schemaEntry;
    }

    @Override
    public @Nullable T getOrNull() {
        return this.value;
    }

    @Override
    public T getOrDefault() {
        return (T)Objects.requireNonNullElseGet(this.value, this::getDefaultValue);
    }

    private T getDefaultValue() {
        return (T)((Serializable)this.getSchemaEntry().getValueType().getDefaultValue());
    }

    @Override
    public T getRawValue() {
        CCSMAssert.isNotNull(this.value, (String)"Raw value cannot be accessed for Null value");
        return this.value;
    }

    @Override
    public boolean isValuePresent() {
        return this.value != null;
    }

    @Override
    public Optional<Double> getValueAsDoubleForRating(ETrafficLightColor color) {
        return this.getValueAsDouble(color);
    }

    @Override
    public Optional<Double> getValueAsDouble(ETrafficLightColor color) {
        if (!this.isValuePresent()) {
            return Optional.empty();
        }
        return Optional.of(this.getPresentValueAsDouble(color));
    }

    @Override
    public Optional<IMetricValue<T>> getDelta(MetricValueBase<?> baseValue) {
        if (this.getValueType() != baseValue.getValueType()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.computeDelta(baseValue));
    }

    protected abstract @Nullable MetricValueBase<T> computeDelta(MetricValueBase<T> var1);

    protected abstract double getPresentValueAsDouble(ETrafficLightColor var1);
}

