/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.BranchBasedStoreBatchMigratorBase;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.serialization.SerializedEntityParser;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;

@ThreadSafe
public abstract class MigrateVersion137OrgConqatEngineService
extends SerializedValueMigratorBase {
    private static final Map<String, String> CLASS_MAPPINGS = MigrateVersion137OrgConqatEngineService.initClassMapping();
    private final String storeName;
    private final EStorageMigratorType type;

    private static @NonNull UnmodifiableMap<String, String> initClassMapping() {
        PairList classMappings = new PairList();
        for (String className : List.of("EFindingBlacklistType", "FindingBlacklistInfo")) {
            classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming(className, "org.conqat.engine.service.shared.data", "com.teamscale.index.blacklisting"));
        }
        classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming("ExternalProcessStepInfo", "org.conqat.engine.service.shared.data", "com.teamscale.index.external"));
        for (String className : List.of("ExternalAnalysisImportInfo", "ExternalAnalysisImportInfos")) {
            classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming(className, "org.conqat.engine.service.shared.data", "com.teamscale.index.external.input.info"));
        }
        for (String className : List.of("ExternalAnalysisImportInfoCompilationCommand", "ExternalAnalysisImportInfoDependencyInfo", "ExternalAnalysisImportInfoExecutionUnit", "ExternalAnalysisImportInfoFindings", "ExternalAnalysisImportInfoIssues", "ExternalAnalysisImportInfoIssuesBase", "ExternalAnalysisImportInfoLineCoverage", "ExternalAnalysisImportInfoMetrics", "ExternalAnalysisImportInfoMetricSchemaChange", "ExternalAnalysisImportInfoMultiFileRangeCoverage", "ExternalAnalysisImportInfoProbeCoverage", "ExternalAnalysisImportInfoProcessStepInfo", "ExternalAnalysisImportInfoReport", "ExternalAnalysisImportInfoSpecItems", "ExternalAnalysisImportInfoTestExecution", "ExternalAnalysisSimulinkCodeGenerationTraceInfo", "ExternalAnalysisSimulinkCodeGenerationTraceInfo$SimulinkCodeGenerationTraces", "IContentAdjustable", "ILineAdjustable")) {
            classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming(className, "org.conqat.engine.service.shared.data.external_analysis", "com.teamscale.index.external.input.info"));
        }
        for (String className : List.of("ExternalAnalysisResult", "ExternalAnalysisResultCompileCommand", "ExternalAnalysisResultDependencyInfo", "ExternalAnalysisResultExecutionUnit", "ExternalAnalysisResultFindings", "ExternalAnalysisResultIssueLikeBase", "ExternalAnalysisResultIssues", "ExternalAnalysisResultLineCoverage", "ExternalAnalysisResultMetrics", "ExternalAnalysisResultMetricSchemaChange", "ExternalAnalysisResultMultiFileRangeCoverage", "ExternalAnalysisResultProbeCoverage", "ExternalAnalysisResultProcessStepInfo", "ExternalAnalysisResults", "ExternalAnalysisResultSimulinkCodeGeneration", "ExternalAnalysisResultSpecItems", "ExternalAnalysisResultTestExecution")) {
            classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming(className, "org.conqat.engine.service.shared.data.external_analysis", "com.teamscale.index.external.result"));
        }
        classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming("MetricSchemaChangeEntry", "org.conqat.engine.service.shared.data", "com.teamscale.index.project"));
        for (String className : List.of("CodeSnippet", "ETaskResolution", "ETaskStatus", "FindingIdWithBranch", "Task", "Task$Comment")) {
            classMappings.add(MigrateVersion137OrgConqatEngineService.getPackageRenaming(className, "org.conqat.engine.service.shared.data", "com.teamscale.index.task"));
        }
        return CollectionUtils.asUnmodifiable((Map)classMappings.toMap());
    }

    private static Pair<String, String> getPackageRenaming(String className, String oldPackage, String newPackage) {
        return new Pair((Object)(oldPackage + "." + className), (Object)(newPackage + "." + className));
    }

    protected MigrateVersion137OrgConqatEngineService(String storeName, boolean compressed, EStorageMigratorType type) {
        super(compressed);
        this.storeName = storeName;
        this.type = type;
    }

    @Override
    public final EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V137;
    }

    @Override
    public final String getStoreName() {
        return this.storeName;
    }

    @Override
    public final EStorageMigratorType getType() {
        return this.type;
    }

    @Override
    public final Set<String> getAdditionalStoreNames() {
        return super.getAdditionalStoreNames();
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        MigrateVersion137OrgConqatEngineService.doMigrate(entityPool);
    }

    private static void doMigrate(SerializedEntityPool entityPool) {
        for (Map.Entry<String, String> classMapping : CLASS_MAPPINGS.entrySet()) {
            entityPool.renameClass(classMapping.getKey(), classMapping.getValue());
        }
    }

    @ThreadSafe
    public static class MigrateFindingBlacklistStagingIndex
    extends MigrateVersion137OrgConqatEngineServiceBranchBasedStoreMigratorBase {
        public MigrateFindingBlacklistStagingIndex() {
            super("finding-blacklist-staging", true);
        }
    }

    @ThreadSafe
    public static class MigrateExternalAnalysisResultIndex
    extends MigrateVersion137OrgConqatEngineServiceBranchBasedStoreMigratorBase {
        public MigrateExternalAnalysisResultIndex() {
            super("external-analysis-results", true);
        }

        @Override
        protected void migrateValue(SerializedEntityPool entityPool) throws IOException {
            super.migrateValue(entityPool);
            MigrateExternalAnalysisResultIndex.patchExternalAnalysisResults(entityPool);
        }

        private static void patchExternalAnalysisResults(SerializedEntityPool entityPool) throws IOException {
            SerializedClass serializedClass = entityPool.findClass("com.teamscale.index.external.result.ExternalAnalysisResults");
            if (serializedClass == null) {
                return;
            }
            for (SerializedObject serializedObject : SerializedEntityUtils.findInstancesOf((SerializedClass)serializedClass, (SerializedEntityPool)entityPool)) {
                Object object = serializedObject.getFieldValue("results");
                if (!(object instanceof Integer)) {
                    CCSMAssert.fail((String)"Serialized object did not contain the expected handle for field \"results\"");
                    return;
                }
                Integer resultsFieldHandle = (Integer)object;
                SerializedObject resultsField = (SerializedObject)entityPool.getEntity(resultsFieldHandle.intValue(), SerializedObject.class);
                List postFieldData = resultsField.getFieldSet(0).getPostFieldData();
                for (int i = 1; i < postFieldData.size(); i += 2) {
                    Object e = postFieldData.get(i);
                    if (!(e instanceof Integer)) {
                        CCSMAssert.fail((String)("Serialized object did not contain the expected key handle at index " + i));
                        return;
                    }
                    Integer nameHandle = (Integer)e;
                    SerializedStringObject nameObject = (SerializedStringObject)entityPool.getEntity(nameHandle.intValue(), SerializedStringObject.class);
                    nameObject.setValue(CLASS_MAPPINGS.getOrDefault(nameObject.getValue(), nameObject.getValue()));
                }
            }
        }
    }

    @ThreadSafe
    private static abstract class MigrateVersion137OrgConqatEngineServiceBranchBasedStoreMigratorBase
    extends BranchBasedStoreBatchMigratorBase {
        private final String storeName;

        protected MigrateVersion137OrgConqatEngineServiceBranchBasedStoreMigratorBase(String storeName, boolean compressingStores) {
            super(EStorageSystemVersion.STORAGE_SYSTEM_V137, compressingStores);
            this.storeName = storeName;
        }

        @Override
        protected byte[] migrateValue(byte[] key, byte[] value) throws StorageException {
            try {
                SerializedEntityPool entityPool = SerializedEntityParser.parse((byte[])value);
                this.migrateValue(entityPool);
                return SerializedEntitySerializer.serializeToBytes((List)entityPool.getRootEntities());
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }

        protected void migrateValue(SerializedEntityPool entityPool) throws IOException {
            MigrateVersion137OrgConqatEngineService.doMigrate(entityPool);
        }

        @Override
        public final String getStoreName() {
            return this.storeName;
        }
    }

    @ThreadSafe
    public static class MigrateQualityReportsIndex
    extends MigrateVersion137OrgConqatEngineService {
        public MigrateQualityReportsIndex() {
            super("quality-reports-index", false, EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static class MigrateTaskIndex
    extends MigrateVersion137OrgConqatEngineService {
        public MigrateTaskIndex() {
            super("tasks", true, EStorageMigratorType.PROJECT);
        }
    }

    @ThreadSafe
    public static class MigrateExternalMetricsDescriptionIndex
    extends MigrateVersion137OrgConqatEngineService {
        public MigrateExternalMetricsDescriptionIndex() {
            super("external-metrics", true, EStorageMigratorType.GLOBAL);
        }
    }

    @ThreadSafe
    public static class MigrateExternalAnalysisImportSessionIndex
    extends MigrateVersion137OrgConqatEngineService {
        public MigrateExternalAnalysisImportSessionIndex() {
            super("external-analysis-session", true, EStorageMigratorType.PROJECT);
        }
    }

    @ThreadSafe
    public static class MigrateBranchAgnosticFindingBlacklistIndex
    extends MigrateVersion137OrgConqatEngineService {
        public MigrateBranchAgnosticFindingBlacklistIndex() {
            super("x-finding-blacklist", true, EStorageMigratorType.PROJECT);
        }
    }
}

