/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.migrators.ReportSlideMigratorBase;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedBooleanField;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedIntField;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedClassValues;
import org.conqat.lib.commons.serialization.objects.SerializedEnumLiteral;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedObjectBase;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion138SlideComments
extends ReportSlideMigratorBase {
    private static final String IMAGE_SLIDE_PARAMETERS_CLASS = "com.teamscale.index.quality_report.slides.ImageSlide$ImageSlideParameters";
    private static final Set<String> PARAMETER_CLASSES_WITH_COMMENTS = Set.of("com.teamscale.index.quality_report.slides.TaskDetailSlide$TaskDetailSlideParameters", "com.teamscale.index.quality_report.slides.AssessmentTrendChartSlide$AssessmentTrendChartSlideParameters", "com.teamscale.index.quality_report.slides.FindingDetailSlide$FindingDetailSlideParameters", "com.teamscale.index.quality_report.slides.MetricTrendChartSlide$MetricTrendChartSlideParameters", "com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide$SystemQualityOverviewSlideParameters", "com.teamscale.index.quality_report.slides.MetricBarChartSlide$MetricBarChartSlideParameters", "com.teamscale.index.quality_report.slides.TasksSlide$TasksSlideParameters", "com.teamscale.index.quality_report.slides.ImageSlide$ImageSlideParameters", "com.teamscale.index.quality_report.slides.TestGapTreemapSlide$TestGapTreemapSlideParameters");
    private static final Set<String> RESULT_CLASSES_WITH_COMMENTS = Set.of("com.teamscale.index.quality_report.slides.TaskDetailSlide$TaskDetailSlideResult", "com.teamscale.index.quality_report.slides.FindingDetailSlide$FindingDetailSlideResult", "com.teamscale.index.quality_report.slides.MetricTrendChartSlide$TrendChartSlideResult", "com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide$SystemQualityOverviewSlideResult", "com.teamscale.index.quality_report.slides.MetricBarChartSlide$MetricBarChartSlideResult", "com.teamscale.index.quality_report.slides.TasksSlide$TasksSlideResult", "com.teamscale.index.quality_report.slides.ImageSlide$ImageSlideResult", "com.teamscale.index.quality_report.slides.TestGapTreemapSlide$TestGapTreemapSlideResult");
    private static final Set<String> SLIDE_CLASSES_WITH_COMMENTS = Set.of("com.teamscale.index.quality_report.slides.TasksSlide", "com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide", "com.teamscale.index.quality_report.slides.FindingDetailSlide", "com.teamscale.index.quality_report.slides.ImageSlide", "com.teamscale.index.quality_report.slides.TestGapTreemapSlide", "com.teamscale.index.quality_report.slides.TaskDetailSlide", "com.teamscale.index.quality_report.slides.MetricBarChartSlide", "com.teamscale.index.quality_report.slides.AssessmentTrendChartSlide", "com.teamscale.index.quality_report.slides.MetricTrendChartSlide");
    private static final Set<String> RESULT_CLASSES_WITH_REMOVED_SLIDE_TITLE = Set.of("com.teamscale.index.quality_report.slides.FindingDetailSlide$FindingDetailSlideResult", "com.teamscale.index.quality_report.slides.MetricTrendChartSlide$TrendChartSlideResult", "com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide$SystemQualityOverviewSlideResult", "com.teamscale.index.quality_report.slides.MetricBarChartSlide$MetricBarChartSlideResult", "com.teamscale.index.quality_report.slides.TasksSlide$TasksSlideResult", "com.teamscale.index.quality_report.slides.ImageSlide$ImageSlideResult");
    private static final Map<String, String> BLACKLIST_OPTION_MAPPING = Map.of("Hide false positives and tolerations", "EXCLUDED", "Show all", "ALL", "Show tolerations", "ONLY_TOLERATED", "Show false positives", "ONLY_FALSE_POSITIVES", "Show false positives and tolerations", "ONLY_BLACKLISTED", "Hide false positives", "HIDE_FALSE_POSITIVES", "Hide tolerations", "HIDE_TOLERATED");
    private static final String SLIDE_COMMENT_CLASS = "com.teamscale.index.quality_report.slides.SlideComment";
    private static final String BADGE_SLIDE_COMMENT_CLASS = "com.teamscale.index.quality_report.slides.BadgeSlideComment";
    private static final String BASIC_FINDINGS_FILTER_SETTINGS_CLASS = "com.teamscale.index.findings.calculation.BasicFindingsFilterSettings";

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        for (String parameterClass : PARAMETER_CLASSES_WITH_COMMENTS) {
            this.ensureHasCommentListField(entityPool, parameterClass);
        }
        for (String resultClassName : RESULT_CLASSES_WITH_COMMENTS) {
            MigrateVersion138SlideComments.removeField(resultClassName, "slideComments", entityPool);
            this.ensureHasCommentListField(entityPool, resultClassName);
        }
        for (String resultClass : RESULT_CLASSES_WITH_REMOVED_SLIDE_TITLE) {
            MigrateVersion138SlideComments.removeField(resultClass, "slideTitle", entityPool);
        }
        for (String slideClassName : SLIDE_CLASSES_WITH_COMMENTS) {
            SerializedClass slideClass = entityPool.findClass(slideClassName);
            if (slideClass == null) continue;
            List slideInstances = SerializedEntityUtils.findInstancesOf((SerializedClass)slideClass, (SerializedEntityPool)entityPool);
            for (SerializedObject slideInstance : slideInstances) {
                this.migrateCommentsForSlide(entityPool, slideInstance);
            }
        }
        MigrateVersion138SlideComments.removeField(SLIDE_COMMENT_CLASS, "type", entityPool);
        SerializedClass badgeCommentClass = entityPool.findClass(BADGE_SLIDE_COMMENT_CLASS);
        if (badgeCommentClass != null) {
            this.migrateBadgeSlideComment(entityPool, badgeCommentClass);
        }
        MigrateVersion138SlideComments.migrateImageSlideParameter(entityPool);
        MigrateVersion138SlideComments.removeField("com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide$SystemQualityOverviewSlideResult", "overrides", entityPool);
        MigrateVersion138SlideComments.removeField("com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide$SystemQualityOverviewSlideResult", "includeOptions", entityPool);
    }

    private static void migrateImageSlideParameter(SerializedEntityPool entityPool) throws IOException {
        SerializedClass imageSlideParameters = entityPool.findClass(IMAGE_SLIDE_PARAMETERS_CLASS);
        if (imageSlideParameters == null) {
            return;
        }
        if (!imageSlideParameters.containsField("fitToSlideWidth")) {
            new SerializedClassFieldMigrator(entityPool).addBooleanField(IMAGE_SLIDE_PARAMETERS_CLASS, "fitToSlideWidth", false);
            return;
        }
        imageSlideParameters.renameField("fitToSlideWidth", "oldFitToSlideWidth");
        new SerializedClassFieldMigrator(entityPool).addBooleanField(IMAGE_SLIDE_PARAMETERS_CLASS, "fitToSlideWidth", false);
        List imageSlideParameterInstances = SerializedEntityUtils.findInstancesOf((SerializedClass)imageSlideParameters, (SerializedEntityPool)entityPool);
        for (SerializedObject imageSlideParameter : imageSlideParameterInstances) {
            Object oldFitToSlideWidthHandle = imageSlideParameter.getFieldValue("oldFitToSlideWidth");
            SerializedObject oldFitToSlideWidth = (SerializedObject)entityPool.getEntity(((Integer)oldFitToSlideWidthHandle).intValue(), SerializedObject.class);
            Object oldValue = false;
            if (oldFitToSlideWidth != null) {
                oldValue = oldFitToSlideWidth.getFieldValue("value");
            }
            imageSlideParameter.setFieldValue("fitToSlideWidth", oldValue);
        }
        MigrateVersion138SlideComments.removeField(IMAGE_SLIDE_PARAMETERS_CLASS, "oldFitToSlideWidth", entityPool);
    }

    private void migrateCommentsForSlide(SerializedEntityPool entityPool, SerializedObject slideInstance) throws IOException, MigrationException {
        Object rawRenderDataHandle = slideInstance.getFieldValue("rawRenderData");
        if (rawRenderDataHandle == null) {
            return;
        }
        SerializedObject rawRenderData = (SerializedObject)entityPool.getEntity(((Integer)rawRenderDataHandle).intValue(), SerializedObject.class);
        if (rawRenderData == null) {
            return;
        }
        SerializedObject commentListObject = this.getSlideParameterComments(entityPool, slideInstance);
        List comments = SerializationMigrationUtils.getObjectsFromArrayList((SerializedObject)commentListObject, (SerializedEntityPool)entityPool);
        ArrayList<SerializedObjectBase> commentRenderData = new ArrayList<SerializedObjectBase>();
        for (SerializedObject comment : comments) {
            commentRenderData.add(this.wrapComment(comment, entityPool));
        }
        rawRenderData.setFieldValue("comments", (Object)SerializationMigrationUtils.createSerializedArrayListObject(commentRenderData, (SerializedEntityPool)entityPool).getHandle());
    }

    private void ensureHasCommentListField(SerializedEntityPool entityPool, String parameterClass) throws IOException {
        SerializedClass paramsClass = entityPool.findClass(parameterClass);
        if (paramsClass != null && !paramsClass.containsField("comments")) {
            new SerializedClassFieldMigrator(entityPool).addListField(parameterClass, "comments", SerializationMigrationUtils.createSerializedArrayListObject(List.of(), (SerializedEntityPool)entityPool).getHandle());
        }
    }

    private SerializedObjectBase wrapComment(SerializedObject comment, SerializedEntityPool entityPool) throws IOException, MigrationException {
        int slideCommentRenderDataClassHandle = MigrateVersion138SlideComments.getOrCreateSlideCommentRenderData(entityPool);
        SerializedObject slideCommentRenderData = new SerializedObject(slideCommentRenderDataClassHandle, List.of(new SerializedClassValues(2)), entityPool);
        slideCommentRenderData.setFieldValue("slideComment", (Object)comment.getHandle());
        int classHandle = comment.getClassHandle();
        SerializedClass classEntity = (SerializedClass)entityPool.getEntity(classHandle, SerializedClass.class);
        if (BADGE_SLIDE_COMMENT_CLASS.equals(classEntity.getName())) {
            Integer textHandle = (Integer)comment.getFieldValue("text");
            String text = ((SerializedStringObject)entityPool.getEntity(textHandle.intValue(), SerializedStringObject.class)).getValue();
            FindingsSummaryDto findingsSummaryDto = StringUtils.isBlank((CharSequence)text) ? new FindingsSummaryDto(0, 0, 0) : MigrateVersion138SlideComments.deserializeFromJson(text, FindingsSummaryDto.class);
            int badgeRenderDataClassHandle = MigrateVersion138SlideComments.getOrCreateSlideFindingBadgeRenderData(entityPool);
            SerializedObject badgeRenderData = new SerializedObject(badgeRenderDataClassHandle, List.of(new SerializedClassValues(3)), entityPool);
            badgeRenderData.setFieldValue("numberOfAddedFindings", (Object)findingsSummaryDto.numberOfAddedFindings);
            badgeRenderData.setFieldValue("numberOfFindingsInChangedCode", (Object)findingsSummaryDto.numberOfFindingsInChangedCode);
            badgeRenderData.setFieldValue("numberOfRemovedFindings", (Object)findingsSummaryDto.numberOfRemovedFindings);
            slideCommentRenderData.setFieldValue("badgeRenderData", (Object)badgeRenderData.getHandle());
        } else {
            slideCommentRenderData.setFieldValue("badgeRenderData", (Object)0);
        }
        return slideCommentRenderData;
    }

    private static int getOrCreateSlideCommentRenderData(SerializedEntityPool entityPool) {
        return entityPool.getOrCreateClass("com.teamscale.index.quality_report.slides.SlideCommentRenderData", new SerializedFieldBase[]{new SerializedObjectField("slideComment", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.index.quality_report.slides.ISlideComment")), new SerializedObjectField("badgeRenderData", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.index.quality_report.slides.SlideFindingBadgeRenderData"))}).getHandle();
    }

    private static int getOrCreateSlideFindingBadgeRenderData(SerializedEntityPool entityPool) {
        return entityPool.getOrCreateClass("com.teamscale.index.quality_report.slides.SlideFindingBadgeRenderData", new SerializedFieldBase[]{new SerializedIntField("numberOfAddedFindings"), new SerializedIntField("numberOfFindingsInChangedCode"), new SerializedIntField("numberOfRemovedFindings")}).getHandle();
    }

    private SerializedObject getSlideParameterComments(SerializedEntityPool entityPool, SerializedObject slideInstance) throws IOException {
        Object slideParametersHandle = slideInstance.getFieldValue("slideParameters");
        SerializedObject slideParameters = (SerializedObject)entityPool.getEntity(((Integer)slideParametersHandle).intValue(), SerializedObject.class);
        Object commentListHandle = slideParameters.getFieldValue("comments");
        if (commentListHandle == null || commentListHandle.equals(0)) {
            SerializedObject commentList = SerializationMigrationUtils.createSerializedArrayListObject(List.of(), (SerializedEntityPool)entityPool);
            slideParameters.setFieldValue("comments", (Object)commentList.getHandle());
            return commentList;
        }
        return (SerializedObject)entityPool.getEntity(((Integer)commentListHandle).intValue(), SerializedObject.class);
    }

    private void migrateBadgeSlideComment(SerializedEntityPool entityPool, SerializedClass badgeCommentClass) throws IOException, MigrationException {
        badgeCommentClass.renameField("findingFilter", "findingFilterString");
        badgeCommentClass.addField((SerializedFieldBase)new SerializedObjectField("findingFilter", SerializedObjectField.createJvmNotationFromPlainClassName((String)BASIC_FINDINGS_FILTER_SETTINGS_CLASS)));
        int basicFindingsFilterSettingsHandle = MigrateVersion138SlideComments.createBasicFindingsFilterClass(entityPool);
        int patternClassHandle = this.createPatternClassHandle(entityPool);
        int blacklistOptionEnumHandle = SerializedClass.createSimpleEnum((SerializedEntityPool)entityPool, (String)"com.teamscale.index.findings.calculation.EBlacklistingOption").getHandle();
        int colorEnumHandle = SerializedClass.createSimpleEnum((SerializedEntityPool)entityPool, (String)"org.conqat.lib.commons.assessment.ETrafficLightColor").getHandle();
        List badgeCommentInstances = SerializedEntityUtils.findInstancesOf((SerializedClass)badgeCommentClass, (SerializedEntityPool)entityPool);
        for (SerializedObject badgeCommentInstance : badgeCommentInstances) {
            Object findingFilter = badgeCommentInstance.getFieldValue("findingFilterString");
            Object blacklistOption = badgeCommentInstance.getFieldValue("blacklistOption");
            SerializedObject basicFindingFilter = this.getFindingFilter(entityPool, (Integer)findingFilter, (Integer)blacklistOption, basicFindingsFilterSettingsHandle, patternClassHandle, blacklistOptionEnumHandle, colorEnumHandle);
            badgeCommentInstance.setFieldValue("findingFilter", (Object)basicFindingFilter.getHandle());
        }
        MigrateVersion138SlideComments.removeSuperClass(badgeCommentClass, badgeCommentInstances);
        MigrateVersion138SlideComments.removeField(BADGE_SLIDE_COMMENT_CLASS, "findingFilterString", entityPool);
        MigrateVersion138SlideComments.removeField(BADGE_SLIDE_COMMENT_CLASS, "blacklistOption", entityPool);
    }

    private static void removeField(String className, String fieldName, SerializedEntityPool entityPool) throws IOException {
        new SerializedClassFieldMigrator(entityPool).removeField(className, fieldName);
    }

    private static void removeSuperClass(SerializedClass badgeCommentClass, List<SerializedObject> badgeCommentInstances) {
        for (SerializedObject badgeCommentInstance : badgeCommentInstances) {
            badgeCommentInstance.removeFieldSet(0);
        }
        badgeCommentClass.setSuperClassHandle(0);
    }

    private SerializedObject getFindingFilter(SerializedEntityPool entityPool, Integer badgeFindingFilterHandle, Integer blacklistOptionHandle, int basicFindingsFilterSettingsHandle, int patternClassHandle, int blacklistOptionEnumHandle, int colorEnumHandle) throws IOException, MigrationException {
        String badgeFindingFilter = ((SerializedStringObject)entityPool.getEntity(badgeFindingFilterHandle.intValue(), SerializedStringObject.class)).getValue();
        String blacklistOptionString = ((SerializedStringObject)entityPool.getEntity(blacklistOptionHandle.intValue(), SerializedStringObject.class)).getValue();
        String blacklistOption = BLACKLIST_OPTION_MAPPING.get(blacklistOptionString);
        FindingsFilterDto findingsFilterDto = MigrateVersion138SlideComments.deserializeFromJson(badgeFindingFilter, FindingsFilterDto.class);
        SerializedObject findingFilter = new SerializedObject(basicFindingsFilterSettingsHandle, Collections.singletonList(new SerializedClassValues(12)), entityPool);
        SerializedObject regexFilter = new SerializedObject(patternClassHandle, Collections.singletonList(new SerializedClassValues(2)), entityPool);
        regexFilter.setFieldValue("pattern", (Object)new SerializedStringObject(findingsFilterDto.regex, entityPool).getHandle());
        regexFilter.setFieldValue("flags", (Object)0);
        findingFilter.setFieldValue("regexFilter", (Object)regexFilter.getHandle());
        findingFilter.setFieldValue("guidelineFilter", (Object)new SerializedStringObject(findingsFilterDto.guideline, entityPool).getHandle());
        findingFilter.setFieldValue("guidelineRulesFilter", this.stringListObject(findingsFilterDto.guidelineRules, entityPool));
        findingFilter.setFieldValue("excludeRegexFilter", (Object)findingsFilterDto.excludeRegex);
        findingFilter.setFieldValue("filterFindingsAddedToTasks", (Object)findingsFilterDto.addedToTaskFilter);
        findingFilter.setFieldValue("categoryGroupTypeFilters", this.stringListObject(findingsFilterDto.categoryGroupTypeFilters, entityPool));
        findingFilter.setFieldValue("invertCategoryGroupTypeFilters", (Object)findingsFilterDto.invertCategoryGroupTypeFilters);
        findingFilter.setFieldValue("assessmentFilters", this.enumListObject(findingsFilterDto.assessmentFilters, colorEnumHandle, entityPool));
        findingFilter.setFieldValue("blacklistingOption", (Object)new SerializedEnumLiteral(entityPool, blacklistOptionEnumHandle, blacklistOption).getHandle());
        findingFilter.setFieldValue("includedPaths", this.stringListObject(findingsFilterDto.includedPaths, entityPool));
        findingFilter.setFieldValue("excludedPaths", this.stringListObject(findingsFilterDto.excludedPaths, entityPool));
        findingFilter.setFieldValue("onlySpecItemFindings", (Object)false);
        return findingFilter;
    }

    private static <T> T deserializeFromJson(String badgeFindingFilter, Class<T> expectedClass) throws MigrationException {
        try {
            return (T)JsonUtils.deserializeFromJson((String)badgeFindingFilter, expectedClass);
        }
        catch (JsonSerializationException e) {
            throw new MigrationException("Failed to deserialize " + badgeFindingFilter + "!", e);
        }
    }

    private Object stringListObject(List<String> list, SerializedEntityPool entityPool) throws IOException {
        return SerializationMigrationUtils.createSerializedArrayListObject((List)CollectionUtils.map(list, entry -> new SerializedStringObject(entry, entityPool)), (SerializedEntityPool)entityPool).getHandle();
    }

    private Object enumListObject(List<? extends Enum> list, int enumHandle, SerializedEntityPool entityPool) throws IOException {
        return SerializationMigrationUtils.createSerializedArrayListObject((List)CollectionUtils.map(list, entry -> new SerializedEnumLiteral(entityPool, enumHandle, entry.name())), (SerializedEntityPool)entityPool).getHandle();
    }

    private int createPatternClassHandle(SerializedEntityPool entityPool) {
        SerializedClass arrayListClass = entityPool.findClass(Pattern.class.getName());
        if (arrayListClass == null) {
            arrayListClass = new SerializedClass(Pattern.class.getName(), 5073258162644648461L, 3, entityPool);
            arrayListClass.addField((SerializedFieldBase)new SerializedObjectField("pattern", SerializedObjectField.STRING_TYPE));
            arrayListClass.addField((SerializedFieldBase)new SerializedIntField("flags"));
        }
        return arrayListClass.getHandle();
    }

    private static int createBasicFindingsFilterClass(SerializedEntityPool entityPool) {
        return entityPool.getOrCreateClass(BASIC_FINDINGS_FILTER_SETTINGS_CLASS, new SerializedFieldBase[]{new SerializedObjectField("regexFilter", SerializedObjectField.createJvmNotationFromPlainClassName((String)Pattern.class.getName())), new SerializedObjectField("guidelineFilter", SerializedObjectField.STRING_TYPE), new SerializedObjectField("guidelineRulesFilter", SerializedObjectField.LIST_TYPE), new SerializedBooleanField("excludeRegexFilter"), new SerializedBooleanField("filterFindingsAddedToTasks"), new SerializedObjectField("categoryGroupTypeFilters", SerializedObjectField.LIST_TYPE), new SerializedBooleanField("invertCategoryGroupTypeFilters"), new SerializedObjectField("assessmentFilters", SerializedObjectField.LIST_TYPE), new SerializedObjectField("blacklistingOption", SerializedObjectField.createJvmNotationFromPlainClassName((String)"com.teamscale.index.findings.calculation.EBlacklistingOption")), new SerializedObjectField("includedPaths", SerializedObjectField.LIST_TYPE), new SerializedObjectField("excludedPaths", SerializedObjectField.LIST_TYPE), new SerializedBooleanField("onlySpecItemFindings")}).getHandle();
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V138;
    }

    private record FindingsSummaryDto(@JsonProperty int numberOfAddedFindings, @JsonProperty int numberOfFindingsInChangedCode, @JsonProperty int numberOfRemovedFindings) {
    }

    private record FindingsFilterDto(@JsonProperty List<String> categoryGroupTypeFilters, @JsonProperty List<ETrafficLightColor> assessmentFilters, @JsonProperty List<String> includedPaths, @JsonProperty List<String> excludedPaths, @JsonProperty String regex, @JsonProperty String guideline, @JsonProperty List<String> guidelineRules, @JsonProperty boolean excludeRegex, @JsonProperty boolean addedToTaskFilter, @JsonProperty boolean invertCategoryGroupTypeFilters, @JsonProperty String blacklistRationale) {
    }
}

