/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.analysis.trigger.AnalysisStepBase;
import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.committree.CommitTree;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolver;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.RollbackLogMessage;
import com.teamscale.core.runtime.impl.CommitChildrenIndex;
import com.teamscale.core.runtime.impl.analysis.ETriggerExecutionResult;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepBranchingLayerAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepDeltaSource;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepGlobalIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccess;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepIndexAccessBase;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepParameter;
import com.teamscale.core.runtime.impl.analysis.step.AnalysisStepPostInjectionMethod;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.ETriggerType;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.CommitDescriptorMerger;
import com.teamscale.core.runtime.impl.scheduling.TriggerCache;
import com.teamscale.core.runtime.impl.worker.ICrossProjectLockSupport;
import com.teamscale.core.runtime.impl.worker.NonLockingLockSupport;
import com.teamscale.core.runtime.impl.worker.RecordingStore;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResultWrapper;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.IStoreDecorator;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreWithAbbreviationSupport;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.IStorageAbbreviator;
import org.conqat.engine.persistence.store.util.ReadOnlyStore;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AnalysisTriggerExecutorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<EIndexAccessMode> ORDERED_ACCESS_MODES = List.of(EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY, EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY, EIndexAccessMode.READ_WRITE, EIndexAccessMode.READ_ONLY);
    public static final String REPOSITORY_NEEDS_RESCHEDULE_EXCEPTION_NAME = "RepositoryNeedsRescheduleException";
    private final String triggerName;
    private final InternalProjectId projectId;
    private final TriggerDescription triggerDescription;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final ILockProvider lockProvider;
    private AnalysisTrigger trigger;
    private CommitDescriptor commit = null;
    private UnmodifiableList<LogEvent> loggingEvents = CollectionUtils.emptyList();
    protected final PairList<String, RecordingStore> recordingStores = new PairList();
    private final Map<String, IStorageIndex> openIndexes = new HashMap<String, IStorageIndex>();
    private final Map<String, List<IStorageIndex>> openedPreviousIndexes = new HashMap<String, List<IStorageIndex>>();
    private final List<IIndexDelta> inputDeltas = new ArrayList<IIndexDelta>();
    private IProfilingMonitor profilingMonitor;
    private final CommitResolver commitResolver = new CommitResolver();
    private final Set<String> requiredDeltas = new HashSet<String>();
    private boolean testMode = false;
    private TriggerExecutionResultWrapper result;

    protected AnalysisTriggerExecutorBase(String triggerName, InternalProjectId projectId, TriggerDescription triggerDescription, IParallelTaskExecutor parallelTaskExecutor, ILockProvider lockProvider) {
        this.triggerName = triggerName;
        this.projectId = projectId;
        this.triggerDescription = triggerDescription;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.lockProvider = lockProvider;
    }

    public void setCommit(CommitDescriptor commit) {
        this.commit = commit;
    }

    public Optional<CommitDescriptor> getCommit() {
        return Optional.ofNullable(this.commit);
    }

    public void addExpectedDeltas(Collection<String> storeNames) {
        this.requiredDeltas.addAll(storeNames);
    }

    public UnmodifiableList<LogEvent> getLoggingEvents() {
        return this.loggingEvents;
    }

    public List<LogEvent> getLoggingEventsForLevels(Set<ELogLevel> levels) {
        Set log4jLevels = levels.stream().map(ELogLevel::getLog4JLevel).collect(Collectors.toSet());
        return CollectionUtils.filter(this.loggingEvents, log -> log4jLevels.contains(log.getLevel()));
    }

    public TriggerExecutionResultWrapper getExecutionResult() {
        if (this.result == null) {
            throw new IllegalStateException("No result computed yet");
        }
        return this.result;
    }

    @TestOnly
    public void executeInTestMode(TriggerCache triggerCache, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem) throws StorageException, TriggerCompilationException {
        this.testMode = true;
        this.checkAndUpdateCommitDescriptorIndex(projectStorageSystem);
        this.execute(triggerCache, projectStorageSystem, globalStorageSystem, new NonLockingLockSupport(), ignored -> SilentAutoClosable.empty());
    }

    @TestOnly
    private void checkAndUpdateCommitDescriptorIndex(ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (this.commit == null) {
            return;
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        ParentedCommitDescriptor storedCommit = commitDescriptorIndex.getCommit(this.commit);
        if (storedCommit != null) {
            return;
        }
        ArrayList<CommitDescriptor> parentCommits = new ArrayList<CommitDescriptor>(this.getParentsFromCommitTree(projectStorageSystem));
        List<ParentedCommitDescriptor> commitsOnSameBranch = commitDescriptorIndex.getCommitsForBranch(this.commit.getBranchName());
        if (!commitsOnSameBranch.isEmpty()) {
            parentCommits.add((CommitDescriptor)Collections.max(commitsOnSameBranch));
        }
        ParentedCommitDescriptor parentedCommitDescriptor = new ParentedCommitDescriptor(this.commit, parentCommits);
        CommitDescriptorMerger commitDescriptorMerger = new CommitDescriptorMerger(commitDescriptorIndex, (CommitChildrenIndex)projectStorageSystem.openProjectIndex(CommitChildrenIndex.class, null), null);
        commitDescriptorMerger.storeCommit(parentedCommitDescriptor, false);
        CommitChildrenIndex commitChildrenIndex = (CommitChildrenIndex)projectStorageSystem.openProjectIndex(CommitChildrenIndex.class, null);
        commitChildrenIndex.insertAsChildForParents(parentedCommitDescriptor);
    }

    @TestOnly
    private @NonNull List<CommitDescriptor> getParentsFromCommitTree(ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (!projectStorageSystem.hasIndex("commit-tree")) {
            return Collections.emptyList();
        }
        CommitTree commitTree = ((CommitTreeIndex)projectStorageSystem.openProjectIndex(CommitTreeIndex.class, "commit-tree", null)).loadTree();
        ICommitTreeNode commitTreeNode = commitTree.getNodeByBranchAndAdjustedTimestamp(this.commit.getBranchName(), this.commit.getTimestamp());
        if (commitTreeNode == null) {
            return Collections.emptyList();
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        return new ArrayList<CommitDescriptor>((Collection)IStreamWithException.wrap(commitTreeNode.getParentRevisions().stream()).withException(StorageException.class).map(commitTree::getNodeByRevision).filter(Objects::nonNull).map(ICommitTreeNode::getCommitDescriptorWithAdjustedTimestamp).filter(commit -> AnalysisTriggerExecutorBase.commitIsInAnalysisBounds(commit, commitDescriptorIndex)).collect(Collectors.toList()));
    }

    @TestOnly
    private static boolean commitIsInAnalysisBounds(CommitDescriptor commit, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        return commitDescriptorIndex.getCommit(commit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TriggerCache triggerCache, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport lockSupport, Function<IAnalysisStep, SilentAutoClosable> stepExecutionWrapper) throws StorageException, TriggerCompilationException {
        this.trigger = (AnalysisTrigger)triggerCache.getTrigger(this.triggerName, ETriggerType.BLOCK, this.projectId);
        if (this.requiredDeltas.isEmpty() && this.testMode) {
            this.requiredDeltas.addAll((Collection<String>)this.trigger.getWriteStores());
        }
        AnalysisStepBase instance = this.createAnalysisStepInstanceForCurrentTrigger(globalStorageSystem);
        this.injectAnalysisStepParameters(projectStorageSystem, globalStorageSystem, lockSupport, instance);
        this.invokePostInjectionMethods(instance);
        TeamscaleLogAppender.init();
        try (SilentAutoClosable ignoredCleanup = stepExecutionWrapper.apply(instance);){
            lockSupport.lock();
            CriticalSystemStateIndex criticalSystemStateIndex = (CriticalSystemStateIndex)globalStorageSystem.openGlobalIndex(CriticalSystemStateIndex.class);
            this.result = AnalysisTriggerExecutorBase.executeAndHandleExceptions(instance, criticalSystemStateIndex, this::setCommit);
        }
        finally {
            lockSupport.unlock();
            this.loggingEvents = TeamscaleLogAppender.getLogEvents();
        }
    }

    private @NonNull AnalysisStepBase createAnalysisStepInstanceForCurrentTrigger(GlobalStorageSystem globalStorageSystem) throws TriggerCompilationException, StorageException {
        Class<? extends AnalysisStepBase> stepClass = this.trigger.getAnalysisStepClass();
        PublicProjectId publicId = AnalysisTriggerExecutorBase.lookupPublicId(this.projectId, globalStorageSystem);
        return this.createAnalysisStepInstanceForCurrentTrigger(stepClass.asSubclass(AnalysisStepBase.class), publicId);
    }

    private static @Nullable PublicProjectId lookupPublicId(InternalProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        if (projectId == null) {
            return null;
        }
        return ((ProjectIndex)globalStorageSystem.openGlobalIndex(ProjectIndex.class)).resolveProject((IProjectId)projectId).getPrimaryPublicId();
    }

    private AnalysisStepBase createAnalysisStepInstanceForCurrentTrigger(Class<? extends AnalysisStepBase> blockClass, PublicProjectId publicProjectId) throws TriggerCompilationException {
        try {
            AnalysisStepBase instance = blockClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.initAnalysisStepInstance(instance, publicProjectId);
            return instance;
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TriggerCompilationException("Could not create instance of block " + String.valueOf(blockClass) + ": " + e.getMessage(), e);
        }
    }

    protected void initAnalysisStepInstance(AnalysisStepBase instance, PublicProjectId publicProjectId) throws TriggerCompilationException, IOException {
        instance.init(new AnalysisStepContext(this.triggerName, this.commit, publicProjectId, this.profilingMonitor, this::setCommit, this.getTempDir(), this.parallelTaskExecutor, this.lockProvider));
    }

    public AnalysisTrigger getTrigger() {
        if (this.trigger == null) {
            throw new IllegalStateException("No trigger stored. Has execute() been called?");
        }
        return this.trigger;
    }

    private void injectAnalysisStepParameters(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport crossProjectLockSupport, AnalysisStepBase instance) throws StorageException, TriggerCompilationException, AssertionError {
        this.injectAnalysisStepIndices(projectStorageSystem, crossProjectLockSupport, instance);
        for (EIndexAccessMode accessMode : ORDERED_ACCESS_MODES) {
            for (AnalysisStepGlobalIndexAccess globalIndexAccess : this.trigger.getAnalysisStepInitializer().getGlobalIndexAccesses().getOrDefault((Object)accessMode, Collections.emptyList())) {
                globalIndexAccess.setValue(instance, this.openGlobalIndex(globalIndexAccess, globalStorageSystem, crossProjectLockSupport));
            }
        }
        for (AnalysisStepBranchingLayerAccess branchingLayerAccess : this.trigger.getAnalysisStepInitializer().getBranchingLayerAccesses()) {
            branchingLayerAccess.setValue(instance, this.openBranchingLayer(branchingLayerAccess, (SchemaAwareStorageSystem)projectStorageSystem, crossProjectLockSupport));
        }
        for (AnalysisStepDeltaSource source : this.trigger.getAnalysisStepInitializer().getDeltaSources()) {
            IIndexDelta delta = this.getDeltaForIndex(this.trigger.renameStoreName(source.getIndexName()), source.getIndexClass());
            this.inputDeltas.add(delta);
            source.setDelta(instance, delta);
        }
        this.injectTriggerParameters(instance);
    }

    private void injectAnalysisStepIndices(ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport, AnalysisStepBase instance) throws StorageException, TriggerCompilationException {
        Map<EIndexAccessMode, List<AnalysisStepIndexAccess>> indexAccesses = this.trigger.getAnalysisStepInitializer().getIndexAccesses();
        for (EIndexAccessMode accessMode : ORDERED_ACCESS_MODES) {
            for (AnalysisStepIndexAccess indexAccess : indexAccesses.getOrDefault((Object)accessMode, Collections.emptyList())) {
                indexAccess.setValue(instance, this.openProjectIndex(indexAccess, projectStorageSystem, crossProjectLockSupport));
            }
        }
    }

    private void injectTriggerParameters(AnalysisStepBase instance) throws TriggerCompilationException {
        HashMap<String, Object> parameterValueCache = new HashMap<String, Object>();
        for (AnalysisStepParameter parameter : this.trigger.getAnalysisStepInitializer().getAnalysisStepParameters()) {
            String parameterName = parameter.getName();
            Optional<TriggerDescription.Parameter<String>> value = this.triggerDescription.getTriggerParameters().getParameter(parameterName);
            if (value.isEmpty()) {
                if (parameter.isOptional()) continue;
                throw new TriggerCompilationException("Expected parameter for " + String.valueOf(parameter));
            }
            if (!parameterValueCache.containsKey(parameterName)) {
                parameterValueCache.put(parameterName, parameter.parseValue(value.get()));
            }
            parameter.setValue(instance, parameterValueCache.get(parameterName));
        }
        this.checkForUnusedTriggerParameters();
    }

    private void checkForUnusedTriggerParameters() {
        HashSet unusedParameters = CollectionUtils.differenceSet(this.triggerDescription.getTriggerParameters().getParameterKeys(), (Collection[])new Collection[]{CollectionUtils.map(this.trigger.getAnalysisStepInitializer().getAnalysisStepParameters(), AnalysisStepParameter::getName)});
        if (!unusedParameters.isEmpty()) {
            LOGGER.error("Parameters supplied but not used by " + this.triggerName + ": " + String.valueOf(unusedParameters));
        }
    }

    private void invokePostInjectionMethods(AnalysisStepBase instance) {
        for (AnalysisStepPostInjectionMethod method : this.trigger.getAnalysisStepInitializer().getPostInjectionMethods()) {
            method.invoke(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TriggerExecutionResultWrapper executeAndHandleExceptions(IAnalysisStep step, CriticalSystemStateIndex criticalSystemStateIndex, Consumer<CommitDescriptor> outputCommitOverwrite) {
        try {
            step.execute();
            TriggerExecutionResultWrapper triggerExecutionResultWrapper = new TriggerExecutionResultWrapper(ETriggerExecutionResult.RUN_SUCCESSFULLY);
            return triggerExecutionResultWrapper;
        }
        catch (OutOfMemoryError e) {
            try {
                criticalSystemStateIndex.setStatus(CriticalSystemStateIndex.CriticalSystemStatus.createOutOfMemoryStatus());
            }
            catch (StorageException storageException) {
                LOGGER.error("Error writing critical system status: " + storageException.getMessage(), (Throwable)storageException);
            }
            TriggerExecutionResultWrapper triggerExecutionResultWrapper = new TriggerExecutionResultWrapper(AnalysisTriggerExecutorBase.handleFatalExecutionError(step, e, outputCommitOverwrite));
            return triggerExecutionResultWrapper;
        }
        catch (RescheduleRequestedException e) {
            LOGGER.atInfo().withThrowable((Throwable)e).log(e.getMessage());
            TriggerExecutionResultWrapper triggerExecutionResultWrapper = TriggerExecutionResultWrapper.forException(ETriggerExecutionResult.RESCHEDULE_REQUESTED, e);
            return triggerExecutionResultWrapper;
        }
        catch (ExecutionCanceledException e) {
            TriggerExecutionResultWrapper triggerExecutionResultWrapper = TriggerExecutionResultWrapper.forException(ETriggerExecutionResult.RUN_SUCCESSFULLY, e);
            return triggerExecutionResultWrapper;
        }
        catch (Throwable t) {
            TriggerExecutionResultWrapper triggerExecutionResultWrapper = TriggerExecutionResultWrapper.forException(AnalysisTriggerExecutorBase.handleFatalExecutionError(step, t, outputCommitOverwrite), t);
            return triggerExecutionResultWrapper;
        }
        finally {
            if (step.isCanceled()) {
                LOGGER.warn("Execution was canceled");
            }
        }
    }

    private static @NonNull ETriggerExecutionResult handleFatalExecutionError(IAnalysisStep step, Throwable t, Consumer<CommitDescriptor> outputCommitOverwrite) {
        if (t instanceof RepositoryNeedsRollbackException) {
            RepositoryNeedsRollbackException rollbackException = (RepositoryNeedsRollbackException)((Object)t);
            LOGGER.error((Message)new RollbackLogMessage("Execution failed, requested reschedule: " + t.getMessage(), rollbackException.getRollbackId()), t);
            outputCommitOverwrite.accept((CommitDescriptor)new RollbackRequestedCommitDescriptor(rollbackException.getRollbackToAsSchedulingHints(), rollbackException.getMessage(), rollbackException.getRollbackId()));
            return ETriggerExecutionResult.ROLLBACK_REQUESTED;
        }
        if (step.shouldRescheduleOnError()) {
            LOGGER.error("Execution failed, requested reschedule: " + t.getMessage(), t);
            return ETriggerExecutionResult.RESCHEDULE_REQUESTED;
        }
        if (t.getClass().getSimpleName().equals(REPOSITORY_NEEDS_RESCHEDULE_EXCEPTION_NAME)) {
            LOGGER.warn("Trigger requested a reschedule, but is not reschedulable. For periodic triggers, this just means they will run again in their regular intervals instead of being immediately rescheduled: " + t.getMessage(), t);
            return ETriggerExecutionResult.RUN_SUCCESSFULLY;
        }
        LOGGER.fatal("Execution failed badly: " + t.getMessage(), t);
        return ETriggerExecutionResult.FAILED_BADLY;
    }

    private IBranchingLayer openBranchingLayer(AnalysisStepBranchingLayerAccess branchingLayerAccess, SchemaAwareStorageSystem schemaAwareStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        String storeName = this.trigger.renameStoreName(branchingLayerAccess.getIndexName());
        IndexSchema schema = schemaAwareStorageSystem.getSchema();
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        if (schemaEntry == null) {
            throw new TriggerCompilationException("Could not find entry for store " + storeName + " in the schema!");
        }
        if (schemaEntry.usesOption(EStorageOption.VIRTUAL)) {
            throw new TriggerCompilationException("Can not access branching layer for store " + storeName + " as it is marked virtual!");
        }
        IStore rawStore = IndexSchema.applyStoreOptions((SchemaEntry)schemaEntry, (IStore)schemaAwareStorageSystem.openStore(storeName), (boolean)true, null, (IStorageSystem)schemaAwareStorageSystem, null);
        crossProjectLockSupport.collectNeededLocks(schemaEntry, rawStore);
        return IBranchingLayer.create((IStore)rawStore, (SchemaEntry)schemaEntry);
    }

    private Object openGlobalIndex(AnalysisStepIndexAccessBase indexAccess, GlobalStorageSystem globalStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException {
        try {
            return switch (indexAccess.getAccessMode()) {
                case EIndexAccessMode.READ_ONLY, EIndexAccessMode.READ_WRITE -> this.openIndexPlain(indexAccess, (SchemaAwareStorageSystem)globalStorageSystem, crossProjectLockSupport);
                default -> CCSMAssert.fail((String)"Access mode not supported for global storage system.");
            };
        }
        catch (AssertionError e) {
            throw AnalysisTriggerExecutorBase.errorWithIndexAccessInfo(e, indexAccess);
        }
    }

    private Object openProjectIndex(AnalysisStepIndexAccessBase indexAccess, ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        try {
            return switch (indexAccess.getAccessMode()) {
                default -> throw new MatchException(null, null);
                case EIndexAccessMode.READ_ONLY, EIndexAccessMode.READ_WRITE -> this.openIndexPlain(indexAccess, (SchemaAwareStorageSystem)projectStorageSystem, crossProjectLockSupport);
                case EIndexAccessMode.PREVIOUS_REVISION_READ_ONLY -> {
                    List<IStorageIndex> indices = this.openPreviousIndex(indexAccess, projectStorageSystem, crossProjectLockSupport);
                    if (indices.isEmpty() && this.commit == null) {
                        yield null;
                    }
                    yield indices.getFirst();
                }
                case EIndexAccessMode.ALL_PARENT_REVISIONS_READ_ONLY -> new ArrayList(this.openPreviousIndex(indexAccess, projectStorageSystem, crossProjectLockSupport));
            };
        }
        catch (AssertionError e) {
            throw AnalysisTriggerExecutorBase.errorWithIndexAccessInfo(e, indexAccess);
        }
    }

    private static @NonNull AssertionError errorWithIndexAccessInfo(AssertionError assertionError, AnalysisStepIndexAccessBase indexAccess) {
        return new AssertionError("Could not open index " + indexAccess.getIndexName() + " in mode " + String.valueOf((Object)indexAccess.getAccessMode()), (Throwable)((Object)assertionError));
    }

    private IStorageIndex openIndexPlain(AnalysisStepIndexAccessBase indexAccess, SchemaAwareStorageSystem schemaAwareStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException {
        IStorageIndex index;
        IndexSchema schema = schemaAwareStorageSystem.getSchema();
        String storeName = this.trigger.renameStoreName(indexAccess.getIndexName());
        if (this.openIndexes.containsKey(storeName)) {
            return this.openIndexes.get(storeName);
        }
        boolean readOnly = indexAccess.getAccessMode() == EIndexAccessMode.READ_ONLY;
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        boolean virtual = schemaEntry.usesOption(EStorageOption.VIRTUAL);
        IStoreDecorator decorator = this.getDecoratorToApply(storeName, readOnly, virtual);
        if (schemaEntry.isHistorized()) {
            CCSMAssert.isFalse((this.commit == null ? 1 : 0) != 0, (String)("Expected valid commit for accessing historized store " + storeName + " but was null"));
            Optional<HistoryAccessOption> historyAccess = this.determineHistoryAccess(storeName, schemaEntry, readOnly, schemaAwareStorageSystem);
            index = historyAccess.isPresent() ? schemaAwareStorageSystem.openIndex(schemaEntry.createIndexClass(), storeName, historyAccess.get(), virtualStoreName -> this.openVirtualStore((String)virtualStoreName, readOnly), decorator) : AnalysisTriggerExecutorBase.createIndexForCommit(null, storeName, schemaEntry.createIndexClass(), schemaAwareStorageSystem, decorator);
        } else {
            index = schemaAwareStorageSystem.openIndex(schemaEntry.createIndexClass(), storeName, null, virtualStoreName -> this.openVirtualStore((String)virtualStoreName, readOnly), decorator);
        }
        crossProjectLockSupport.collectNeededLocks(schemaEntry, index);
        this.openIndexes.put(storeName, index);
        return index;
    }

    private List<IStorageIndex> openPreviousIndex(AnalysisStepIndexAccessBase indexAccess, ProjectStorageSystem projectStorageSystem, ICrossProjectLockSupport crossProjectLockSupport) throws StorageException, TriggerCompilationException {
        IndexSchema schema = projectStorageSystem.getSchema();
        String storeName = this.trigger.renameStoreName(indexAccess.getIndexName());
        if (this.openedPreviousIndexes.containsKey(storeName)) {
            return this.openedPreviousIndexes.get(storeName);
        }
        SchemaEntry schemaEntry = schema.getEntry(storeName);
        if (schemaEntry.usesOption(EStorageOption.VIRTUAL)) {
            throw new TriggerCompilationException("Can not open previous version of store " + storeName + " as this is marked as virtual!");
        }
        CCSMAssert.isTrue((boolean)schemaEntry.isHistorized(), (String)"Expected historized store!");
        IBranchingLayer branchingLayer = projectStorageSystem.openBranchingLayer(storeName, schemaEntry.createIndexClass());
        List<IStorageIndex> result = this.openPreviousIndexesForAnalysisStep(projectStorageSystem, storeName, branchingLayer, schemaEntry.createIndexClass());
        crossProjectLockSupport.collectNeededLocks(schemaEntry, projectStorageSystem.openStore(storeName));
        this.openedPreviousIndexes.put(storeName, result);
        return result;
    }

    private List<IStorageIndex> openPreviousIndexesForAnalysisStep(ProjectStorageSystem projectStorageSystem, String storeName, IBranchingLayer branchingLayer, Class<? extends IStorageIndex> indexClass) throws StorageException {
        if (this.commit == null) {
            return Collections.emptyList();
        }
        if (!this.trigger.isReadOnlyPreviousAllParentsStore(storeName)) {
            return List.of(AnalysisTriggerExecutorBase.createIndexForCommit(this.commitResolver.resolveCommit(this.getParentCommit(projectStorageSystem), branchingLayer, projectStorageSystem).orElse(null), storeName, indexClass, (SchemaAwareStorageSystem)projectStorageSystem, null));
        }
        List<CommitDescriptor> allParents = this.getParentCommits(projectStorageSystem);
        return CollectionUtils.mapWithException(allParents, parent -> AnalysisTriggerExecutorBase.createIndexForCommit(this.commitResolver.resolveCommit((CommitDescriptor)parent, branchingLayer, projectStorageSystem).orElse(null), storeName, indexClass, (SchemaAwareStorageSystem)projectStorageSystem, null));
    }

    private Optional<HistoryAccessOption> determineHistoryAccess(String storeName, SchemaEntry schemaEntry, boolean readOnly, SchemaAwareStorageSystem schemaAwareStorageSystem) throws AssertionError, StorageException {
        if (schemaEntry.usesOption(EStorageOption.BRANCHED)) {
            CCSMAssert.isInstanceOf((Object)schemaAwareStorageSystem, ProjectStorageSystem.class);
            IBranchingLayer branchingLayer = schemaAwareStorageSystem.openBranchingLayer(storeName, schemaEntry.createIndexClass());
            return this.determineBranchedHistoryAccess(readOnly, (ProjectStorageSystem)schemaAwareStorageSystem, branchingLayer);
        }
        return Optional.of(this.determineNonBranchedHistoryAccess(readOnly));
    }

    private HistoryAccessOption determineNonBranchedHistoryAccess(boolean readOnly) {
        if (readOnly) {
            return HistoryAccessOption.readTimestampUnbranched((long)this.commit.getTimestamp());
        }
        return HistoryAccessOption.readHeadWriteTimestampUnbranched((long)this.commit.getTimestamp());
    }

    private Optional<HistoryAccessOption> determineBranchedHistoryAccess(boolean readOnly, ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws AssertionError, StorageException {
        if (readOnly) {
            return this.determineBranchedReadOnlyHistoryAccess(projectStorageSystem, branchingLayer);
        }
        return Optional.of(this.determineBranchedReadWriteHistoryAccess(projectStorageSystem, branchingLayer));
    }

    private Optional<HistoryAccessOption> determineBranchedReadOnlyHistoryAccess(ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws StorageException {
        Optional<CommitDescriptor> resolvedCommit = this.commitResolver.resolveCommit(this.commit, branchingLayer, projectStorageSystem);
        return resolvedCommit.map(commitDescriptor -> HistoryAccessOption.readTimestamp((String)commitDescriptor.getBranchName(), (long)commitDescriptor.getTimestamp()));
    }

    private @NonNull HistoryAccessOption determineBranchedReadWriteHistoryAccess(ProjectStorageSystem projectStorageSystem, IBranchingLayer branchingLayer) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readHeadWriteTimestamp((String)this.commit.getBranchName(), (long)this.commit.getTimestamp());
        Optional<CommitDescriptor> parentCommit = this.commitResolver.resolveCommit(this.getParentCommit(projectStorageSystem), branchingLayer, projectStorageSystem);
        parentCommit.ifPresent(commitDescriptor -> historyAccess.setExplicitParentCommit(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp()));
        return historyAccess;
    }

    private List<CommitDescriptor> getParentCommits(ProjectStorageSystem projectStorageSystem) throws StorageException {
        CCSMAssert.isFalse((this.commit == null ? 1 : 0) != 0, (String)("Expected valid commit for accessing historized store " + (String)CollectionUtils.getAny(this.trigger.getReadOnlyPreviousStores()) + " but was null"));
        CommitDescriptor commitDescriptor = this.commit;
        if (commitDescriptor instanceof ParentedCommitDescriptor) {
            ParentedCommitDescriptor parentedCommit = (ParentedCommitDescriptor)commitDescriptor;
            return parentedCommit.getParentCommits();
        }
        return this.commitResolver.getFirstActualCommitBeforeOrAt(this.commit, projectStorageSystem).map(ParentedCommitDescriptor::getParentCommits).orElseGet(Collections::emptyList);
    }

    private CommitDescriptor getParentCommit(ProjectStorageSystem projectStorageSystem) throws StorageException {
        List<CommitDescriptor> parentCommits = this.getParentCommits(projectStorageSystem);
        if (parentCommits.isEmpty()) {
            return null;
        }
        return parentCommits.getFirst();
    }

    private static IStorageIndex createIndexForCommit(CommitDescriptor commit, String storeName, Class<? extends IStorageIndex> indexClass, SchemaAwareStorageSystem schemaAwareStorageSystem, @Nullable IStoreDecorator decorator) throws StorageException {
        if (commit == null) {
            return AnalysisTriggerExecutorBase.createIndexForNullCommit(storeName, indexClass, schemaAwareStorageSystem, decorator);
        }
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp());
        return schemaAwareStorageSystem.openIndex(indexClass, storeName, historyAccess, decorator);
    }

    private static IStorageIndex createIndexForNullCommit(String storeName, Class<? extends IStorageIndex> indexClass, SchemaAwareStorageSystem schemaAwareStorageSystem, @Nullable IStoreDecorator decorator) throws StorageException {
        try {
            InMemoryStore store = new InMemoryStore();
            if (decorator != null) {
                store = decorator.decorate((IStore)store);
            }
            if (schemaAwareStorageSystem.getSchema().getEntry(storeName).usesOption(EStorageOption.ABBREVIATE_STRINGS)) {
                IStorageAbbreviator abbreviator = schemaAwareStorageSystem.getAbbreviator();
                store = new StoreWithAbbreviationSupport((IStore)store, abbreviator);
            }
            return indexClass.getConstructor(IStore.class).newInstance(store);
        }
        catch (Exception e) {
            throw new StorageException("Failed to create index for " + storeName + " (index class " + String.valueOf(indexClass) + ")", (Throwable)e);
        }
    }

    protected abstract Path getTempDir();

    protected abstract IIndexDelta getDeltaForIndex(String var1, Class<? extends IStorageIndex> var2) throws StorageException;

    protected abstract IStore openVirtualStore(String var1, boolean var2) throws StorageException;

    private IStoreDecorator getDecoratorToApply(String storeName, boolean readOnly, boolean virtual) {
        if (readOnly) {
            return ReadOnlyStore::new;
        }
        if (this.requiredDeltas.contains(storeName)) {
            return store -> {
                RecordingStore recordingStore = new RecordingStore(store, virtual);
                this.recordingStores.add((Object)storeName, (Object)recordingStore);
                return recordingStore;
            };
        }
        return null;
    }

    public UnmodifiableList<IIndexDelta> getInputDeltas() {
        return CollectionUtils.asUnmodifiable(this.inputDeltas);
    }

    protected abstract InternalProjectId getProjectId();

    public void setProfilingMonitor(IProfilingMonitor profilingMonitor) {
        this.profilingMonitor = profilingMonitor;
    }

    protected UnmodifiableMap<String, IStorageIndex> getOpenIndexes() {
        return CollectionUtils.asUnmodifiable(this.openIndexes);
    }

    static {
        ArrayList<EIndexAccessMode> accessModes = new ArrayList<EIndexAccessMode>(Arrays.asList(EIndexAccessMode.values()));
        accessModes.removeAll(ORDERED_ACCESS_MODES);
        CCSMAssert.isTrue((boolean)accessModes.isEmpty(), () -> "Unexpected index access mode(s): %s".formatted(accessModes));
    }
}

