/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.worker;

import com.teamscale.core.analysis.IIndexDelta;
import com.teamscale.core.analysis.IProfilingMonitor;
import com.teamscale.core.analysis.trigger.AnalysisStepContext;
import com.teamscale.core.analysis.trigger.IAnalysisStep;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.impl.analysis.trigger.PrivilegedTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.runtime.impl.worker.AnalysisTriggerExecutorBase;
import com.teamscale.core.runtime.impl.worker.ITriggerExecutor;
import com.teamscale.core.runtime.impl.worker.TriggerExecutionResultWrapper;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.core.LogEvent;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.lang.SilentAutoClosable;
import org.jspecify.annotations.NonNull;

class PrivilegedTriggerExecutor
implements ITriggerExecutor {
    private final ScheduledJob scheduledJob;
    private final IndexLayer indexLayer;
    private final ILockProvider lockProvider;
    private final InstanceConfiguration instanceConfiguration;
    private final Path tempDirectory;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final IProfilingMonitor profilingMonitor;
    private final PrivilegedTrigger trigger;
    private UnmodifiableList<LogEvent> logEvents = CollectionUtils.emptyList();
    private TriggerExecutionResultWrapper result;
    private CommitDescriptor commit;

    public PrivilegedTriggerExecutor(ScheduledJob scheduledJob, IndexLayer indexLayer, ILockProvider lockProvider, InstanceConfiguration instanceConfiguration, Path tempDirectory, IParallelTaskExecutor parallelTaskExecutor, IProfilingMonitor profilingMonitor) throws TriggerCompilationException {
        this.scheduledJob = scheduledJob;
        this.indexLayer = indexLayer;
        this.lockProvider = lockProvider;
        this.instanceConfiguration = instanceConfiguration;
        this.tempDirectory = tempDirectory;
        this.parallelTaskExecutor = parallelTaskExecutor;
        this.profilingMonitor = profilingMonitor;
        this.commit = scheduledJob.getSchedulingCommit();
        this.trigger = PrivilegedTrigger.createTrigger(scheduledJob.getTriggerName());
    }

    @Override
    public UnmodifiableList<IIndexDelta> getInputDeltas() {
        return CollectionUtils.emptyList();
    }

    @Override
    public TriggerExecutionResultWrapper getExecutionResult() {
        if (this.result == null) {
            throw new IllegalStateException("No result computed yet");
        }
        return this.result;
    }

    @Override
    public UnmodifiableList<LogEvent> getLoggingEvents() {
        return this.logEvents;
    }

    @Override
    public Optional<CommitDescriptor> getCommit() {
        return Optional.ofNullable(this.commit);
    }

    @Override
    public PrivilegedTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public Map<String, Long> getWrittenVirtualStoreNameToId() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Function<IAnalysisStep, SilentAutoClosable> wrapper) throws StorageException, IOException {
        PrivilegedTriggerBase runtimeDelegate = this.trigger.getTriggerImplementation();
        runtimeDelegate.init(this.scheduledJob.getJob(), this.indexLayer, this.lockProvider, this.instanceConfiguration, this.createContext(), this.scheduledJob.getRetryCount());
        TeamscaleLogAppender.init();
        try (SilentAutoClosable ignoredCleanup = wrapper.apply(runtimeDelegate);){
            this.result = AnalysisTriggerExecutorBase.executeAndHandleExceptions(runtimeDelegate, this.indexLayer.openGlobalIndex(CriticalSystemStateIndex.class), this::setOutputCommit);
        }
        finally {
            this.logEvents = TeamscaleLogAppender.getLogEvents();
        }
    }

    private void setOutputCommit(CommitDescriptor commit) {
        this.commit = commit;
    }

    private @NonNull AnalysisStepContext createContext() throws IOException, StorageException {
        return new AnalysisStepContext(this.scheduledJob.getTriggerName(), this.scheduledJob.getSchedulingCommit(), this.indexLayer.resolveToPrimaryPublicProjectId((IProjectId)this.scheduledJob.getJob().getInternalProjectId()), this.profilingMonitor, this::setOutputCommit, this.tempDirectory, this.parallelTaskExecutor, this.lockProvider);
    }
}

