/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.cpp.misra.switches.SwitchClauseIsTerminatedByBreakStatementCheck;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.SubTypeNames;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.SwitchStatementUtils;
import java.util.EnumSet;
import java.util.Optional;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class WellFormedSwitchCheckVisitor
implements IShallowEntityVisitor {
    private static final String ASSERT = "assert";
    private ESwitchNodeTypes currentNodeType;
    private String findingMessage = "`switch` statement is incomplete. Maybe an exit statement such as `break` is missing?";
    private String invalidExitMessage = "";
    private ShallowEntity currentEntity;
    private boolean lastStatementHitInCaseOrDefaultBlockIsReturn = false;
    private boolean lastStatementHitIsFallthroughAttribute = false;
    private ShallowEntity lastCaseEntity;
    private final EnumSet<ESwitchNodeTypes> validExitStates = EnumSet.of(ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_LIST, ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_EXIT_STATEMENT, ESwitchNodeTypes.EXIT_STATEMENT);
    private final ICheckContext context;

    WellFormedSwitchCheckVisitor(ICheckContext context, boolean ignoreMissingBreakStatementInDefaultCase) {
        this.context = context;
        if (ignoreMissingBreakStatementInDefaultCase) {
            this.validExitStates.add(ESwitchNodeTypes.FINAL_DEFAULT_SWITCH_CLAUSE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean visit(ShallowEntity entity) {
        if (this.hasError() || SubTypeNames.LOOP_SUB_TYPE_NAMES.contains(entity.getSubtype()) || entity.getSubtype().equals("pragma directive")) {
            return false;
        }
        this.currentEntity = entity;
        if (SwitchStatementUtils.isSwitch((ShallowEntity)entity)) {
            if (this.currentNodeType != null) return false;
            this.currentNodeType = ESwitchNodeTypes.SWITCH_STATEMENT;
            return entity.hasChildren();
        } else if (SwitchStatementUtils.isCase((ShallowEntity)entity)) {
            this.handleCase(entity);
            return entity.hasChildren();
        } else if (SwitchStatementUtils.isDefault((ShallowEntity)entity)) {
            this.handleDefault(entity);
            return entity.hasChildren();
        } else if (this.isExitStatement(entity) || this.hasDefaultCaseExitStatement(entity)) {
            this.handleExitStatement();
            return entity.hasChildren();
        } else if (entity.getSubtype().equals("empty statement")) {
            this.handleEmptyStatement(entity);
            return entity.hasChildren();
        } else {
            if (SwitchStatementUtils.isAnonymousBlock((ShallowEntity)entity)) return entity.hasChildren();
            this.handleStatements(entity);
        }
        return entity.hasChildren();
    }

    public void endVisit(ShallowEntity entity) {
        if (SwitchStatementUtils.isSwitch((ShallowEntity)entity) && this.currentNodeType == ESwitchNodeTypes.FINAL_DEFAULT_SWITCH_CLAUSE && this.lastStatementHitInCaseOrDefaultBlockIsReturn) {
            this.currentNodeType = ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_EXIT_STATEMENT;
        }
    }

    private boolean isExitStatement(ShallowEntity entity) {
        boolean isCaseOrDefaultExitStatement = LanguageFeatureParser.CPP.isCaseOrDefaultExitStatement(entity, SwitchClauseIsTerminatedByBreakStatementCheck.determineAdditionalExitNames(this.context), false);
        boolean isInSwitchOrAnonymousBlock = SwitchStatementUtils.isSwitch((ShallowEntity)entity.getParent()) || SwitchStatementUtils.isAnonymousBlock((ShallowEntity)entity.getParent());
        return isCaseOrDefaultExitStatement && !WellFormedSwitchCheckVisitor.isInLambda(entity) && isInSwitchOrAnonymousBlock;
    }

    private boolean hasDefaultCaseExitStatement(ShallowEntity entity) {
        if (this.currentNodeType != ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_LIST || entity.getType() != EShallowEntityType.STATEMENT) {
            return false;
        }
        return WellFormedSwitchCheckVisitor.hasAssertMethod(entity);
    }

    private static boolean hasAssertMethod(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        Optional<IToken> assertToken = tokens.stream().filter(token -> token.getText().equals(ASSERT)).findFirst();
        if (assertToken.isEmpty()) {
            return false;
        }
        int assertTokenIndex = tokens.indexOf(assertToken.get());
        return ((IToken)tokens.get(assertTokenIndex + 1)).getType() == ETokenType.LPAREN;
    }

    private void handleCase(ShallowEntity entity) {
        String findingMessage = "Expecting an exit statement before `case` clause";
        switch (this.currentNodeType.ordinal()) {
            case 0: {
                this.currentNodeType = ESwitchNodeTypes.FIRST_CASE_LABEL_CLAUSE_LIST;
                break;
            }
            case 3: {
                this.currentNodeType = ESwitchNodeTypes.CASE_LABEL_CLAUSE_LIST;
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (this.lastStatementHitInCaseOrDefaultBlockIsReturn || this.lastStatementHitIsFallthroughAttribute) {
                    this.currentNodeType = ESwitchNodeTypes.CASE_LABEL_CLAUSE_LIST;
                    break;
                }
                this.error(findingMessage);
                break;
            }
            default: {
                this.error(findingMessage);
            }
        }
        this.lastCaseEntity = entity;
        this.lastStatementHitInCaseOrDefaultBlockIsReturn = false;
        this.lastStatementHitIsFallthroughAttribute = false;
    }

    private void handleDefault(ShallowEntity entity) {
        String findingMessage = "Expecting an exit statement before `default` clause";
        switch (this.currentNodeType.ordinal()) {
            case 3: 
            case 4: {
                this.currentNodeType = ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_LIST;
                break;
            }
            case 2: {
                if (this.lastStatementHitInCaseOrDefaultBlockIsReturn || this.lastStatementHitIsFallthroughAttribute) {
                    this.currentNodeType = ESwitchNodeTypes.CASE_LABEL_CLAUSE_LIST;
                    break;
                }
                this.error(findingMessage);
                break;
            }
            case 0: {
                this.currentNodeType = ESwitchNodeTypes.FIRST_CASE_LABEL_CLAUSE_LIST;
                break;
            }
            default: {
                this.error(findingMessage);
            }
        }
        this.lastCaseEntity = entity;
        this.lastStatementHitInCaseOrDefaultBlockIsReturn = false;
        this.lastStatementHitIsFallthroughAttribute = false;
    }

    private void handleExitStatement() {
        switch (this.currentNodeType.ordinal()) {
            case 1: 
            case 2: 
            case 4: {
                this.currentNodeType = ESwitchNodeTypes.EXIT_STATEMENT;
                break;
            }
            case 5: 
            case 6: {
                this.currentNodeType = ESwitchNodeTypes.FINAL_DEFAULT_CLAUSE_EXIT_STATEMENT;
                break;
            }
            default: {
                this.error("Unnecessary `exit` statement");
            }
        }
    }

    private void handleEmptyStatement(ShallowEntity entity) {
        this.lastStatementHitIsFallthroughAttribute = SwitchStatementUtils.isFallThroughAttribute((ICheckContext)this.context, (ShallowEntity)this.lastCaseEntity, (ShallowEntity)entity);
        switch (this.currentNodeType.ordinal()) {
            case 1: 
            case 4: {
                this.currentNodeType = ESwitchNodeTypes.SWITCH_CLAUSE;
                break;
            }
            case 5: {
                this.currentNodeType = ESwitchNodeTypes.FINAL_DEFAULT_SWITCH_CLAUSE;
                this.setInvalidExitMessage("Expecting an exit statement at end of `default` clause");
                break;
            }
        }
    }

    private void handleStatements(ShallowEntity entity) {
        String shallowEntityName = entity.getName();
        this.lastStatementHitInCaseOrDefaultBlockIsReturn = shallowEntityName != null && shallowEntityName.equals("return");
        this.lastStatementHitIsFallthroughAttribute = SwitchStatementUtils.isFallThroughAttribute((ICheckContext)this.context, (ShallowEntity)this.lastCaseEntity, (ShallowEntity)entity);
        switch (this.currentNodeType.ordinal()) {
            case 1: 
            case 4: {
                this.currentNodeType = ESwitchNodeTypes.SWITCH_CLAUSE;
                break;
            }
            case 5: {
                this.currentNodeType = ESwitchNodeTypes.FINAL_DEFAULT_SWITCH_CLAUSE;
                this.setInvalidExitMessage("Expecting an exit statement at end of `default` clause");
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            default: {
                this.error("Expecting an exit statement at end of `case` or `default` clause");
            }
        }
    }

    private void error(String message) {
        CCSMAssert.isNotEmpty((String)message, (String)"The error message must be defined");
        this.findingMessage = message;
        this.currentNodeType = ESwitchNodeTypes.ERROR;
    }

    private void setInvalidExitMessage(String message) {
        CCSMAssert.isNotEmpty((String)message, (String)"The error message must be defined");
        this.invalidExitMessage = message;
    }

    private static boolean isInLambda(ShallowEntity entity) {
        ShallowEntity parent = entity.getParent();
        if (parent == null || parent.getType() == null || parent.getSubtype() == null) {
            return false;
        }
        return parent.getType() == EShallowEntityType.METHOD && (parent.getSubtype().equals("lambda expression") || parent.getSubtype().equals("block expression"));
    }

    boolean isInExitState() {
        return this.validExitStates.contains((Object)this.currentNodeType);
    }

    private boolean hasError() {
        return this.currentNodeType == ESwitchNodeTypes.ERROR;
    }

    String getFindingMessage() {
        if (!(this.hasError() || this.isInExitState() || this.invalidExitMessage.isEmpty())) {
            return this.invalidExitMessage;
        }
        return this.findingMessage;
    }

    ShallowEntity getCurrentEntity() {
        return this.currentEntity;
    }

    static enum ESwitchNodeTypes {
        SWITCH_STATEMENT,
        FIRST_CASE_LABEL_CLAUSE_LIST,
        SWITCH_CLAUSE,
        EXIT_STATEMENT,
        CASE_LABEL_CLAUSE_LIST,
        FINAL_DEFAULT_CLAUSE_LIST,
        FINAL_DEFAULT_SWITCH_CLAUSE,
        FINAL_DEFAULT_CLAUSE_EXIT_STATEMENT,
        ERROR;

    }
}

