/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-pointers-should-not-be-visible", languages={ELanguage.CS}, parameters={ECheckParameter.TYPE_RESOLUTION, ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class PointersShouldNotBeVisibleCheck
extends CheckImplementationBase {
    private static final Set<String> POINTER_TYPE_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"System.IntPtr", "System.UIntPtr"});

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            for (ShallowEntity child : type.getChildren()) {
                if (child.getType() != EShallowEntityType.ATTRIBUTE || !TokenStreamUtils.containsAny((List)child.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.PUBLIC, ETokenType.PROTECTED}) || TokenStreamUtils.contains((List)child.ownStartTokens(), (ETokenType)ETokenType.READONLY)) continue;
                this.processEntity(child);
            }
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        String fieldName;
        List fieldNames = LanguageFeatureParser.CS.getVariableNamesFromTokens((List)entity.ownStartTokens());
        if (fieldNames.isEmpty()) {
            return;
        }
        ScopedTypeLookup typeLookup = this.context.getTypeResolution(ECodeViewOption.FILTERED).getTypeLookup(entity);
        if (!typeLookup.containsVariable(fieldName = ((IToken)CollectionUtils.getAny((Iterable)fieldNames)).getText())) {
            return;
        }
        for (String illegalTypeName : POINTER_TYPE_NAMES) {
            if (!typeLookup.hasFullyQualifiedTypeName(fieldName, illegalTypeName)) continue;
            this.buildFinding("Fields of type `" + illegalTypeName + "` should not be `public` or `protected` without being `readonly`", this.buildLocation().forEntity(entity)).createAndStore();
            break;
        }
    }
}

