/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.base.EntityFirstLineFindingCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-var-keyword", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class VarKeywordCheck
extends EntityFirstLineFindingCheckBase {
    @CheckOption(name="Allow var keyword for built in types", description="Allow the usage of the var keyword for built in types like var x = 1; var y = \"foo\";.")
    private boolean allowVarForBuiltInTypes = false;
    @CheckOption(name="Allow var keyword when type is apparent", description="Allow the usage of the var keyword when the type is apparent like in var x = new Bar();.")
    private boolean allowVarWhenTypeApparent = false;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!TokenStreamUtils.contains((List)statement.ownStartTokens(), (ETokenType)ETokenType.VAR)) continue;
            this.processEntity(statement);
        }
    }

    protected String getFindingMessage(ShallowEntity entity) {
        return "The `var` keyword should not be used";
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        if (!this.allowVarWhenTypeApparent && !this.allowVarForBuiltInTypes) {
            super.processEntity(entity);
            return;
        }
        UnmodifiableList statementTokens = entity.includedTokens();
        int varTokenIndex = TokenStreamUtils.firstTokenMatching((List)statementTokens, (ITokenMatcher)ETokenType.VAR);
        if (this.allowVarWhenTypeApparent) {
            if (TokenStreamUtils.hasTokenTypeSequence((List)statementTokens, (int)(varTokenIndex + 3), (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN, ETokenType.IDENTIFIER})) {
                return;
            }
            if (TokenStreamUtils.containsAny((List)statementTokens, (int)varTokenIndex, (int)statementTokens.size(), (ETokenType[])new ETokenType[]{ETokenType.NEW, ETokenType.AS})) {
                return;
            }
        } else if (((IToken)statementTokens.get(varTokenIndex + 2)).getType() == ETokenType.EQ && ((IToken)statementTokens.get(varTokenIndex + 3)).getType().getTokenClass() == ETokenType.ETokenClass.LITERAL && ((IToken)statementTokens.get(varTokenIndex + 4)).getType() == ETokenType.SEMICOLON) {
            return;
        }
        super.processEntity(entity);
    }
}

