/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.general;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.core.phase.IExtractedValue;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.phase.ITokenElementContext;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public class StringLiteralExtractorPhase
implements IGlobalExtractionPhase<StringLiteral, TextRegionLocation> {
    private static final Set<String> IGNORED_STRINGS = CollectionUtils.asHashSet((Object[])new String[]{"all", "allDeprecation", "allJavadoc", "assertIdentifier", "boxing", "cast", "charConcat", "conditionAssign", "constructorName", "dep", "deprecation", "discouraged", "divzero", "empty", "emptyBlock", "enumSwitch", "fallthrough", "fieldHiding", "finalBound", "finally", "forbidden", "hiding", "incomplete", "indirectStatic", "intfAnnotation", "intfNonInherited", "javadoc", "localHiding", "maskedCatchBlocks", "nls", "noEffectAssign", "none", "null", "nullDereference", "over", "overrides", "paramAssign", "path", "pkgDefaultMethod", "raw", "rawtypes", "restriction", "semicolon", "serial", "specialParamHiding", "static", "staticReceiver", "super", "suppress", "synthetic", "syntheticAccess", "tasks", "typeHiding", "unchecked", "unnecessaryElse", "unqualified", "unused", "unusedArgument", "unusedImport", "unusedLabel", "unusedLocal", "unusedPrivate", "unusedThrown", "uselessTypeCheck", "varargsCast", "warningToken"});

    public List<StringLiteral> extract(ITokenElementContext fileContext) throws CheckException {
        ArrayList<StringLiteral> result = new ArrayList<StringLiteral>();
        for (IToken token : fileContext.getTokens(ECodeViewOption.UNFILTERED)) {
            Optional<String> value;
            if (token.getType() != ETokenType.STRING_LITERAL || !(value = StringLiteralExtractorPhase.extractStringValue(token.getText())).isPresent()) continue;
            result.add(new StringLiteral(fileContext.getUniformPath(), value.get(), token.getOffset(), token.getEndOffset(), token.getLineNumber() + 1));
        }
        return result;
    }

    private static Optional<String> extractStringValue(String text) {
        if (text.length() < 2) {
            return Optional.empty();
        }
        int start = 1;
        if (text.charAt(0) != '\"' && text.charAt(0) != '\'') {
            ++start;
        }
        if (StringUtils.isEmpty((String)(text = text.substring(start, text.length() - 1))) || IGNORED_STRINGS.contains(text)) {
            return Optional.empty();
        }
        return Optional.of(text);
    }

    public StringLiteral createValue(String uniformPath, String value, TextRegionLocation additionalInformation) {
        CCSMAssert.isTrue((boolean)uniformPath.equals(additionalInformation.getUniformPath()), (String)("uniform paths must be equal: " + uniformPath + " vs. " + additionalInformation.getUniformPath()));
        return new StringLiteral(value, additionalInformation);
    }

    public boolean needsAccessByValue() {
        return true;
    }

    public EnumSet<ELanguage> getLanguages() {
        return EnumSet.of(ELanguage.JAVA, new ELanguage[]{ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.ESQL, ELanguage.GO});
    }

    public EnumSet<ECheckParameter> getRequiredContextParameters() {
        return EnumSet.of(ECheckParameter.ABSTRACT_SYNTAX_TREE);
    }

    @IndexValueClass
    public static class StringLiteral
    implements IExtractedValue<TextRegionLocation> {
        private final String literalValue;
        private final TextRegionLocation location;

        private StringLiteral(String uniformPath, String literalValue, int startOffset, int endOffset, int startLine) {
            this.literalValue = literalValue;
            int linesInLiteral = StringUtils.countLines((String)literalValue);
            this.location = new TextRegionLocation(uniformPath, startOffset, endOffset, startLine, startLine + (linesInLiteral - 1));
        }

        private StringLiteral(String literalValue, TextRegionLocation location) {
            this.literalValue = literalValue;
            this.location = location;
        }

        public String getUniformPath() {
            return this.location.getUniformPath();
        }

        public String getValue() {
            return this.literalValue;
        }

        public TextRegionLocation getLiteralLocation() {
            return this.location;
        }

        public TextRegionLocation getAdditionalInformation() {
            return this.getLiteralLocation();
        }

        public int hashCode() {
            return Objects.hash(this.literalValue, this.location);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            StringLiteral other = (StringLiteral)obj;
            return Objects.equals(this.literalValue, other.literalValue) && Objects.equals(this.location, other.location);
        }
    }
}

